(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1415842,      30536]
NotebookOptionsPosition[   1382729,      29800]
NotebookOutlinePosition[   1383849,      29839]
CellTagsIndexPosition[   1383806,      29836]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.5134422770858374`*^9, 3.5134422770858374`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[StyleBox["Domain Map ",
  FontSize->24]], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500321701207488*^9, 
   3.5003217014474883`*^9}, {3.5026719192141376`*^9, 
   3.5026719206441393`*^9}, {3.5027639618236465`*^9, 3.5027639715424633`*^9}, 
   3.5040443744413013`*^9, 3.5047258778634586`*^9, 3.5047259304635324`*^9, {
   3.5047296968488054`*^9, 3.5047297039888153`*^9}, {3.5047304827399054`*^9, 
   3.5047304905499163`*^9}, {3.5053445891537113`*^9, 3.505344590523713*^9}, {
   3.5100199895018682`*^9, 3.5100200070206995`*^9}, {3.510020038236354*^9, 
   3.510020038236354*^9}, {3.510170385415208*^9, 3.510170385415208*^9}, {
   3.5101743640143356`*^9, 3.5101743640143356`*^9}, {3.510420573081676*^9, 
   3.510420573081676*^9}, {3.510420642421773*^9, 3.510420642421773*^9}, {
   3.510430918288175*^9, 3.51043092210818*^9}, {3.510430958528231*^9, 
   3.510430958528231*^9}, {3.514435726645997*^9, 3.5144357958633184`*^9}, {
   3.5144359444535794`*^9, 3.514435964172014*^9}, {3.514436016057705*^9, 
   3.514436016057705*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{-4, 2}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1a\\n\[LowerRightArrow]\[DownArrow]\[DownArrow]\
\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], 3}, {-2.5, 3}]]}, 
   {RGBColor[1., 0.4, 0.4], RectangleBox[{-4, 1}, {-1, 2}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1b \[LowerRightArrow]\[DownArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], Rational[3, 2]}, {-2.5, 1.5}]]}, 
   {RGBColor[1., 0.7, 0.7], RectangleBox[{-4, 0}, {-1, 1}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1c \[LowerRightArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], 0.6}, {-2.5, 0.6}]]}, 
   {RGBColor[0.5, 0.5, 1.], RectangleBox[{-1, 2}, {0, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 2a\\n\[DownArrow]\[DownArrow]\[DownArrow]\[Diamond]\"\
\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-1, 2], 3}, {-0.5, 3}]]}, 
   {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
    LineBox[{{-0.98, 3.98}, {-0.98, 2.02}}], 
    {RGBColor[0.8, 0.8, 1.], Dashing[{}], RectangleBox[{0, 1}, {1, 4}], 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 2b\\n\[LowerLeftArrow]\[DownArrow]\[Diamond]\"\>",
        StripOnInput->False,
        FontSize->10], NCache[{Rational[1, 2], 3}, {0.5, 3}]]}, 
     {RGBColor[0, 1, 0], RectangleBox[{2, -1}, {4, 4}]}, 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 3a\\n\[LeftArrow]\[LeftArrow]\[LeftArrow]\[Diamond]\
\"\>",
        StripOnInput->False,
        FontSize->10], {3, 3}]}, 
     {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
      LineBox[{{2.02, -0.98}, {3.98, -0.98}}], 
      {RGBColor[0.7, 1., 0.7], Dashing[{}], RectangleBox[{1, 0}, {2, 4}], 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 3b\\n\[LowerLeftArrow]\[LeftArrow]\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[3, 2], 3}, {1.5, 3}]]}, 
       {RGBColor[1, 0.5, 0.5], RectangleBox[{2, -4}, {4, -1}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 4a\\n\[UpperLeftArrow]\[LeftArrow]\[LeftArrow]\
\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], {3, -2.6}]}, 
       {RGBColor[1., 0.7, 0.7], RectangleBox[{1, -4}, {2, -1}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 4b\\n\[UpperLeftArrow]\[LeftArrow]\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[3, 2], -2.6}, {1.5, -2.6}]]}, 
       {RGBColor[1., 0.7, 1.], RectangleBox[{0, -4}, {1, -1}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 5a\\n\[UpperLeftArrow]\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[1, 2], -2.6}, {0.5, -2.6}]]}, 
       {RGBColor[1., 0.3, 1.], RectangleBox[{-1, -4}, {0, -1}]}, 
       {GrayLevel[0], InsetBox[
         StyleBox["\<\"Rule 5b\\n\[UpArrow]\[Diamond]\"\>",
          StripOnInput->False,
          FontSize->10], NCache[{Rational[-1, 2], -2.6}, {-0.5, -2.6}]]}, 
       {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
        LineBox[{{-0.98, -1.02}, {-0.98, -3.98}}], 
        {RGBColor[1, 0.5, 0], Dashing[{}], RectangleBox[{-4, -4}, {-1, 0}], 
         {GrayLevel[0], InsetBox[
           StyleBox["\<\"Rule 6\\n\[RightArrow]\[Diamond]\"\>",
            StripOnInput->False,
            FontSize->10], NCache[{Rational[-5, 2], -2.6}, {-2.5, -2.6}]]}, 
         {RGBColor[0, 1, 0], Thickness[Large], LineBox[{{0, -3.98}, {0, -1}}], 
          {GrayLevel[0], GeometricTransformationBox[InsetBox[
             StyleBox["\<\"  Rule 7\[LeftArrow]\[LeftArrow]\"\>",
              StripOnInput->False,
              FontSize->10], {0.15, -3.25}], {{{0, 1}, {-1, 0}}, Center}]}, 
          {RGBColor[1, 0, 0], Thickness[Large], LineBox[{{0, 1}, {0, 3.98}}], 
           {GrayLevel[0], GeometricTransformationBox[InsetBox[
              StyleBox["\<\"  Rule  8\[RightArrow]\[RightArrow]\"\>",
               StripOnInput->False,
               FontSize->10], {0.15, 2}], {{{0, 1}, {-1, 0}}, Center}]}, 
           {RGBColor[0, 1, 0], Thickness[Large], 
            LineBox[{{-3.98, 0}, {-1, 0}}], 
            {GrayLevel[0], InsetBox[
              StyleBox["\<\"Rule 9 \[RightArrow]\[Diamond]\"\>",
               StripOnInput->False,
               FontSize->10], NCache[{Rational[-5, 2], 0.13}, {-2.5, 0.13}]]}, 
            {RGBColor[1, 0, 0], Thickness[Large], 
             LineBox[{{1, 0}, {3.98, 0}}], 
             {GrayLevel[0], InsetBox[
               StyleBox["\<\"Rule 10 \[LeftArrow]\[LeftArrow]\[Diamond]\"\>",
                StripOnInput->False,
                FontSize->10], {3, 0.13}]}, 
             {RGBColor[0.5, 0.5, 1.], Thickness[Large], 
              LineBox[{{2, -1}, {2, -3.98}}], 
              {GrayLevel[0], GeometricTransformationBox[InsetBox[
                 StyleBox["\<\" Rule 11\[LowerLeftArrow]\"\>",
                  StripOnInput->False,
                  FontSize->10], {2.15, -3.5}], {{{0, 1}, {-1, 0}}, Center}]}, 
              {RGBColor[0, 0, 1], Thickness[Large], 
               LineBox[{{2, -1}, {2, 3.98}}], 
               {GrayLevel[0], GeometricTransformationBox[InsetBox[
                  StyleBox["\<\"Rule  12 \[DownArrow]\"\>",
                   StripOnInput->False,
                   FontSize->10], {2.15, 2}], {{{0, 1}, {-1, 0}}, Center}]}, 
               {GrayLevel[0], Thickness[Large], 
                LineBox[{{-3.98, 1}, {3.98, 1}}]}, 
               {GrayLevel[0], Thickness[Large], 
                LineBox[{{1, 3.98}, {1, -3.98}}]}, 
               {GrayLevel[0], Thickness[Large], 
                LineBox[{{-3.98, 2}, {3.98, 2}}], 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[{0, 1}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"a\"\>", {0.01, 1}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[{0, -1}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"a\"\>", {0.01, -1}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[{0, 2}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"b\"\>", {0.01, 2}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[{0, -2}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"b\"\>", {0.01, -2}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[{-1, 0}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"c\"\>", {-0.99, 0}]}, 
                {RGBColor[0, 1, 1], DiskBox[{2, 0}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], InsetBox["\<\"d\"\>", {2.01, 0}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{Rational[1, 2], 0}, {0.5, 0}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"e\"\>", {0.51, 0}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{Rational[-1, 2], 0}, {-0.5, 0}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"f\"\>", {-0.49, 0}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{0, Rational[1, 2]}, {0, 0.5}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], 
                 InsetBox["\<\"e\"\>", 
                  NCache[{0.01, Rational[1, 2]}, {0.01, 0.5}]]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{0, Rational[-1, 2]}, {0, -0.5}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], 
                 InsetBox["\<\"f\"\>", 
                  NCache[{0.01, Rational[-1, 2]}, {0.01, -0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[{-1, -1}, Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], InsetBox["\<\"g\"\>", {-0.99, -1}]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{-1, Rational[-1, 2]}, {-1, -0.5}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], 
                 InsetBox["\<\"h\"\>", 
                  NCache[{-0.99, Rational[-1, 2]}, {-0.99, -0.5}]]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[NCache[{Rational[-1, 2], -1}, {-0.5, -1}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[1], InsetBox["\<\"h\"\>", {-0.49, -1}]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[NCache[{Rational[1, 2], -1}, {0.5, -1}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[0], InsetBox["\<\"i\"\>", {0.51, -1}]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[NCache[{-1, Rational[1, 2]}, {-1, 0.5}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"i\"\>", 
                  NCache[{-0.99, Rational[1, 2]}, {-0.99, 0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[NCache[{Rational[3, 2], -1}, {1.5, -1}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[0], InsetBox["\<\"j\"\>", {1.51, -1}]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[NCache[{-1, Rational[3, 2]}, {-1, 1.5}], Scaled[
                  Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"j\"\>", 
                  NCache[{-0.99, Rational[3, 2]}, {-0.99, 1.5}]]}, 
                {RGBColor[1., 0.3, 0.3], 
                 DiskBox[
                  NCache[{Rational[-1, 2], Rational[-1, 2]}, {-0.5, -0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[1], 
                 InsetBox["\<\"k\"\>", 
                  NCache[{-0.49, Rational[-1, 2]}, {-0.49, -0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}],
                   Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"l\"\>", 
                  NCache[{0.51, Rational[1, 2]}, {0.51, 0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[1, 2], Rational[-1, 2]}, {0.5, -0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"m\"\>", 
                  NCache[{0.51, Rational[-1, 2]}, {0.51, -0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-1, 2], Rational[1, 2]}, {-0.5, 0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"m\"\>", 
                  NCache[{-0.49, Rational[1, 2]}, {-0.49, 0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[1, 2], Rational[-3, 2]}, {0.5, -1.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"n\"\>", 
                  NCache[{0.51, Rational[-3, 2]}, {0.51, -1.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-3, 2], Rational[1, 2]}, {-1.5, 0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"n\"\>", 
                  NCache[{-1.49, Rational[1, 2]}, {-1.49, 0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[3, 2], Rational[-1, 2]}, {1.5, -0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"o\"\>", 
                  NCache[{1.51, Rational[-1, 2]}, {1.51, -0.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-1, 2], Rational[3, 2]}, {-0.5, 1.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"o\"\>", 
                  NCache[{-0.49, Rational[3, 2]}, {-0.49, 1.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[3, 2], Rational[-3, 2]}, {1.5, -1.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"p\"\>", 
                  NCache[{1.51, Rational[-3, 2]}, {1.51, -1.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-3, 2], Rational[3, 2]}, {-1.5, 1.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"p\"\>", 
                  NCache[{-1.49, Rational[3, 2]}, {-1.49, 1.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-1, 2], Rational[-3, 2]}, {-0.5, -1.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"q\"\>", 
                  NCache[{-0.49, Rational[-3, 2]}, {-0.49, -1.5}]]}, 
                {RGBColor[0, 1, 1], 
                 DiskBox[
                  NCache[{Rational[-3, 2], Rational[-1, 2]}, {-1.5, -0.5}], 
                  Scaled[Rational[1, 60]]]}, 
                {GrayLevel[0], 
                 InsetBox["\<\"q\"\>", 
                  NCache[{-1.49, 
                    Rational[-1, 2]}, {-1.49, -0.5}]]}}}}}}}}}}}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", "1"}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.510420565571666*^9, 3.510420565571666*^9}, {
   3.5104206341717615`*^9, 3.510420634391762*^9}, {3.5104309502382193`*^9, 
   3.5104309553782268`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.50447039389947*^9, {3.504832475130316*^9, 
   3.5048324800403223`*^9}, {3.504839667912388*^9, 3.50483966942239*^9}, {
   3.5053446893538513`*^9, 3.5053446893638515`*^9}, {3.509847525518984*^9, 
   3.509847525868984*^9}, 3.510182658202551*^9, 3.5102519372561398`*^9, {
   3.5117144657083316`*^9, 3.511714473523945*^9}, 3.5117557401636972`*^9, 
   3.5118313402095723`*^9, {3.511831370988426*^9, 3.511831371269227*^9}, 
   3.511831402063681*^9, {3.5130948422888017`*^9, 3.513094855018424*^9}, 
   3.513094919945738*^9, 3.5130996014343195`*^9, {3.5130996651344085`*^9, 
   3.5130996713944173`*^9}, 3.514596182423899*^9, 3.5148556199569983`*^9, 
   3.515180941638499*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.01.5, CRC 290, A&S 4.3.113", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9}],

Cell[TextData[{
 "Derivation: Rule 8b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "1"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"j", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017331736456656`*^9, 3.501733192084898*^9}, 
   3.5053451232044587`*^9, 3.5102499127033052`*^9, 3.510250822644579*^9, {
   3.510250862304635*^9, 3.5102508814046617`*^9}, {3.5102510503048983`*^9, 
   3.510251056354906*^9}, {3.5102518942560797`*^9, 3.5102519009760885`*^9}, 
   3.510252002666231*^9, {3.510426837912462*^9, 3.510426841822468*^9}, {
   3.5104268871925316`*^9, 3.5104268910825367`*^9}, {3.510427359933193*^9, 
   3.510427368313205*^9}, {3.510427925943986*^9, 3.5104279368640013`*^9}, 
   3.512064361182539*^9, {3.513098899773337*^9, 3.5130989371333895`*^9}, {
   3.5130990885236015`*^9, 3.5130990972636137`*^9}, {3.5130991331836634`*^9, 
   3.5130991488436856`*^9}, {3.5151942576140656`*^9, 3.515194257934066*^9}}],

Cell["\<\
Note: This rule is an unnecessary special case of rule 8b, but it saves a \
step.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49834756106456*^9, {3.5130978151818185`*^9, 
   3.5130978488018656`*^9}, 3.513098463392726*^9, {3.513098499532777*^9, 
   3.513098522232808*^9}, {3.513098574582882*^9, 3.513098574922882*^9}, {
   3.513099116783641*^9, 3.513099117643642*^9}, 3.5141492777201543`*^9, 
   3.5150335940545006`*^9, {3.5150336342558002`*^9, 3.515033649447669*^9}, {
   3.5151942633340735`*^9, 3.5151942638140745`*^9}}],

Cell["Rule a1:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.508355661955892*^9, 3.508355663305894*^9}, {
   3.5104240724965897`*^9, 3.510424073176591*^9}, {3.513094859183631*^9, 
   3.513094859994833*^9}, 3.5130991663737097`*^9, {3.514149253800121*^9, 
   3.5141492542901216`*^9}, {3.51459628299404*^9, 3.5145962845940423`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.5098474822889233`*^9, {
   3.509909292936032*^9, 3.5099092939812336`*^9}, {3.5099093650549583`*^9, 
   3.509909365476159*^9}, {3.5099094331022778`*^9, 3.509909433570279*^9}, 
   3.5151673335332727`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"sin", "[", 
     RowBox[{"c_.", "+", 
      RowBox[{"d_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", "d"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.5098474835889254`*^9, {
   3.5099092953540363`*^9, 3.5099092985832415`*^9}, {3.509909366989362*^9, 
   3.5099093682997637`*^9}, {3.509909434849481*^9, 3.509909436643484*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.01.6, CRC 291, A&S 4.3.114", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4979217639752445`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, {3.4979216145425825`*^9, 
   3.4979216447754354`*^9}, 3.497921877465444*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.526.1, CRC 295, A&S 4.3.116'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498347482094449*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017331736456656`*^9, 3.501733192084898*^9}, 
   3.5053451232044587`*^9, 3.5102499127033052`*^9, 3.510250822644579*^9, {
   3.510250862304635*^9, 3.5102508814046617`*^9}, {3.5102510503048983`*^9, 
   3.510251056354906*^9}, {3.5102518942560797`*^9, 3.5102519009760885`*^9}, 
   3.510252002666231*^9, {3.510426837912462*^9, 3.510426841822468*^9}, {
   3.5104268871925316`*^9, 3.5104268910825367`*^9}, {3.510427359933193*^9, 
   3.510427368313205*^9}, {3.510427925943986*^9, 3.5104279368640013`*^9}, 
   3.512064361182539*^9, {3.513098899773337*^9, 3.5130989371333895`*^9}, {
   3.5130990885236015`*^9, 3.5130990972636137`*^9}, {3.5130991331836634`*^9, 
   3.5130991488436856`*^9}, {3.5130994299840794`*^9, 
   3.5130994345840855`*^9}, {3.5130994980641747`*^9, 3.5130995018941803`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Csc", "[", "z", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", 
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Cos", "[", "z", "]"}], "2"]}]]}], 
    RowBox[{
     SuperscriptBox["Cos", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, {3.4983206471458116`*^9, 
   3.4983206654446435`*^9}, {3.498347135433964*^9, 3.498347135433964*^9}, {
   3.4983475111044903`*^9, 3.498347511684491*^9}, {3.4983475472345405`*^9, 
   3.4983475472345405`*^9}}],

Cell["Rule a2:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.5102497916731358`*^9, 3.510249792933138*^9}, {
   3.5104240842666063`*^9, 3.510424084786607*^9}, {3.5130948636140394`*^9, 
   3.513094864487641*^9}, {3.513099300493898*^9, 3.5130993029839015`*^9}, 
   3.513099561854264*^9, 3.5145962874140463`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"c", "+", 
     RowBox[{"d", " ", "x"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"ArcTanh", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "]"}], 
       "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, {3.498070321988391*^9, 
   3.498070327557601*^9}, {3.4983205558700514`*^9, 3.4983205610648603`*^9}, 
   3.498347135433964*^9, 3.4983475147144947`*^9, 3.498347905655042*^9, {
   3.5099064674677696`*^9, 3.509906477297784*^9}, {3.509909301625247*^9, 
   3.5099093027016487`*^9}, {3.5099093716381702`*^9, 3.509909373260573*^9}, {
   3.509909441463893*^9, 3.5099094420254936`*^9}, 3.514596212143941*^9, {
   3.5151673682333217`*^9, 3.5151673739633293`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"ArcTanh", "[", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], "/", "d"}], " ", "/;", 
   "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9, 3.498347135443964*^9, 3.4983473687142906`*^9, {
   3.50990651770784*^9, 3.5099065202578435`*^9}, {3.509909303980851*^9, 
   3.5099093059932547`*^9}, {3.509909375662977*^9, 3.509909378065381*^9}, {
   3.5099094430550957`*^9, 3.509909445176699*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.526.9', CRC 294', A&S 4.3.117'", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sec", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", "x_"}]}], "]"}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", 
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.498070271459902*^9, 
   3.4983205373216186`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["b",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"2", "j"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.50447039389947*^9, {3.504832475130316*^9, 
   3.5048324800403223`*^9}, {3.504839667912388*^9, 3.50483966942239*^9}, {
   3.5053446893538513`*^9, 3.5053446893638515`*^9}, {3.509847525518984*^9, 
   3.509847525868984*^9}, 3.510182658202551*^9, 3.5102519372561398`*^9, {
   3.5117144657083316`*^9, 3.511714473523945*^9}, 3.5117557401636972`*^9, 
   3.5118313402095723`*^9, {3.511831370988426*^9, 3.511831371269227*^9}, 
   3.511831402063681*^9, {3.5130948422888017`*^9, 3.513094855018424*^9}, 
   3.513094919945738*^9, 3.5130996014343195`*^9, {3.5130996651344085`*^9, 
   3.5130996713944173`*^9}, 3.514596182423899*^9, {3.514596246453989*^9, 
   3.514596252263997*^9}, 3.5148556232486043`*^9, 3.5151809484713106`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.513.5, CRC 296", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9}],

Cell[TextData[{
 "Derivation: Rule 8b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "2"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"j", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017331736456656`*^9, 3.501733192084898*^9}, 
   3.5053451232044587`*^9, 3.5102499127033052`*^9, 3.510250822644579*^9, {
   3.510250862304635*^9, 3.5102508814046617`*^9}, {3.5102510503048983`*^9, 
   3.510251056354906*^9}, {3.5102518942560797`*^9, 3.5102519009760885`*^9}, 
   3.510252002666231*^9, {3.510426837912462*^9, 3.510426841822468*^9}, {
   3.5104268871925316`*^9, 3.5104268910825367`*^9}, {3.510427359933193*^9, 
   3.510427368313205*^9}, {3.510427925943986*^9, 3.5104279368640013`*^9}, 
   3.512064361182539*^9, {3.513098899773337*^9, 3.5130989371333895`*^9}, {
   3.5130990885236015`*^9, 3.5130990972636137`*^9}, {3.5130991331836634`*^9, 
   3.5130991340536647`*^9}, {3.515194291714113*^9, 3.5151942923641143`*^9}}],

Cell["\<\
Note: This rule is an unnecessary special case of rule 8b, but it saves a \
step.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49834756106456*^9, {3.5130978151818185`*^9, 
   3.5130978488018656`*^9}, 3.513098463392726*^9, {3.513098499532777*^9, 
   3.513098522232808*^9}, {3.513098574582882*^9, 3.513098574922882*^9}, {
   3.513099116783641*^9, 3.513099117643642*^9}, 3.51414928182016*^9, 
   3.515033792781867*^9, {3.515194297104121*^9, 3.5151943003841257`*^9}}],

Cell["Rule b1:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.5130948677012463`*^9, 3.513094868777648*^9}, {3.5130985654428687`*^9, 
   3.5130985665528708`*^9}, {3.5130991696337147`*^9, 
   3.5130991703437157`*^9}, {3.514149257920127*^9, 3.514149258420127*^9}, {
   3.5145964170042276`*^9, 3.5145964181642294`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "2"]}]}]}]}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]}], 
   RowBox[{"2", " ", "d"}]]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.5104280288041296`*^9, 
   3.5104280295541306`*^9}, {3.5118052381591825`*^9, 3.5118052503691998`*^9}, 
   3.515167386363347*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "2"}], " ", "-", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "d"}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, {
   3.510428025654125*^9, 3.5104280263541265`*^9}, {3.5118052594092126`*^9, 
   3.5118052744592333`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.513.11, CRC 302", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4979219109275026`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b"}], ")"}]}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, {
   3.4979216145425825`*^9, 3.4979216447754354`*^9}, 3.497921921051921*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.526.2, CRC 308", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49834756106456*^9}],

Cell[TextData[{
 "Derivation: Rule 7b with ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"-", "2"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"j", "=", "1"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017331736456656`*^9, 3.501733192084898*^9}, 
   3.5053451232044587`*^9, 3.5102499127033052`*^9, 3.510250822644579*^9, {
   3.510250862304635*^9, 3.5102508814046617`*^9}, {3.5102510503048983`*^9, 
   3.510251056354906*^9}, {3.5102518942560797`*^9, 3.5102519009760885`*^9}, 
   3.510252002666231*^9, {3.510426837912462*^9, 3.510426841822468*^9}, {
   3.5104268871925316`*^9, 3.5104268910825367`*^9}, {3.510427359933193*^9, 
   3.510427368313205*^9}, {3.510427925943986*^9, 3.5104279368640013`*^9}, 
   3.512064361182539*^9, {3.513098899773337*^9, 3.5130989371333895`*^9}, {
   3.5130990885236015`*^9, 3.5130990972636137`*^9}, {3.5130991331836634`*^9, 
   3.5130991340536647`*^9}, {3.5130993322139425`*^9, 
   3.5130993365539484`*^9}, {3.5151943150741463`*^9, 3.515194315984147*^9}}],

Cell["\<\
Note: This rule is an unnecessary special case of rule 7b, but it saves a \
step.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9, 3.49834756106456*^9, {3.5130978151818185`*^9, 
   3.5130978488018656`*^9}, 3.513098463392726*^9, {3.513098499532777*^9, 
   3.513098522232808*^9}, {3.5130993758540034`*^9, 3.5130993761340036`*^9}, {
   3.5130995742242813`*^9, 3.5130995744742813`*^9}, 3.514149272680147*^9, 
   3.515034461198098*^9, {3.515194319194152*^9, 3.5151943195541525`*^9}}],

Cell["Rule b2:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.5102497973031435`*^9, 3.5102497982231455`*^9}, {3.510424087886611*^9, 
   3.510424088356612*^9}, {3.5130948762032614`*^9, 3.5130948782000647`*^9}, {
   3.513097557401458*^9, 3.513097557661458*^9}, {3.5130993050639043`*^9, 
   3.5130993058439054`*^9}, {3.5130995661742697`*^9, 
   3.5130995664642706`*^9}, {3.5141492492301145`*^9, 3.514149249760115*^9}, {
   3.514596420824233*^9, 3.514596422354235*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"Cot", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "d"]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4983207217919426`*^9, 3.4983207265499506`*^9}, 
   3.498347135443964*^9, 3.498347213164073*^9, 3.498347915555056*^9, {
   3.5099091974170637`*^9, 3.5099092113166885`*^9}, {3.509909307958858*^9, 
   3.5099093089104595`*^9}, {3.5099093805925856`*^9, 
   3.5099093810761867`*^9}, {3.509909446081501*^9, 3.5099094465651016`*^9}, {
   3.5145963542341394`*^9, 3.5145963567641435`*^9}, {3.515167392213355*^9, 
   3.5151673953633595`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}]}], "/", "d"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9, 3.498347135443964*^9, 3.4983472131740727`*^9, 
   3.4983473751042995`*^9, {3.5099092189919024`*^9, 3.5099092217219067`*^9}, {
   3.509909309830861*^9, 3.509909311812065*^9}, {3.509909383618991*^9, 
   3.5099093855221944`*^9}, {3.509909447329503*^9, 3.5099094486087055`*^9}},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.526.10, CRC 312", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4983207715092297`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "2"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", 
     RowBox[{"a", "+", 
      RowBox[{"b", "*", "x"}]}], "]"}], "/", "b"}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.4983205247791967`*^9, 
   3.4983207141011295`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "7"}], "-", "8"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.50447039389947*^9, {3.504832475130316*^9, 
   3.5048324800403223`*^9}, {3.504839667912388*^9, 3.50483966942239*^9}, {
   3.5053446893538513`*^9, 3.5053446893638515`*^9}, {3.509847525518984*^9, 
   3.509847525868984*^9}, 3.510182658202551*^9, 3.5102519372561398`*^9, {
   3.5117144657083316`*^9, 3.511714473523945*^9}, 3.5117557401636972`*^9, 
   3.5118313402095723`*^9, {3.513094719937787*^9, 3.513094725631797*^9}, 
   3.515180949906513*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4980704231233683`*^9, 
   3.4980705306387577`*^9, 3.498325256642625*^9}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", "z", "]"}], "m"], "=", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox[
         RowBox[{"Cot", "[", "z", "]"}], "2"]}], ")"}], 
      FractionBox[
       RowBox[{"m", "-", "2"}], "2"]]}], " ", 
    RowBox[{
     SuperscriptBox["Cot", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, 
   3.4980705505911922`*^9, {3.4983252942230906`*^9, 3.4983252942230906`*^9}, {
   3.498347135443964*^9, 3.498347135443964*^9}, {3.4983472131740727`*^9, 
   3.4983472131740727`*^9}, {3.4983476553146915`*^9, 
   3.4983476636047034`*^9}, {3.498347710324769*^9, 3.4983477220347853`*^9}, {
   3.510254573839831*^9, 3.5102545763598347`*^9}}],

Cell[TextData[{
 "Note: This rule is used for odd ",
 Cell[BoxData[
  RowBox[{"m", "<", 
   RowBox[{"-", "2"}]}]]],
 " since it requires fewer steps and results in simpler antiderivatives than \
rule 7b."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, {3.49757671762799*^9, 3.4975767846480837`*^9}, {
   3.4975768494507804`*^9, 3.4975769045208573`*^9}, {3.514059115062192*^9, 
   3.514059117572195*^9}, {3.514463868305361*^9, 3.5144638997862163`*^9}, {
   3.514463933809876*^9, 3.5144639347770777`*^9}, {3.5150246197252197`*^9, 
   3.515024628930746*^9}, {3.515194334074173*^9, 3.515194334354173*^9}}],

Cell[TextData[{
 "Rule 7a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["m", "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"m", "<", 
    RowBox[{"-", "2"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.498070579139242*^9, 3.49807059487967*^9}, {3.4983253783384385`*^9, 
   3.4983254083060913`*^9}, {3.510249557402808*^9, 3.510249562482815*^9}, {
   3.5102498015631495`*^9, 3.5102498028131514`*^9}, 3.5102506798943796`*^9, {
   3.510254577289836*^9, 3.5102545779798365`*^9}, {3.510261381197437*^9, 
   3.5102613818374376`*^9}, {3.5104241023366313`*^9, 3.510424102756632*^9}, {
   3.51502461133974*^9, 3.515024612599812*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "d"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{
          RowBox[{"-", "m"}], "-", "2"}], "2"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4980703789284906`*^9, 
   3.4980703957921205`*^9}, {3.4980704970362988`*^9, 3.498070514508329*^9}, {
   3.4983253487451863`*^9, 3.498325362520011*^9}, 3.498347135453964*^9, 
   3.4983472131740727`*^9, 3.4983479324250793`*^9, {3.5102495315927715`*^9, 
   3.5102495377027807`*^9}, {3.5102500921435566`*^9, 3.510250113713587*^9}, {
   3.5102545806898403`*^9, 3.5102545815398417`*^9}, 3.5151674034733706`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "m"}], "-", "2"}], ")"}], "/", "2"}], ")"}]}], 
           ",", "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Cot", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, 3.498347135453964*^9, 3.4983472131840725`*^9, 
   3.4983474001343346`*^9, {3.510249608202879*^9, 3.51024960896288*^9}, {
   3.510250096803563*^9, 3.5102501176835923`*^9}, {3.510250633774315*^9, 
   3.510250656124346*^9}, {3.5102545846998463`*^9, 3.510254589749853*^9}, {
   3.5102571515634394`*^9, 3.51025715175344*^9}, 3.5102573009536486`*^9, {
   3.5102611463107023`*^9, 3.510261156980717*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Regularize", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "-", "2"}], ")"}], "/", "2"}], ")"}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Tan", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"EvenQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.498320521643591*^9, 3.498325246845807*^9, {3.498325723613845*^9, 
   3.4983257282158527`*^9}, {3.4983474309343777`*^9, 3.4983474344443827`*^9}, 
   3.5144651119863453`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.3, CRC 309", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761332771716`*^9, 3.4980704159005556`*^9, 
   3.4980705234471445`*^9, 3.4980706229285192`*^9, 3.4983254541701717`*^9, 
   3.49834776104484*^9}],

Cell[TextData[{
 "Reference: G&R 2.552.3 special case when ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, 
   3.4976416712695007`*^9, {3.4979240714220977`*^9, 3.497924071656098*^9}, {
   3.498241383594393*^9, 3.4982413927744055`*^9}, {3.505354077065938*^9, 
   3.505354077695939*^9}}],

Cell[TextData[{
 "Derivation: Rule 5b with ",
 Cell[BoxData[
  RowBox[{"a", "=", "1"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"b", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", "j"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236918158064`*^9, 3.5017236959186134`*^9}, 
   3.5053451045044327`*^9, {3.5102551777306767`*^9, 3.5102551838306847`*^9}, 
   3.510255631151311*^9, 3.5102556966614027`*^9, 3.5102557502114778`*^9, {
   3.510255842011606*^9, 3.5102558558216257`*^9}, {3.5102558877816706`*^9, 
   3.510255898811686*^9}, 3.5120643164524765`*^9, {3.514147963278314*^9, 
   3.514147990158352*^9}, {3.5141482420187044`*^9, 3.514148255158723*^9}}],

Cell[TextData[{
 "Rule 7b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     FractionBox["m", "2"], "\[NotElement]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.504471038210372*^9, 
   3.504471041430376*^9}, 3.504482107256355*^9, 3.504988537290719*^9, {
   3.5083553588354673`*^9, 3.5083553595954685`*^9}, {3.5099090689040384`*^9, 
   3.509909077577654*^9}, 3.510250354103923*^9, {3.510250514474148*^9, 
   3.5102505279141665`*^9}, {3.510254606139876*^9, 3.5102546080298786`*^9}, {
   3.51025471607003*^9, 3.510254716890031*^9}, {3.5102547498400774`*^9, 
   3.510254756550087*^9}, {3.510261384357441*^9, 3.510261385037442*^9}, {
   3.5104241170266523`*^9, 3.510424117466653*^9}, {3.5130947759106855`*^9, 
   3.5130947772210875`*^9}, 3.513097560521462*^9, {3.513099308343909*^9, 
   3.51309930918391*^9}, {3.5130995693542747`*^9, 3.5130995696342745`*^9}, 
   3.514149286590167*^9, 3.5150246165200367`*^9}],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
       FractionBox[
        RowBox[{"2", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", "1"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "m"}], "+", "j", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "j", "+", "3"}], 
     RowBox[{
      RowBox[{"2", " ", "m"}], "+", "j", "+", "1"}]], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", "2"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095014878340373`*^9, 3.5095014885516386`*^9}, {3.509501723296851*^9, 
   3.5095017455424905`*^9}, {3.510167018471958*^9, 3.5101670221519637`*^9}, {
   3.510167325332388*^9, 3.5101673371024046`*^9}, {3.5102509934548187`*^9, 
   3.5102511286150074`*^9}, {3.5102512230551395`*^9, 
   3.5102512252151427`*^9}, {3.510251266585201*^9, 3.510251502655531*^9}, {
   3.510251603195672*^9, 3.510251604205673*^9}, {3.5102519162461104`*^9, 
   3.5102519201161156`*^9}, {3.5102520180262527`*^9, 3.510252061526314*^9}, {
   3.510253854598824*^9, 3.510253940268944*^9}, {3.510253978068997*^9, 
   3.510254075089133*^9}, {3.515167407833377*^9, 3.515167419883394*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
     "m_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "j", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "j", "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "j", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"EvenQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, {3.4979216146205826`*^9, 
   3.4979216448378353`*^9}, 3.4979240644956856`*^9, 3.505344639903782*^9, {
   3.505344689123851*^9, 3.505344713543885*^9}, 3.505345793305397*^9, 
   3.5053541056159773`*^9, 3.50535414329603*^9, {3.5083553628954735`*^9, 
   3.5083553668754787`*^9}, {3.509847499738948*^9, 3.5098475043389544`*^9}, {
   3.5099090508704066`*^9, 3.5099090553944144`*^9}, {3.510250376503955*^9, 
   3.5102504399140434`*^9}, {3.510250599724267*^9, 3.510250606144276*^9}, 
   3.5102506991644063`*^9, 3.510254435299637*^9, {3.5102546208098965`*^9, 
   3.5102546291399083`*^9}, 3.5102546779099765`*^9, 3.510254778950118*^9, {
   3.51025635165232*^9, 3.510256352612321*^9}, 3.5168210289369836`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.6, CRC 313", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, 3.4975770266910286`*^9, 3.4979221272062826`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, {3.4979216146205826`*^9, 
   3.4979216448378353`*^9}, 3.4979240644956856`*^9, {3.5067063135225325`*^9, 
   3.5067063148344193`*^9}, {3.5144641832699137`*^9, 
   3.5144642240483856`*^9}, {3.514465597022397*^9, 3.5144656097052193`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, {3.4983474380643873`*^9, 
   3.498347443964396*^9}, 3.5144654833449974`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Integration by substitution", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9}],

Cell[TextData[{
 "Basis: If ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"m", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "z", "]"}], "m"], "=", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "z", "]"}], "2"]}], ")"}], 
      FractionBox[
       RowBox[{"m", "-", "1"}], "2"]]}], " ", 
    RowBox[{
     SuperscriptBox["Cos", "\[Prime]",
      MultilineFunction->None], "[", "z", "]"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4975762570673447`*^9, 3.4975763239574385`*^9}, 3.4975764674176397`*^9, 
   3.5102501580436487`*^9, {3.510254519679755*^9, 3.5102545228597593`*^9}}],

Cell[TextData[{
 "Note: This rule is used for odd ",
 Cell[BoxData[
  RowBox[{"m", ">", "1"}]]],
 " since it requires fewer steps and results in simpler antiderivatives than \
rule 8b."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, {3.49757671762799*^9, 3.4975767846480837`*^9}, {
   3.4975768494507804`*^9, 3.4975769045208573`*^9}, {3.514059115062192*^9, 
   3.514059117572195*^9}, {3.514463868305361*^9, 3.5144638997862163`*^9}, {
   3.5150245181044073`*^9, 3.5150245197275*^9}, 3.515024656880345*^9, {
   3.5151943490841937`*^9, 3.5151943495241947`*^9}}],

Cell[TextData[{
 "Rule 8a: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"m", "-", "1"}], "2"], "\[Element]", "\[DoubleStruckCapitalZ]"}],
    " ", "\[And]", " ", 
   RowBox[{"m", ">", "1"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, {3.496441972821591*^9, 
   3.4964419754615946`*^9}, 3.4964524321966314`*^9, 3.4965289461639547`*^9, {
   3.497576396827541*^9, 3.4975764493076143`*^9}, 3.497576946310916*^9, {
   3.506712458158085*^9, 3.5067124653984957`*^9}, {3.506712506537651*^9, 
   3.5067125078695664`*^9}, {3.5067127618547792`*^9, 
   3.5067127622653694`*^9}, {3.5102492925924373`*^9, 
   3.5102493125924654`*^9}, {3.510254523809761*^9, 3.510254525009763*^9}, {
   3.510424098436626*^9, 3.5104240988966265`*^9}, {3.5150246497749386`*^9, 
   3.5150246514040318`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["1", "d"]}]}]}], 
   RowBox[{"Subst", "[", 
    RowBox[{
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}], ")"}], 
        FractionBox[
         RowBox[{"m", "-", "1"}], "2"]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}], ",", "x", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.4975763844775233`*^9, 
   3.497576391597533*^9}, 3.509847486078929*^9, {3.5099093157276716`*^9, 
   3.509909318800877*^9}, {3.5099093924018064`*^9, 3.509909402370224*^9}, {
   3.509909454443115*^9, 3.5099094563775187`*^9}, {3.510254527619766*^9, 
   3.5102545284397674`*^9}, 3.515167425103401*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"sin", "[", 
      RowBox[{"c_.", "+", 
       RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "d"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"m", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.497576340197461*^9, {3.5020443872559056`*^9, 3.5020443882231073`*^9}, 
   3.509847488328932*^9, {3.5099093200488796`*^9, 3.5099093252904882`*^9}, {
   3.509909412042241*^9, 3.5099094173774505`*^9}, {3.5099094584523225`*^9, 
   3.50990946269553*^9}, {3.510254532869774*^9, 3.510254538269781*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", "b"}], ",", 
     RowBox[{"Subst", "[", 
      RowBox[{
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"Expand", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"x", "^", "2"}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"n", "-", "1"}], ")"}], "/", "2"}], ")"}]}], ",", 
           "x"}], "]"}], ",", "x"}], "]"}], ",", "x", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}]}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OddQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.497576340197461*^9, {3.4979216145737824`*^9, 3.4979216447910357`*^9}, 
   3.497921964482397*^9, {3.502044323326993*^9, 3.502044324231795*^9}, {
   3.514130307979562*^9, 3.5141303301940002`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.510.2, CRC 299", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9}],

Cell[TextData[{
 "Reference: G&R 2.552.3 inverted special case when ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, 3.497583103771538*^9, 
   3.49758316261162*^9, 3.497923625588915*^9, {3.4982410640439453`*^9, 
   3.498241080323968*^9}, {3.5053540835659466`*^9, 3.505354083875947*^9}}],

Cell[TextData[{
 "Derivation: Rule 2b with ",
 Cell[BoxData[
  RowBox[{"k", "=", "j"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017236918158064`*^9, 3.5017236959186134`*^9}, 
   3.5053451045044327`*^9, {3.5102551777306767`*^9, 3.5102551838306847`*^9}, 
   3.510255631151311*^9, 3.5102556966614027`*^9, 3.5102557502114778`*^9, {
   3.510255842011606*^9, 3.5102558558216257`*^9}, {3.5102558877816706`*^9, 
   3.510255898811686*^9}, 3.5120643164524765`*^9, {3.514147963278314*^9, 
   3.514147990158352*^9}, {3.5141482420187044`*^9, 3.514148255158723*^9}, {
   3.514148464159015*^9, 3.5141484713490257`*^9}, {3.51414889612962*^9, 
   3.514148896979621*^9}}],

Cell[TextData[{
 "Rule 8b: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     FractionBox[
      RowBox[{"m", "-", "1"}], "2"], "\[NotElement]", 
     "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
    RowBox[{"m", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.497583245131736*^9, 3.4975832480817394`*^9}, {
   3.504471143260519*^9, 3.5044711443605204`*^9}, {3.504482109666358*^9, 
   3.50448211089636*^9}, 3.5049885403707232`*^9, {3.506712216921203*^9, 
   3.506712230961392*^9}, {3.5067123979715405`*^9, 3.5067124241692114`*^9}, 
   3.5067125107336845`*^9, {3.5067127658004527`*^9, 3.506712766261115*^9}, {
   3.510249931643332*^9, 3.510249940363344*^9}, {3.5102527005472083`*^9, 
   3.510252712257225*^9}, 3.510254739550063*^9, {3.5104241131166463`*^9, 
   3.510424113586647*^9}, {3.510427054232765*^9, 3.5104270592727723`*^9}, {
   3.5130947799198923`*^9, 3.513094781152294*^9}, 3.513098569812875*^9, {
   3.5130991132136354`*^9, 3.513099113923637*^9}, {3.5130992337838044`*^9, 
   3.513099234983806*^9}, 3.5141492899501715`*^9, 3.515024654061184*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "-", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "m"}], "+", "j", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"2", "m"}], "+", "j", "-", "3"}], 
    RowBox[{
     RowBox[{"2", "m"}], "+", "j", "-", "1"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095014878340373`*^9, 3.5095014885516386`*^9}, {3.509501723296851*^9, 
   3.5095017455424905`*^9}, {3.510167018471958*^9, 3.5101670221519637`*^9}, {
   3.510167325332388*^9, 3.5101673371024046`*^9}, {3.5102509934548187`*^9, 
   3.5102511286150074`*^9}, {3.5102512230551395`*^9, 
   3.5102512252151427`*^9}, {3.510251266585201*^9, 3.510251502655531*^9}, {
   3.510251603195672*^9, 3.510251604205673*^9}, {3.5102519162461104`*^9, 
   3.5102519201161156`*^9}, {3.5102520180262527`*^9, 3.510252061526314*^9}, 
   3.5102540815591416`*^9, {3.5151674394434214`*^9, 3.5151674412534237`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.510252135446417*^9, 3.5102521410864253`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
     "m_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "m"}], "+", "j", "-", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "j", "-", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "m"}], "+", "j", "-", "1"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"OddQ", "[", "m", "]"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"m", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, {3.4979216146049824`*^9, 
   3.4979216448222356`*^9}, 3.4979236340597296`*^9, 3.505344639933782*^9, {
   3.505344689153851*^9, 3.505344713573885*^9}, 3.505345791355394*^9, {
   3.5083553881655087`*^9, 3.508355395725519*^9}, {3.5098474932989388`*^9, 
   3.5098474946989408`*^9}, {3.5102499796033993`*^9, 3.510249981263401*^9}, {
   3.5102501808136806`*^9, 3.5102502097637215`*^9}, 3.5102517907759347`*^9, 
   3.510251859756031*^9, 3.510252147656434*^9, 3.5102526731571703`*^9, {
   3.5102527156172295`*^9, 3.510252718067233*^9}, {3.510256333572294*^9, 
   3.5102563345922956`*^9}, {3.5104270458027534`*^9, 3.510427048962758*^9}, 
   3.5130991930537477`*^9, 3.5168210290269837`*^9},
 Background->GrayLevel[0.85]],

Cell["Reference: G&R 2.510.5, CRC 305", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, 3.4975762082572765`*^9, 
   3.4975766144178452`*^9, 3.4979220484261446`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, {3.4979216146049824`*^9, 
   3.4979216448222356`*^9}, 3.4979236340597296`*^9, {3.5067062863534656`*^9, 
   3.5067062877354527`*^9}, {3.5067123638124228`*^9, 3.506712370982733*^9}, {
   3.514464069311714*^9, 3.514464109434984*^9}, {3.51446563282446*^9, 
   3.5144656445712805`*^9}, 3.5144657311826324`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sec", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", "x_"}]}], "]"}], "^", "n_"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Sin", "[", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", "x"}]}], "]"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sec", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", "x"}]}], "]"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "n"}], ")"}]}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}], "/", "n"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sec", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.498070265173091*^9, 3.498070375231284*^9, 3.498070474665859*^9, 
   3.4980706418045526`*^9, 3.498320518570386*^9, 3.4983254473373594`*^9, {
   3.4983257317882595`*^9, 3.498325739588273*^9}, 3.4983258972265496`*^9, 
   3.498327107991476*^9, {3.5144655337954865`*^9, 3.514465569098348*^9}, 
   3.514465744255456*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["k", "2"], "=", "1"}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.51041961730233*^9, 3.5104196259523425`*^9}, {
   3.51344227150583*^9, 3.513442273395832*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5119820656389465`*^9, 
   3.5119820661379747`*^9}, 3.51198211780093*^9, {3.5130942763978076`*^9, 
   3.5130942782698107`*^9}, 3.5130949589614067`*^9, 3.5131000152748985`*^9, {
   3.5133782031738586`*^9, 3.51337820364386*^9}, 3.5136162346357837`*^9, 
   3.514596480014316*^9, {3.5150918225007095`*^9, 3.5150918303607206`*^9}, 
   3.5151809566457253`*^9, {3.515181177172513*^9, 3.5151811788105164`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Note: Although this rule produces a slightly more complicated \
antiderivative than rule c2 and c4, it is continuous provided  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 "."
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.5150252809040365`*^9, 3.5150252853722925`*^9}, {3.5151811966413474`*^9, 
   3.515181199808153*^9}, {3.51519438221424*^9, 3.515194382634241*^9}}],

Cell[TextData[{
 "Rule c1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.5043963739063826`*^9, 
   3.504396376326386*^9}, {3.504413073930699*^9, 3.5044130746907*^9}, {
   3.5098947021629305`*^9, 3.5098947030329323`*^9}, {3.51309431747268*^9, 
   3.5130943178158803`*^9}, {3.513094997527874*^9, 3.5130949981778746`*^9}, {
   3.5133770949823074`*^9, 3.513377095502308*^9}, {3.5133782686539507`*^9, 
   3.513378269123951*^9}, {3.51459648291432*^9, 3.514596484034322*^9}, {
   3.5151812028969584`*^9, 3.5151812036301594`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["2", 
    RowBox[{"d", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]}]], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"]}]], "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497921629705809*^9, 3.497922342845462*^9, 3.4980128262865524`*^9, 
   3.5053446395437813`*^9, {3.5053446876538486`*^9, 3.505344713213885*^9}, 
   3.5053459961156807`*^9, 3.5098471285884285`*^9, 3.515167507293516*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"Sim", "[", 
       RowBox[{"b", "*", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"a", "^", "2"}], "-", 
              RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", " ", "+", " ", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], "]"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, 
   3.4980130216868258`*^9, {3.4980208106228065`*^9, 3.498020814366813*^9}, {
   3.4980626680522194`*^9, 3.4980626702362237`*^9}, {3.498062841914525*^9, 
   3.49806284476933*^9}, 3.5053446395537815`*^9, {3.505344687663849*^9, 
   3.5053447132238846`*^9}, 3.5053459995156856`*^9, 3.5098471414484463`*^9, {
   3.513398117248828*^9, 3.513398157216098*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{"Rt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "^", "2"}], "-", 
        RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}], "*", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"Sim", "[", 
       RowBox[{"b", "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"Rt", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"a", "^", "2"}], "-", 
              RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}], "+", 
           RowBox[{"b", "*", 
            RowBox[{"Cos", "[", 
             RowBox[{"c", " ", "+", " ", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}]}], "]"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, 
   3.4980130216868258`*^9, {3.4980208106228065`*^9, 3.498020814366813*^9}, {
   3.4980626680522194`*^9, 3.4980626702362237`*^9}, {3.498062841914525*^9, 
   3.49806284476933*^9}, {3.5067054734145164`*^9, 3.506705494504843*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.553.3a, A&S 4.3.133a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9}],

Cell["\<\
Note: Although nonessential, this rule produces a slightly simpler \
antiderivative than rule c3.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787029645586`*^9}, {3.5133787415046124`*^9, 
   3.5133787427946143`*^9}, {3.515025290520587*^9, 3.515025290812604*^9}, 
   3.5151812249397974`*^9, {3.5151944019842677`*^9, 3.5151944022842684`*^9}}],

Cell[TextData[{
 "R",
 "ule c",
 "2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.5043963804663916`*^9, 
   3.504396382116394*^9}, {3.5044130786807055`*^9, 3.5044130791307063`*^9}, {
   3.509894706702937*^9, 3.5098947071329374`*^9}, {3.513094295944642*^9, 
   3.5130942969274435`*^9}, {3.5130949740466332`*^9, 3.513094974701834*^9}, {
   3.513377087392297*^9, 3.513377087772297*^9}, {3.514596516384367*^9, 
   3.514596516634367*^9}, 3.515181225501398*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497921629705809*^9, 3.497922342845462*^9, {3.509892583389964*^9, 
   3.509892595549981*^9}, {3.515167519323533*^9, 3.5151675248235407`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], "*", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, {
   3.4980123935259466`*^9, 3.4980123977059526`*^9}, {3.498020817549219*^9, 
   3.4980208202948236`*^9}, {3.5098926299200296`*^9, 
   3.5098926316600323`*^9}, {3.509892811650284*^9, 3.509892811780284*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.551.3a, A&S 4.3.131a", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9}],

Cell[TextData[{
 "R",
 "ule c",
 "3: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], ">", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, 3.497639786159789*^9, {3.5043963804663916`*^9, 
   3.504396382116394*^9}, {3.5044130786807055`*^9, 3.5044130791307063`*^9}, {
   3.509893023890581*^9, 3.5098930241605816`*^9}, {3.509894710462942*^9, 
   3.509894710792943*^9}, {3.513094321341487*^9, 3.5130943216066875`*^9}, {
   3.513094999937877*^9, 3.513095002687881*^9}, {3.513377098152312*^9, 
   3.5133770986723127`*^9}, {3.51337850404428*^9, 3.5133785043542805`*^9}, {
   3.513378646324479*^9, 3.5133786471244802`*^9}, {3.514596520734373*^9, 
   3.5145965210743732`*^9}, 3.515181227779002*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}]]}]]}]}], 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.497921629705809*^9, 3.497922342845462*^9, 3.505344687683849*^9, {
   3.505346079315797*^9, 3.505346090775813*^9}, 3.509847143598449*^9, 
   3.515167542223565*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PosQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.497921629705809*^9, 3.497922290023769*^9, {
   3.4980123935259466`*^9, 3.4980123977059526`*^9}, {3.498020817549219*^9, 
   3.4980208202948236`*^9}, 3.505344687693849*^9, {3.5053461149158473`*^9, 
   3.5053461261058626`*^9}, 3.509847144988451*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.553.3b', A&S 4.3.133b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4979223905815454`*^9}],

Cell["\<\
Note: Although nonessential, this rule produces a slightly simpler \
antiderivative than rule c5.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.497922384138734*^9, 3.4980156457105*^9, {
   3.4980207183018446`*^9, 3.498020768767933*^9}, 3.498059955917454*^9, {
   3.4980603297565107`*^9, 3.4980603534217525`*^9}, {3.4980604729647627`*^9, 
   3.4980604821687784`*^9}, {3.498062467701068*^9, 3.4980625074811373`*^9}, {
   3.498062720437112*^9, 3.49806273658314*^9}, {3.498062866812169*^9, 
   3.4980628951574183`*^9}, {3.513377847463361*^9, 3.51337785408337*^9}, {
   3.513378298423992*^9, 3.513378308944007*^9}, {3.5133783881541176`*^9, 
   3.513378425854171*^9}, {3.51337857547438*^9, 3.5133785987544127`*^9}, {
   3.513378680544527*^9, 3.5133787152845755`*^9}, {3.513378746444619*^9, 
   3.5133787478346214`*^9}, {3.515025301114193*^9, 3.5150253013912086`*^9}, 
   3.515181228980204*^9, {3.515194426204302*^9, 3.515194426504302*^9}}],

Cell[TextData[{
 "R",
 "ule c",
 "4: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.5043963859263997`*^9, 3.504396387816402*^9}, {3.5044130826407113`*^9, 
   3.504413083060712*^9}, {3.5098930276005864`*^9, 3.509893027890587*^9}, {
   3.5098947141829476`*^9, 3.5098947144129477`*^9}, {3.5130943007494507`*^9, 
   3.513094301108251*^9}, {3.5130949777750397`*^9, 3.513094978414641*^9}, {
   3.5133770913823023`*^9, 3.5133770920923033`*^9}, {3.513378651074486*^9, 
   3.513378651724487*^9}, {3.514596524194378*^9, 3.514596524494378*^9}, 
   3.515181230119006*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["a", "2"]}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], " ", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["a", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497921629705809*^9, 3.4979224338404217`*^9, {
   3.509892695380121*^9, 3.509892704460134*^9}, {3.515167546673571*^9, 
   3.515167550873577*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}], "*", 
       RowBox[{
        RowBox[{"Tan", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "/", 
        RowBox[{"Rt", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497921629721409*^9, 
   3.497922399317561*^9, {3.4980131795470467`*^9, 3.4980131835270524`*^9}, {
   3.4980154763502626`*^9, 3.498015479210266*^9}, {3.509892709560141*^9, 
   3.509892711770144*^9}, {3.5098928069102774`*^9, 3.509892807060278*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.551.3b', A&S 4.3.131b'", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9}],

Cell[TextData[{
 "R",
 "ule c",
 "5: If  ",
 Cell[BoxData[
  RowBox[{"\[Not]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], ">", "0"}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.5043963859263997`*^9, 3.504396387816402*^9}, {3.5044130826407113`*^9, 
   3.504413083060712*^9}, {3.509893030860591*^9, 3.509893031120591*^9}, {
   3.5098947184829535`*^9, 3.509894718752954*^9}, {3.5130950087778893`*^9, 
   3.51309500927789*^9}, {3.5133771015723166`*^9, 3.5133771022023177`*^9}, {
   3.513378507704285*^9, 3.5133785079842854`*^9}, {3.514596527664383*^9, 
   3.5145965280543833`*^9}, 3.5151812308834076`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["a", "2"]}]]}]]}]}]}], 
   RowBox[{"ArcTanh", "[", 
    FractionBox[
     RowBox[{"b", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Tan", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], ")"}]}], "]"}]}]}], 
     SqrtBox[
      RowBox[{
       SuperscriptBox["b", "2"], "-", 
       SuperscriptBox["a", "2"]}]]], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497921629705809*^9, 3.4979224338404217`*^9, 
   3.505344687703849*^9, {3.5053462036959715`*^9, 3.505346204905973*^9}, 
   3.509847146268453*^9, 3.5136162220309615`*^9, {3.514226290593773*^9, 
   3.514226292138175*^9}, 3.515167558533588*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"ArcTanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", "*", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}]}]}], ")"}], 
       "/", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"b", "^", "2"}], "-", 
          RowBox[{"a", "^", "2"}]}], ",", "2"}], "]"}]}], ")"}]}]}], " ", "/;",
    "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NegQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497921629721409*^9, 
   3.497922399317561*^9, {3.4980131795470467`*^9, 3.4980131835270524`*^9}, {
   3.4980154763502626`*^9, 3.498015479210266*^9}, 3.5053446877238493`*^9, {
   3.505346235096015*^9, 3.5053462441360283`*^9}, 3.509847147538455*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.498070277840313*^9, 
   3.498320585541303*^9, 3.498333075518424*^9, {3.498333998129716*^9, 
   3.498334003529723*^9}, 3.5002620149595757`*^9, {3.5119822460882673`*^9, 
   3.5119822484344015`*^9}, {3.5136162015793257`*^9, 3.513616203076928*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "+", 
     RowBox[{"b", "/", "z"}]}]], "=", 
   RowBox[{
    FractionBox["1", "a"], "-", 
    FractionBox["b", 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.513616405877284*^9, 3.513616440509345*^9}, {
   3.514227599061671*^9, 3.514227623725314*^9}}],

Cell[TextData[{
 "R",
 "ule c",
 "6: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5147364697159986`*^9, 
   3.5147364746612077`*^9}, 3.5151812321158094`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["x", "a"]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.4987613369824286`*^9, 3.498761351202448*^9}, 3.4991763446448917`*^9, {
   3.499176403316595*^9, 3.4991764071698017`*^9}, 3.499195747838275*^9, {
   3.4991963654829597`*^9, 3.4991963700225677`*^9}, {3.4991968799254637`*^9, 
   3.499196884917472*^9}, {3.5002618027680025`*^9, 3.500261855808096*^9}, {
   3.5002619517014647`*^9, 3.5002619596574783`*^9}, {3.5104552095627546`*^9, 
   3.510455232022786*^9}, {3.5119822688505697`*^9, 3.511982278494121*^9}, {
   3.513616282668268*^9, 3.5136163233531394`*^9}, 3.5142275421839705`*^9, {
   3.515167569963604*^9, 3.515167579363617*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "/", "a"}], " ", "-", " ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761354722453*^9, 3.4987613821124916`*^9}, 
   3.4987624269439545`*^9, 3.499176545495245*^9, {3.5002621484802103`*^9, 
   3.500262195607893*^9}, 3.500263694233178*^9, {3.510455241122799*^9, 
   3.510455275992848*^9}, {3.5119822283042507`*^9, 3.511982241072981*^9}, 
   3.51361651162987*^9, {3.5137914366421604`*^9, 3.513791444467608*^9}, {
   3.514227569608819*^9, 3.5142275818236403`*^9}, {3.514732708442383*^9, 
   3.514732713072389*^9}, {3.5147364131190996`*^9, 3.5147364427435513`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["d",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497921629783809*^9, {3.504469937518831*^9, 3.504469952138851*^9}, 
   3.505344687733849*^9, 3.508348861796372*^9, 3.509847181168502*^9, 
   3.510457506665971*^9, {3.5105084183423643`*^9, 3.510508418669965*^9}, {
   3.510508527636156*^9, 3.5105085292741594`*^9}, {3.5130943524479413`*^9, 
   3.513094354226344*^9}, 3.513094964343416*^9, 3.513100019974905*^9, {
   3.5141475816077795`*^9, 3.5141475869077873`*^9}, 3.514147672767907*^9, 
   3.5145979889464283`*^9, 3.5151809585801287`*^9, 3.515181257698654*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 12 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, {3.5102680075767136`*^9, 3.510268048246771*^9}, {
   3.510286142802781*^9, 3.5102861557352037`*^9}, {3.5102870731364155`*^9, 
   3.5102871063020735`*^9}, {3.5120545232307515`*^9, 3.512054526910756*^9}, {
   3.5141426032508097`*^9, 3.5141426115508213`*^9}}],

Cell[TextData[{
 "Rule d: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.5105084879028864`*^9, 3.510508488090087*^9}, {
   3.5130944226480646`*^9, 3.5130944467345066`*^9}, 3.51309510891803*^9, {
   3.5141416582394867`*^9, 3.5141416778495145`*^9}, {3.514146583716383*^9, 
   3.514146584846384*^9}, {3.51414758915779*^9, 3.514147589647791*^9}, 
   3.5141476759479117`*^9, 3.514597994066436*^9, 3.5151812601010585`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{
         FractionBox[
          RowBox[{"k", "+", "1"}], 
          RowBox[{"k", "+", "3"}]], 
         SuperscriptBox["b", "2"]}]}], ")"}]}]}], "x"}]}], "-", 
  FractionBox[
   RowBox[{"2", 
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], 
   RowBox[{"d", " ", 
    RowBox[{"(", 
     RowBox[{"k", "+", "3"}], ")"}]}]], "+", 
  RowBox[{"2", "a", " ", "b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "k"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5098355380753117`*^9, 3.509835661752329*^9}, {3.509835695323588*^9, 
   3.509835698927194*^9}, {3.50983577051572*^9, 3.5098358512614617`*^9}, {
   3.5101827368266892`*^9, 3.510182745344304*^9}, {3.5101829999523516`*^9, 
   3.510183019686386*^9}, {3.5141366663504972`*^9, 3.514136709830558*^9}, {
   3.5141367652306356`*^9, 3.5141367807606573`*^9}, {3.5141369190408506`*^9, 
   3.514137030991008*^9}, {3.5141375883017883`*^9, 3.5141375939117956`*^9}, {
   3.51414390318263*^9, 3.5141439034726305`*^9}, {3.5151675869436274`*^9, 
   3.5151675899036317`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^", 
     "2"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "+", "1"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"k", "+", "3"}], ")"}]}], "*", 
        RowBox[{"b", "^", "2"}]}]}], ")"}], "*", "x"}], " ", "-", " ", 
    RowBox[{"2", "*", 
     RowBox[{"b", "^", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"k", "+", "3"}], ")"}]}], ")"}]}]}], " ", "+", " ", 
    RowBox[{"2", "*", "a", "*", "b", "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}], ",", "x"}], "]"}]}]}],
    " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, {3.510267358245805*^9, 
   3.510267363695812*^9}, 3.5102674525359364`*^9, {3.51026851924743*^9, 
   3.510268522147434*^9}, 3.510268653627618*^9, {3.5102687229377155`*^9, 
   3.510268727847722*^9}, 3.510286783854707*^9, {3.510286855412032*^9, 
   3.5102868598424406`*^9}, {3.510286899944911*^9, 3.510286906169322*^9}, 
   3.512054537890772*^9, {3.5120545820108337`*^9, 3.512054602120862*^9}, {
   3.5141374185915504`*^9, 3.514137419971552*^9}, 3.514137457461605*^9, 
   3.5141375596417475`*^9, {3.514137613991824*^9, 3.514137617741829*^9}, {
   3.514141592499395*^9, 3.5141415948793983`*^9}, {3.5141439065226345`*^9, 
   3.5141439068526354`*^9}, 3.516821192057212*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["e",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.497921629721409*^9, {
   3.504469962408866*^9, 3.504469964148868*^9}, 3.505344687803849*^9, 
   3.5083488388663397`*^9, 3.509847149038457*^9, 3.5104575048259683`*^9, {
   3.510508423147173*^9, 3.510508423381173*^9}, {3.5105085236737494`*^9, 
   3.5105085246877513`*^9}, {3.5130943389227176`*^9, 3.5130943445387273`*^9}, 
   3.5130949622686124`*^9, 3.513100018514903*^9, 3.5145979262863407`*^9, 
   3.514598007356454*^9, 3.515180961247733*^9, 3.5151812722378798`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"EllipticE", "[", 
     RowBox[{"z", ",", "n"}], "]"}]}], "=", 
   SqrtBox[
    RowBox[{"1", "-", 
     RowBox[{"n", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "z", "]"}], "2"]}]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "2"]}]}], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", "b"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, {3.509893685281507*^9, 3.509893685281507*^9}, {
   3.5151263553521*^9, 3.5151263553521*^9}}],

Cell[TextData[{
 "Rule e1: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5151812744218836`*^9, 
   3.5151812752174854`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"a", "+", "b"}]]}], "d"]}]}]}], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4979216297526093`*^9, 3.497922801283467*^9, 
   3.500665297613958*^9, 3.505344687833849*^9, 3.505346451676318*^9, 
   3.5098471638084774`*^9, {3.5098934921012363`*^9, 3.50989350168125*^9}, {
   3.509893619231415*^9, 3.5098936260614243`*^9}, 3.5098937648316183`*^9, {
   3.5151262912359877`*^9, 3.515126312561225*^9}, 3.5151675961336403`*^9, {
   3.515711026402997*^9, 3.515711035997014*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"Pi", "/", "2"}], "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sim", "[", 
       RowBox[{"a", "+", "b"}], "]"}], "]"}], "/", "d"}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4979216297526093`*^9, 
   3.4979227505677776`*^9, {3.503114419966997*^9, 3.503114433570221*^9}, 
   3.505344687843849*^9, 3.505346458346328*^9, 3.505409319744323*^9, 
   3.5074317977549033`*^9, 3.50984716543848*^9, 3.5098939458618717`*^9, 
   3.5118053855293894`*^9, 3.5141774554954824`*^9, {3.5151261677929707`*^9, 
   3.515126186778204*^9}, {3.5156892546264534`*^9, 3.5156892662864695`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Sim", "[", 
       RowBox[{"a", "+", "b"}], "]"}], "]"}], "/", "d"}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Pi", "/", "4"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4979216297526093`*^9, 
   3.4979227505677776`*^9, {3.503114419966997*^9, 3.503114433570221*^9}, 
   3.505344687843849*^9, 3.505346458346328*^9, 3.505409319744323*^9, 
   3.5074317977549033`*^9, 3.50984716543848*^9, 3.5098939458618717`*^9, 
   3.5118053855293894`*^9, 3.5141774554954824`*^9, {3.5151262434531035`*^9, 
   3.5151262526259193`*^9}, {3.5156892571864567`*^9, 
   3.5156892634864655`*^9}, {3.5157110412230234`*^9, 3.515711048617436*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{
       FractionBox["a", 
        RowBox[{"a", "+", "b"}]], "+", 
       RowBox[{
        FractionBox["b", 
         RowBox[{"a", "+", "b"}]], 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, 3.497578119962559*^9, {3.5083546016044073`*^9, 
   3.5083546016044073`*^9}, {3.5118050348148956`*^9, 3.5118050348148956`*^9}}],

Cell[TextData[{
 "Note: Since ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox["b", 
     RowBox[{"a", "+", "b"}]]}], "=", 
   RowBox[{"1", ">", "0"}]}]]],
 ", rule e1 applies to the resulting integrand."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.497582428440592*^9, 
   3.4975824695406494`*^9}, 3.4975829172612762`*^9, 3.4979216297682095`*^9, {
   3.497923045626696*^9, 3.4979230482631006`*^9}, {3.5067957598589277`*^9, 
   3.5067957686215277`*^9}, {3.5141774305510387`*^9, 
   3.5141774314090405`*^9}, {3.515025759901434*^9, 3.515025766066787*^9}, {
   3.5151944538143406`*^9, 3.515194454914342*^9}}],

Cell[TextData[{
 "Rule e2: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4982408276436143`*^9, 
   3.4982408276436143`*^9}, {3.504396314346299*^9, 3.504396315826301*^9}, {
   3.504413197760872*^9, 3.504413198360873*^9}, {3.5044133170010395`*^9, 
   3.5044133173010397`*^9}, {3.5083488469763513`*^9, 
   3.5083488473063517`*^9}, {3.513095050507948*^9, 3.5130950522779503`*^9}, {
   3.513377121572345*^9, 3.5133771223323455`*^9}, {3.5145979213763337`*^9, 
   3.5145979216063337`*^9}, {3.5145980193364706`*^9, 
   3.5145980195364714`*^9}, {3.5151812787898912`*^9, 3.5151812795542927`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], 
       SqrtBox[
        RowBox[{
         FractionBox["a", 
          RowBox[{"a", "+", "b"}]], "+", 
         RowBox[{
          FractionBox["b", 
           RowBox[{"a", "+", "b"}]], 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{
       FractionBox["a", 
        RowBox[{"a", "+", "b"}]], "+", 
       RowBox[{
        FractionBox["b", 
         RowBox[{"a", "+", "b"}]], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975823372004642`*^9, 
   3.4975823431504726`*^9}, {3.4979216297682095`*^9, 
   3.4979216297682095`*^9}, {3.505344687863849*^9, 3.505344687863849*^9}, {
   3.5074187348633986`*^9, 3.5074187409134073`*^9}, {3.5098471722784896`*^9, 
   3.509847174858493*^9}, 3.51180499522484*^9, {3.5151676155136676`*^9, 
   3.5151676298736877`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"a_.", "+", 
      RowBox[{"b_.", "*", 
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"a", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"b", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, {
   3.4979216297682095`*^9, 3.497921629783809*^9}, 3.4979230300422688`*^9, {
   3.505344687883849*^9, 3.505344687883849*^9}, 3.5074187847234683`*^9, {
   3.509847176848496*^9, 3.5098471799084997`*^9}, {3.511804078821556*^9, 
   3.511804083061562*^9}, {3.5118050548249235`*^9, 3.511805058434929*^9}, 
   3.511805389089394*^9, {3.514174480826256*^9, 3.5141744852722635`*^9}, {
   3.5141751035821505`*^9, 3.514175106764556*^9}, 3.5141774512366753`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["f",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[" ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497921629783809*^9, {3.504469937518831*^9, 3.504469952138851*^9}, 
   3.505344687733849*^9, 3.508348861796372*^9, 3.509847181168502*^9, 
   3.510457506665971*^9, {3.5105084183423643`*^9, 3.510508418669965*^9}, {
   3.510508527636156*^9, 3.5105085292741594`*^9}, {3.5130943524479413`*^9, 
   3.513094354226344*^9}, 3.513094964343416*^9, 3.513100019974905*^9, 
   3.5145979384263573`*^9, 3.5145980095664573`*^9, 3.515180963228937*^9, 
   3.515181294046718*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "x"], 
    RowBox[{"EllipticF", "[", 
     RowBox[{"x", ",", "n"}], "]"}]}], "=", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"n", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, {3.497921629815009*^9, 3.497921629815009*^9}, {
   3.49792329284033*^9, 3.4979232943847327`*^9}, {3.5053446395937815`*^9, 
   3.5053446395937815`*^9}, {3.505344713233885*^9, 3.505344713233885*^9}, {
   3.505346510696401*^9, 3.505346510696401*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "2"]}]}], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{"a", "+", "b"}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.497582725161008*^9, 3.497582728721012*^9}, 
   3.497582802891116*^9, {3.509893685281507*^9, 3.509893685281507*^9}, {
   3.5151264190002117`*^9, 3.5151264190002117`*^9}}],

Cell[TextData[{
 "Rule f1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.5043962464162045`*^9, 
   3.5043962850762587`*^9}, {3.504413252610949*^9, 3.5044132530909495`*^9}, {
   3.504413301361017*^9, 3.5044133020910187`*^9}, {3.508348863976375*^9, 
   3.508348864916376*^9}, {3.5130950594779606`*^9, 3.513095060387962*^9}, {
   3.5133771350223637`*^9, 3.513377135282364*^9}, {3.5145979411963615`*^9, 
   3.5145979414963617`*^9}, {3.5145980318864884`*^9, 3.514598032216489*^9}, {
   3.5151812964647226`*^9, 3.515181297213524*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"-", 
      FractionBox["2", 
       RowBox[{"d", " ", 
        SqrtBox[
         RowBox[{"a", "+", "b"}]]}]]}]}]}], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "4"], "-", 
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, 3.505344687743849*^9, 3.5053463635561953`*^9, 
   3.5098471859085083`*^9, 3.50989404465201*^9, 3.515126412682201*^9, 
   3.515167635823696*^9, {3.5157110639834633`*^9, 3.5157110666978683`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Sim", "[", 
         RowBox[{"a", "+", "b"}], "]"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, 3.505344687753849*^9, 
   3.5053463733062086`*^9, {3.5054092959542894`*^9, 3.5054093016142974`*^9}, {
   3.507431779004877*^9, 3.507431782924883*^9}, 3.5098471877485113`*^9, 
   3.50989405898203*^9, 3.5118053931194*^9, 3.514177466743102*^9, {
   3.5151264479070625`*^9, 3.5151264611670856`*^9}, {3.515689278376487*^9, 
   3.5156892815064907`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Sim", "[", 
         RowBox[{"a", "+", "b"}], "]"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Pi", "/", "4"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}]}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"a", "+", "b"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, 3.505344687753849*^9, 
   3.5053463733062086`*^9, {3.5054092959542894`*^9, 3.5054093016142974`*^9}, {
   3.507431779004877*^9, 3.507431782924883*^9}, 3.5098471877485113`*^9, 
   3.50989405898203*^9, 3.5118053931194*^9, 3.514177466743102*^9, 
   3.515126438125846*^9, {3.515689285906497*^9, 3.515689289336502*^9}, {
   3.515711071877077*^9, 3.515711081892295*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"f", "[", "z", "]"}]}]}], 
       RowBox[{"a", "+", "b"}]]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354612514423*^9, 
   3.508354612514423*^9}}],

Cell[TextData[{
 "Note: Since ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["a", 
     RowBox[{"a", "+", "b"}]], "+", 
    FractionBox["b", 
     RowBox[{"a", "+", "b"}]]}], "=", 
   RowBox[{"1", ">", "0"}]}]]],
 ", rule f1 applies to the resulting integrand."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.497582428440592*^9, 
   3.4975824695406494`*^9}, 3.4975829172612762`*^9, 3.497921629815009*^9, {
   3.4991291005894375`*^9, 3.4991291026694403`*^9}, {3.5067957135723715`*^9, 
   3.5067957287842445`*^9}, {3.51417741964662*^9, 3.5141774204266214`*^9}, {
   3.515025892968045*^9, 3.5150258957342033`*^9}, {3.515194478564375*^9, 
   3.5151944789643755`*^9}}],

Cell[TextData[{
 "Rule f2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4976405001418433`*^9, 3.497640503464649*^9}, {3.4982409098137293`*^9, 
   3.4982409098137293`*^9}, {3.5043962887062635`*^9, 3.504396290556266*^9}, {
   3.5044132557009535`*^9, 3.5044132561509542`*^9}, {3.5044133044510217`*^9, 
   3.504413305251023*^9}, {3.508348868626382*^9, 3.5083488694363823`*^9}, {
   3.5130950627779655`*^9, 3.5130950644079676`*^9}, {3.5133771393823695`*^9, 
   3.51337713965237*^9}, {3.5145979469663696`*^9, 3.51459794723637*^9}, {
   3.5145980356764936`*^9, 3.514598035906494*^9}, {3.5151813011915307`*^9, 
   3.5151813014255314`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{
        FractionBox["a", 
         RowBox[{"a", "+", "b"}]], "+", 
        RowBox[{
         FractionBox["b", 
          RowBox[{"a", "+", "b"}]], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       RowBox[{
        FractionBox["a", 
         RowBox[{"a", "+", "b"}]], "+", 
        RowBox[{
         FractionBox["b", 
          RowBox[{"a", "+", "b"}]], 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.4976403449059706`*^9, {3.4976403873536453`*^9, 3.4976403923456535`*^9}, {
   3.497921629815009*^9, 3.4979216298306093`*^9}, {3.5053446877738495`*^9, 
   3.5053446877738495`*^9}, {3.509847190318515*^9, 3.509847192628518*^9}, 
   3.5118044003020062`*^9, {3.515167642193705*^9, 3.515167644383708*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", 
       RowBox[{"b", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "/", 
          RowBox[{"(", 
           RowBox[{"a", "+", "b"}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"b", "/", 
           RowBox[{"(", 
            RowBox[{"a", "+", "b"}], ")"}]}], "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.4976403184795237`*^9, {3.4979216298306093`*^9, 3.4979216298306093`*^9}, 
   3.4979234149105444`*^9, {3.505344687793849*^9, 3.505344687793849*^9}, {
   3.5098471944485207`*^9, 3.5098471966885233`*^9}, 3.511805396469404*^9, 
   3.514177472234312*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.504470970480277*^9, 3.504470974790283*^9}, {3.504988512420684*^9, 
   3.5049885147006874`*^9}, 3.505344689173851*^9, 3.509847506058957*^9, 
   3.5100197256274047`*^9, 3.5105084716008577`*^9, {3.5120540754101243`*^9, 
   3.512054075710125*^9}, {3.5130944045676327`*^9, 3.513094442101299*^9}, {
   3.5130950994180164`*^9, 3.5130951030580215`*^9}, 3.5141478502481556`*^9, {
   3.5142562504919596`*^9, 3.5142562591719723`*^9}, {3.5145980640465336`*^9, 
   3.5145980656365356`*^9}, {3.5151809660213413`*^9, 
   3.5151809732909546`*^9}, {3.515181353607623*^9, 3.515181354028824*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"f", "[", "z", "]"}], 
       RowBox[{"n", "/", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}], ")"}], 
       RowBox[{"n", "/", "2"}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}, {
   3.5145906419142942`*^9, 3.514590647794303*^9}, {3.5145910204648247`*^9, 
   3.514591065314887*^9}, {3.514591115034957*^9, 3.514591118734962*^9}, {
   3.5145982272067623`*^9, 3.514598232546769*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["n", "2"], "=", "1"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514591220365104*^9, 3.5145912332651224`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], ")"}], 
      RowBox[{"n", "/", "2"}]]}]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}], 
    RowBox[{"n", "/", "2"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"n", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.5142558354813786`*^9, 
   3.514255880171441*^9}, {3.5145904078139668`*^9, 3.514590422863988*^9}, {
   3.514590487924079*^9, 3.5145905069341054`*^9}, {3.514590825104551*^9, 
   3.5145908275345545`*^9}, {3.5145909363647065`*^9, 
   3.5145909822547708`*^9}, {3.514591243025136*^9, 3.5145912521451488`*^9}, {
   3.515167654833723*^9, 3.515167665903738*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_.", "*", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}]}], ")"}], "^", "n_"}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "^", "n"}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"n", "^", "2"}], "-", 
      RowBox[{"1", "/", "4"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, 3.5114915571842628`*^9, 
   3.5118058688600655`*^9, {3.512054723081031*^9, 3.5120547404210553`*^9}, 
   3.513624193491332*^9, 3.514220936683169*^9, {3.514225945177966*^9, 
   3.5142259557547846`*^9}, 3.514255913511488*^9, 3.514589901303258*^9, {
   3.5145906710443354`*^9, 3.51459070299438*^9}, 3.514591184375054*^9, {
   3.514591264545166*^9, 3.514591305395223*^9}, 3.5145958016633663`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5076647229436293`*^9, 3.507664727563636*^9}, 
   3.514253181887664*^9}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{
    RowBox[{"-", "2"}], "<", "n", "<", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, 
   3.5142558168413525`*^9, {3.514598142866644*^9, 3.5145981469766493`*^9}, {
   3.5145981919067125`*^9, 3.5145981930867143`*^9}, {3.5146368879674587`*^9, 
   3.514636892241866*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "n"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.4975780293224325`*^9, {3.4975829856013722`*^9, 
   3.4975830009913936`*^9}, {3.4987607563116155`*^9, 3.498760763041625*^9}, {
   3.499305498308893*^9, 3.499305517262926*^9}, {3.5059666670951004`*^9, 
   3.505966716827945*^9}, {3.5061955618794093`*^9, 3.506195570159421*^9}, {
   3.5072431872612705`*^9, 3.5072432404261637`*^9}, {3.5072432976002645`*^9, 
   3.507243301266271*^9}, {3.5073303069156404`*^9, 3.507330321715661*^9}, {
   3.507442381782913*^9, 3.507442392375332*^9}, 3.5075807801865673`*^9, {
   3.5075809222567663`*^9, 3.5075809253967705`*^9}, {3.507581708877867*^9, 
   3.5075817131678734`*^9}, 3.507583132911872*^9, {3.507583209907988*^9, 
   3.5075832236516123`*^9}, {3.5075992725639963`*^9, 
   3.5075992769640017`*^9}, {3.510507751378793*^9, 3.510507771081628*^9}, 
   3.510508890991995*^9, {3.510508922036049*^9, 3.5105089452800903`*^9}, 
   3.5105089757001433`*^9, {3.5142257979137073`*^9, 3.5142258077261243`*^9}, {
   3.5142526409569063`*^9, 3.5142526458869133`*^9}, {3.5142558354813786`*^9, 
   3.514255880171441*^9}, {3.5145980839965615`*^9, 3.5145980911865716`*^9}, {
   3.514636932599137*^9, 3.514636936046743*^9}, {3.515167673643749*^9, 
   3.515167683553763*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\n", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "n"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "n", "<", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, {3.4982401285726357`*^9, 3.4982401313526397`*^9}, {
   3.4987611327521424`*^9, 3.4987611393821516`*^9}, {3.4987611708821955`*^9, 
   3.498761277792345*^9}, {3.498761669522894*^9, 3.4987616788229065`*^9}, {
   3.4987619391432714`*^9, 3.498761943263277*^9}, {3.499183308350725*^9, 
   3.4991833124847326`*^9}, {3.499185161474782*^9, 3.499185164828788*^9}, {
   3.499305530288949*^9, 3.4993055385257635`*^9}, {3.505966844688258*^9, 
   3.50596686517743*^9}, {3.5059669219046745`*^9, 3.5059669229497347`*^9}, {
   3.50596738600922*^9, 3.5059673883963566`*^9}, {3.5061955820294375`*^9, 
   3.506195592559452*^9}, {3.507243361763177*^9, 3.5072433812008114`*^9}, {
   3.5073303887157545`*^9, 3.507330393995762*^9}, {3.507330454915848*^9, 
   3.50733048518589*^9}, {3.507330529445952*^9, 3.5073305427059703`*^9}, {
   3.507330812806349*^9, 3.507330823296363*^9}, {3.5073309520265436`*^9, 
   3.5073309814665847`*^9}, {3.5073313288470707`*^9, 
   3.5073313330470767`*^9}, {3.5073320683081064`*^9, 
   3.5073320876581335`*^9}, {3.5073327496090603`*^9, 
   3.5073327527890644`*^9}, {3.5073328122591476`*^9, 
   3.5073328126791487`*^9}, {3.5073328632292194`*^9, 
   3.5073328824192457`*^9}, {3.5073338298225737`*^9, 3.507333833852579*^9}, {
   3.5073961002459946`*^9, 3.5073961026559973`*^9}, {3.5074422952495613`*^9, 
   3.507442320646406*^9}, {3.5074424047149534`*^9, 3.5074424054637547`*^9}, {
   3.507442805760458*^9, 3.5074428128896704`*^9}, 3.5074861142120705`*^9, {
   3.5074864950826035`*^9, 3.507486496282605*^9}, {3.5074944863850803`*^9, 
   3.507494489973087*^9}, {3.5074963472513857`*^9, 3.507496349076589*^9}, {
   3.5075808096266084`*^9, 3.507580833566642*^9}, 3.507580978416845*^9, {
   3.507581788827979*^9, 3.50758179663799*^9}, {3.5075820427603455`*^9, 
   3.507582043290346*^9}, {3.507583272495298*^9, 3.507583311432966*^9}, {
   3.507599282044009*^9, 3.5075992908940215`*^9}, 3.5075993572241144`*^9, {
   3.507661921989708*^9, 3.507661925799713*^9}, {3.5076646483035245`*^9, 
   3.5076646494435263`*^9}, {3.510507847693362*^9, 3.510507881217821*^9}, {
   3.5105087569097595`*^9, 3.510508781089802*^9}, 3.5114915571842628`*^9, 
   3.5118058688600655`*^9, {3.512054723081031*^9, 3.5120547404210553`*^9}, 
   3.513624193491332*^9, 3.514220936683169*^9, {3.514225945177966*^9, 
   3.5142259557547846`*^9}, 3.514255913511488*^9, 3.514589901303258*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "17"}], "-", "18"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.504470970480277*^9, 3.504470974790283*^9}, {3.504988512420684*^9, 
   3.5049885147006874`*^9}, 3.505344689173851*^9, 3.509847506058957*^9, 
   3.5100197256274047`*^9, 3.5105084716008577`*^9, {3.5120540754101243`*^9, 
   3.512054075710125*^9}, {3.5130944045676327`*^9, 3.513094442101299*^9}, {
   3.5130950994180164`*^9, 3.5130951030580215`*^9}, 3.5141478502481556`*^9, 
   3.5151809681117454`*^9, {3.516557837739217*^9, 3.5165578418888235`*^9}, {
   3.516590854529684*^9, 3.5165908562596865`*^9}, {3.5165915067505975`*^9, 
   3.516591509150601*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 6 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, 3.5053451232244587`*^9, {
   3.5102847875556*^9, 3.510284788866002*^9}, {3.5102848374756875`*^9, 
   3.510284866600939*^9}, {3.5102849518082886`*^9, 3.5102849541326923`*^9}, {
   3.5102850804773145`*^9, 3.510285085531723*^9}, 3.5120643319224977`*^9, {
   3.5141464414261837`*^9, 3.5141464737662287`*^9}}],

Cell[TextData[{
 "Rule 17: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", "<", 
    RowBox[{"-", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.510508496654502*^9, 3.5105084968417025`*^9}, {
   3.5141472473773117`*^9, 3.514147248397313*^9}, {3.5144873754863253`*^9, 
   3.514487376236326*^9}, {3.5165915238106213`*^9, 3.5165915243306217`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], "\[CenterDot]", 
   "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"a", " ", "b", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.499404301116287*^9, 
   3.49940430323629*^9}, {3.4994048006769867`*^9, 3.4994048025069895`*^9}, {
   3.5003179811489162`*^9, 3.5003179814297166`*^9}, 3.5003181853432746`*^9, {
   3.5003185563630857`*^9, 3.500318557803087*^9}, {3.5013586287231283`*^9, 
   3.5013586400931444`*^9}, 3.5027672052757444`*^9, 3.5035556969716425`*^9, 
   3.5053446414737844`*^9, {3.505344693303857*^9, 3.505344708433878*^9}, 
   3.5053535619252167`*^9, {3.5094747245329013`*^9, 3.509474861672745*^9}, {
   3.510164259570264*^9, 3.510164264265872*^9}, {3.5101644808722525`*^9, 
   3.5101645606039925`*^9}, {3.5101665987113705`*^9, 
   3.5101666055813804`*^9}, {3.5102847826571913`*^9, 
   3.5102848146840477`*^9}, {3.5102848478029056`*^9, 
   3.5102848488793077`*^9}, {3.510284905944208*^9, 3.5102849085962124`*^9}, {
   3.510284996018766*^9, 3.5102850591520767`*^9}, {3.5102850954689407`*^9, 
   3.5102851436262255`*^9}, {3.5102852086315393`*^9, 3.51028520886554*^9}, {
   3.510285564936165*^9, 3.5102855657317667`*^9}, {3.5151677147238064`*^9, 
   3.5151677449038486`*^9}, {3.5159776660180893`*^9, 3.515977673474902*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "^", "2"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", "^", "2"}], "-", 
              RowBox[{"b", "^", "2"}]}], ")"}], "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "*", "b", "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "1"}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", "^", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{"n", "+", "2"}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, {3.51028568692318*^9, 3.510285690370786*^9}, 
   3.5102857690261245`*^9, {3.5146472453478017`*^9, 3.514647263038233*^9}, {
   3.5146473583388*^9, 3.5146473641108103`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, 
   3.505345123294459*^9, {3.5102680075767136`*^9, 3.510268048246771*^9}, {
   3.510286142802781*^9, 3.5102861557352037`*^9}, {3.5102870731364155`*^9, 
   3.5102871063020735`*^9}, 3.5120643631125417`*^9, {3.514146179705817*^9, 
   3.514146207565856*^9}, {3.5141462511659174`*^9, 3.514146276685953*^9}}],

Cell[TextData[{
 "Rule 18: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"n", ">", "2"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.5102868863104877`*^9, 3.5102868869032884`*^9}, {3.5102869285553617`*^9, 
   3.5102869294913635`*^9}, {3.510508500086508*^9, 3.5105085005233088`*^9}, {
   3.5141472920273743`*^9, 3.5141472938373766`*^9}, {3.5144867293554206`*^9, 
   3.5144867301054215`*^9}, {3.516591527740627*^9, 3.5165915282906275`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Csc", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
          RowBox[{"n", "-", "2"}]]}], 
        RowBox[{"d", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"n", "-", "1"}]], " ", "\[CenterDot]", "\[IndentingNewLine]", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "3"], 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "+", 
       RowBox[{"b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], 
           RowBox[{"(", 
            RowBox[{"n", "-", "2"}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["a", "2"], 
           RowBox[{"(", 
            RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"a", " ", 
        SuperscriptBox["b", "2"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", "n"}], "-", "4"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "-", "3"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5095562652147536`*^9, 3.5095563252848377`*^9}, {3.50955638387492*^9, 
   3.5095564136949615`*^9}, {3.5095564499650126`*^9, 
   3.5095565745651865`*^9}, {3.509556659575306*^9, 3.5095566816053367`*^9}, {
   3.5095567320554075`*^9, 3.5095567407354193`*^9}, {3.509556895905637*^9, 
   3.5095569251456776`*^9}, {3.510172496160655*^9, 3.510172513227085*^9}, {
   3.5101727774135485`*^9, 3.5101727805647545`*^9}, {3.5101732386595592`*^9, 
   3.51017323937716*^9}, {3.510173272480418*^9, 3.510173288844847*^9}, 
   3.5102680174567275`*^9, {3.510268078456813*^9, 3.5102681014568453`*^9}, {
   3.510268150966914*^9, 3.510268299197122*^9}, {3.510268367137217*^9, 
   3.510268412957281*^9}, {3.5102684572773433`*^9, 3.5102684593973465`*^9}, {
   3.5102863885968122`*^9, 3.510286412808055*^9}, {3.5102864480017166`*^9, 
   3.510286556983508*^9}, {3.5102865980739803`*^9, 3.5102866897553415`*^9}, 
   3.5102867460090404`*^9, {3.5151677847839046`*^9, 3.5151678074939365`*^9}, {
   3.515977699417748*^9, 3.515977709869766*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"b", "^", "2"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "2"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "3"}], "*", 
            RowBox[{"(", 
             RowBox[{"n", "-", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"b", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"b", "^", "2"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"n", "-", "2"}], ")"}]}], "+", 
                RowBox[{"3", "*", 
                 RowBox[{"a", "^", "2"}], "*", 
                 RowBox[{"(", 
                  RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "*", 
              RowBox[{"b", "^", "2"}], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"3", "*", "n"}], "-", "4"}], ")"}]}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
         "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "-", "3"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "2"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, 
   3.4979862281609955`*^9, {3.4979862780186834`*^9, 3.4979862991255207`*^9}, 
   3.4979863964508915`*^9, {3.497990453203616*^9, 3.497990473936053*^9}, 
   3.4986794274067383`*^9, {3.498763920866046*^9, 3.4987639593560996`*^9}, {
   3.4991312222624083`*^9, 3.49913122341241*^9}, {3.5010427775038137`*^9, 
   3.501042778515871*^9}, {3.5030725326890316`*^9, 3.5030725406290426`*^9}, 
   3.5038761341846743`*^9, 3.5043679506879787`*^9, {3.5051850204098253`*^9, 
   3.505185024399053*^9}, 3.5053446405137825`*^9, {3.5053446906538534`*^9, 
   3.505344714143886*^9}, 3.5053519910530176`*^9, 3.508782980727106*^9, {
   3.5098952623037148`*^9, 3.509895264533718*^9}, {3.510267358245805*^9, 
   3.510267363695812*^9}, 3.5102674525359364`*^9, {3.51026851924743*^9, 
   3.510268522147434*^9}, 3.510268653627618*^9, {3.5102687229377155`*^9, 
   3.510268727847722*^9}, 3.510286783854707*^9, {3.510286855412032*^9, 
   3.5102868598424406`*^9}, {3.510286899944911*^9, 3.510286906169322*^9}, 
   3.5144098564243727`*^9, 3.514583254360516*^9, {3.5146471295643983`*^9, 
   3.514647165163661*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "15"}], "-", "16"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.504470970480277*^9, 3.504470974790283*^9}, {3.504988512420684*^9, 
   3.5049885147006874`*^9}, 3.505344689173851*^9, 3.509847506058957*^9, 
   3.5100197256274047`*^9, 3.5105084716008577`*^9, {3.5120540754101243`*^9, 
   3.512054075710125*^9}, {3.5130944045676327`*^9, 3.513094442101299*^9}, {
   3.5130950994180164`*^9, 3.5130951030580215`*^9}, 3.5141478502481556`*^9, 
   3.5151809681117454`*^9, {3.5165568817603393`*^9, 3.516556914841197*^9}, {
   3.5165908426796675`*^9, 3.516590849379677*^9}, {3.5165915030505924`*^9, 
   3.5165915054805956`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Rule 10a inverted", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, 3.5053451232244587`*^9, 
   3.5120643314424973`*^9, {3.5141470715870657`*^9, 3.5141471052171125`*^9}, {
   3.5144869477857265`*^9, 3.5144869622357464`*^9}, {3.514487331846264*^9, 
   3.5144873614563055`*^9}, {3.5145874907671595`*^9, 3.514587527910825*^9}, {
   3.5145983012468653`*^9, 3.514598302946868*^9}, {3.514613128168194*^9, 
   3.514613132941802*^9}, {3.514645771410413*^9, 3.5146457852944374`*^9}, {
   3.51465244895723*^9, 3.5146524544372377`*^9}}],

Cell[TextData[{
 "Rule 15: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.5102868863104877`*^9, 3.5102868869032884`*^9}, {3.5102869285553617`*^9, 
   3.5102869294913635`*^9}, {3.510508500086508*^9, 3.5105085005233088`*^9}, {
   3.5141472920273743`*^9, 3.5141472938373766`*^9}, {3.514147377677494*^9, 
   3.5141473784874954`*^9}, {3.5141527536711903`*^9, 
   3.5141527536711903`*^9}, {3.5144864172649837`*^9, 3.5144864182949853`*^9}, 
   3.5144877987669177`*^9, {3.5145870601068025`*^9, 3.514587068593217*^9}, {
   3.516556918881604*^9, 3.5165569205976067`*^9}, {3.516591538850642*^9, 
   3.5165915403206444`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"2", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
         RowBox[{"n", "+", "1"}]]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "n"}], "+", "k", "+", "3"}], ")"}], 
    RowBox[{
     SuperscriptBox["b", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "k", "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{"n", "+", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, 3.497640636985284*^9, {3.49764069135378*^9, 
   3.4976406986701927`*^9}, {3.497640801957974*^9, 3.497640818119602*^9}, {
   3.4976415480136843`*^9, 3.497641558013302*^9}, {3.4976416100549936`*^9, 
   3.4976416105853944`*^9}, {3.497641694014341*^9, 3.4976417027971563`*^9}, {
   3.4976419324219604`*^9, 3.4976419802360444`*^9}, {3.497642204143238*^9, 
   3.4976422158276587`*^9}, {3.4979216146361823`*^9, 3.4979216448378353`*^9}, 
   3.4979241791246867`*^9, 3.505344639993782*^9, {3.505344689253851*^9, 
   3.5053447136338854`*^9}, 3.5053455533550606`*^9, {3.5098475084489603`*^9, 
   3.509847511068964*^9}, {3.5141471242171392`*^9, 3.514147129517147*^9}, {
   3.514487154166015*^9, 3.5144872242061133`*^9}, {3.5144873977763567`*^9, 
   3.5144874140763793`*^9}, 3.514487613946659*^9, {3.51448767179674*^9, 
   3.514487673686743*^9}, {3.5145863787288055`*^9, 3.5145864183996754`*^9}, {
   3.5145865682691383`*^9, 3.514586684520543*^9}, {3.5145867278886185`*^9, 
   3.5145867530202627`*^9}, {3.5145869654770365`*^9, 
   3.5145869765998554`*^9}, {3.515167690573773*^9, 3.515167695263779*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_.", "*", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "n"}], "+", "k", "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"b", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "k", "+", "1"}], ")"}]}], ")"}]}], 
      ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "+", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, {3.514487423866393*^9, 3.5144874773564677`*^9}, {
   3.5144875091265125`*^9, 3.5144875099565134`*^9}, 3.5144876512067113`*^9, {
   3.514487694756772*^9, 3.514487698386777*^9}, {3.514488103627344*^9, 
   3.5144881038173447`*^9}, {3.5145864869461956`*^9, 3.514586511703439*^9}, {
   3.5145870925236597`*^9, 3.514587094458063*^9}, {3.5145871435357485`*^9, 
   3.514587157279373*^9}, 3.5168211923672123`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a or 3b with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"a", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, 3.5053451232244587`*^9, {3.5102632131400013`*^9, 
   3.5102632375300355`*^9}, {3.5104225256204214`*^9, 3.5104225256204214`*^9}, 
   3.5120643626225405`*^9, {3.5141467446466084`*^9, 3.514146749056614*^9}, {
   3.514146800286686*^9, 3.514146806916695*^9}, {3.5141469844369435`*^9, 
   3.5141469907669525`*^9}, {3.51448634359488*^9, 3.5144863590649023`*^9}}],

Cell[TextData[{
 "Rule 16: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.5102868863104877`*^9, 3.5102868869032884`*^9}, {3.5102869285553617`*^9, 
   3.5102869294913635`*^9}, {3.510508500086508*^9, 3.5105085005233088`*^9}, {
   3.5141472920273743`*^9, 3.5141472938373766`*^9}, {3.514147377677494*^9, 
   3.5141473784874954`*^9}, {3.5141527536711903`*^9, 
   3.5141527536711903`*^9}, {3.5144864172649837`*^9, 3.5144864182949853`*^9}, 
   3.5144877987669177`*^9, {3.5165569234992123`*^9, 3.516556924154413*^9}, {
   3.5165915423306475`*^9, 3.5165915431306486`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "n"}], "+", "k", "-", "1"}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "n"}], "+", "k", "-", "3"}], ")"}]}], 
    RowBox[{
     RowBox[{"2", " ", "n"}], "+", "k", "-", "1"}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.509826148849055*^9, 3.50982648101952*^9}, {3.50982653116959*^9, 
   3.509826604149692*^9}, {3.5101747057641363`*^9, 3.510174708665741*^9}, {
   3.510175116325657*^9, 3.5101751335636873`*^9}, {3.514485825994156*^9, 
   3.514485961674346*^9}, {3.5144860063144083`*^9, 3.5144860393744545`*^9}, {
   3.514486095234533*^9, 3.51448610036454*^9}, 3.5144867465754447`*^9, 
   3.514487728476819*^9, {3.5151677597538695`*^9, 3.515167765693878*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b_.", "*", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
     "n_"}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "b", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "-", "1"}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "-", "3"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "k", "-", "1"}], ")"}]}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "2"}], ")"}]}], ",", "x"}], "]"}]}], "]"}]}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.497577987032373*^9, 
   3.4975829614713383`*^9, 3.4975831484616003`*^9, 3.4975832895717974`*^9, {
   3.4979216146049824`*^9, 3.4979216448222356`*^9}, 3.4979236654001846`*^9, {
   3.4981987086091685`*^9, 3.4981987164091825`*^9}, {3.4981987562360525`*^9, 
   3.498198756563653*^9}, {3.4982411011539974`*^9, 3.498241103034*^9}, {
   3.5017330383946285`*^9, 3.501733038800229*^9}, {3.501733070701085*^9, 
   3.501733075100292*^9}, {3.5031145982909107`*^9, 3.5031146095385303`*^9}, {
   3.503883100784115*^9, 3.5038831023441176`*^9}, {3.5043676148075085`*^9, 
   3.504367618347513*^9}, 3.5053446400637827`*^9, {3.505344689333851*^9, 
   3.5053447136938853`*^9}, 3.5053456710052257`*^9, 3.508439032390652*^9, {
   3.509847523238981*^9, 3.5098475246289825`*^9}, 3.511459116976429*^9, 
   3.511805548999618*^9, {3.5120532760509987`*^9, 3.512053278951003*^9}, 
   3.512054082220134*^9, {3.5134422284957695`*^9, 3.5134422298957715`*^9}, {
   3.5141356760929937`*^9, 3.5141356805234013`*^9}, {3.514137621831835*^9, 
   3.514137631141848*^9}, {3.514147337857438*^9, 3.5141473571874657`*^9}, {
   3.514152750191185*^9, 3.5141527505311856`*^9}, 3.514177998879638*^9, {
   3.5144864372450113`*^9, 3.514486541605158*^9}, {3.5144866521953125`*^9, 
   3.514486652385313*^9}, {3.5144867057253876`*^9, 3.514486705985388*^9}, {
   3.514487488846484*^9, 3.514487489876485*^9}, {3.514487706676789*^9, 
   3.5144877100567937`*^9}, {3.514487761026865*^9, 3.5144877691468763`*^9}, 
   3.5168211923972125`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", "1"}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.5047258667134433`*^9, 3.5047259284235296`*^9, {
   3.50472971453883*^9, 3.504729719478837*^9}, {3.5047304814999037`*^9, 
   3.5047304917899184`*^9}, {3.5053445844837046`*^9, 
   3.5053445851537056`*^9}, {3.5100199355257735`*^9, 3.510019945338191*^9}, {
   3.510019976460245*^9, 3.510019976460245*^9}, {3.5101703833552046`*^9, 
   3.5101703833552046`*^9}, {3.5102544956897216`*^9, 
   3.5102544956897216`*^9}, {3.5134422770858374`*^9, 3.5134422770858374`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["g",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.5037922680230246`*^9, 3.503792271043029*^9}, 3.5038535371697226`*^9, 
   3.503869777164266*^9, {3.5044701417191167`*^9, 3.504470143429119*^9}, 
   3.507750990808134*^9, 3.5077529297088537`*^9, 3.50836314774479*^9, {
   3.508363191054851*^9, 3.5083632077448745`*^9}, 3.508380386530554*^9, 
   3.508432185445053*^9, 3.5084341690838437`*^9, {3.5084353375254793`*^9, 
   3.50843533792548*^9}, {3.509847197748525*^9, 3.509847198518526*^9}, {
   3.5105836167960615`*^9, 3.510583626966076*^9}, {3.5130942180225053`*^9, 
   3.5130942181941056`*^9}, 3.513095551378649*^9, 3.513100034394925*^9, 
   3.514598397367*^9, {3.5145984469170694`*^9, 3.5145984506270747`*^9}, {
   3.5151809941481915`*^9, 3.515180995708194*^9}, 3.5151813796596684`*^9, {
   3.5166723443813257`*^9, 3.5166723487025337`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    RowBox[{"z", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", " ", "z"}]], "-", 
    FractionBox["b", 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.5004274880015464`*^9, 3.500427526248734*^9}, {
   3.500577748166791*^9, 3.5005777941712723`*^9}, {3.5005778953918495`*^9, 
   3.5005778978566537`*^9}, {3.500583178653531*^9, 3.500583194347159*^9}, {
   3.5083583642480936`*^9, 3.5083583664580965`*^9}, {3.50843226194516*^9, 
   3.508432308345225*^9}, {3.5166724284966736`*^9, 3.51667246652954*^9}}],

Cell["Rule g:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.497663553088928*^9, 3.4976635622149444`*^9}, {
   3.4979894880299215`*^9, 3.4979894894339237`*^9}, 3.500583244454447*^9, {
   3.5048085188584366`*^9, 3.5048085195184374`*^9}, 3.508089224627245*^9, 
   3.5083548687747817`*^9, {3.508363182574839*^9, 3.508363210454878*^9}, 
   3.5083803892605577`*^9, {3.5084324517154255`*^9, 3.508432472455455*^9}, 
   3.508434171953848*^9, 3.5105838684064136`*^9, {3.513377283382571*^9, 
   3.5133772836125717`*^9}, {3.514598400567005*^9, 3.5145984007970047`*^9}, 
   3.5145984569470835`*^9, 3.515181381672072*^9, 3.5166725697237215`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "a"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979862492990327`*^9, 
   3.4979862502662344`*^9}, {3.497987000218752*^9, 3.4979870022311554`*^9}, {
   3.500427423095834*^9, 3.5004274236088634`*^9}, {3.5004275574055157`*^9, 
   3.5004276042171936`*^9}, {3.5004328122050734`*^9, 3.500432862882972*^9}, 
   3.500577560076061*^9, {3.5005776542858267`*^9, 3.5005776585134335`*^9}, {
   3.5005778782474194`*^9, 3.5005778816794252`*^9}, {3.5005831554094906`*^9, 
   3.500583168763114*^9}, {3.5083582601079473`*^9, 3.5083582791879745`*^9}, {
   3.5084321966550684`*^9, 3.508432242745133*^9}, {3.508435338515481*^9, 
   3.5084353396954823`*^9}, {3.5098472024485316`*^9, 
   3.5098472051185355`*^9}, {3.515167836293977*^9, 3.51516784604399*^9}, 
   3.5159777406654205`*^9, {3.5166723560345464`*^9, 3.5166724183722563`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sin", "[", 
        RowBox[{"c_.", "+", 
         RowBox[{"d_.", "*", "x_"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}], ",", "x"}], "]"}]}], " ", "-", 
    " ", 
    RowBox[{
     RowBox[{"b", "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], 
    "]"}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5004276750552454`*^9, 3.5004276923832364`*^9}, {3.500427741061021*^9, 
   3.5004277415710497`*^9}, 3.5004329174270916`*^9, {3.500432950987011*^9, 
   3.500433005771145*^9}, {3.5005779794447966`*^9, 3.5005780180236645`*^9}, 
   3.500578063248144*^9, 3.500578099767808*^9, {3.5005832139251933`*^9, 
   3.500583240086439*^9}, {3.5083587271786013`*^9, 3.5083587379086165`*^9}, {
   3.508358813958723*^9, 3.508358816458727*^9}, {3.508432384255331*^9, 
   3.508432444825416*^9}, {3.5084330622062807`*^9, 3.5084330632262816`*^9}, {
   3.5084353403254833`*^9, 3.508435341415485*^9}, {3.5098472081385393`*^9, 
   3.5098472109985437`*^9}, {3.516672495249191*^9, 3.516672499991599*^9}, {
   3.516672547649683*^9, 3.516672555777297*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{"e_", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "e"}], "-", 
        RowBox[{"a", "*", "f"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}], " ", "-", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"f", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "e"}], "-", 
        RowBox[{"a", "*", "f"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{"f", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
      "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"b", "*", "e"}], "-", 
      RowBox[{"a", "*", "f"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.497986253963441*^9, 
   3.4979862552738433`*^9}, 3.4979863375295877`*^9, {3.497986505495083*^9, 
   3.497986507819487*^9}, {3.49798706165166*^9, 3.497987068765272*^9}, {
   3.497987706708393*^9, 3.497987708642796*^9}, {3.4979879276983805`*^9, 
   3.497987930365986*^9}, 3.4979880679114275`*^9, 3.498497171646879*^9, {
   3.5004276750552454`*^9, 3.5004276923832364`*^9}, {3.500427741061021*^9, 
   3.5004277415710497`*^9}, 3.5004329174270916`*^9, {3.500432950987011*^9, 
   3.500433005771145*^9}, {3.5005779794447966`*^9, 3.5005780180236645`*^9}, 
   3.500578063248144*^9, 3.500578099767808*^9, {3.5005832139251933`*^9, 
   3.500583240086439*^9}, {3.5083587271786013`*^9, 3.5083587379086165`*^9}, {
   3.508358813958723*^9, 3.508358816458727*^9}, {3.508432384255331*^9, 
   3.508432444825416*^9}, {3.5084330622062807`*^9, 3.5084330632262816`*^9}, {
   3.5084353403254833`*^9, 3.508435341415485*^9}, {3.5098472081385393`*^9, 
   3.5098472109985437`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["h",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.504413676081542*^9, {3.504470145549122*^9, 3.5044701473791246`*^9}, 
   3.5077486213248167`*^9, {3.508360384110921*^9, 3.508360387590926*^9}, {
   3.5083617749528685`*^9, 3.5083618048729105`*^9}, 3.5084341798238583`*^9, {
   3.5084354673956614`*^9, 3.5084354682056627`*^9}, {3.509847225058563*^9, 
   3.509847225588564*^9}, {3.513094221860112*^9, 3.5130942221097126`*^9}, 
   3.5130955538786526`*^9, 3.513100036384928*^9, 3.5145984675370984`*^9, {
   3.5151809971745963`*^9, 3.515180998562999*^9}, 3.515181390486088*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"2", "m"}], ",", 
      RowBox[{
       FractionBox["z", "2"], "-", 
       FractionBox["\[Pi]", "4"]}], ",", 
      RowBox[{"2", "n"}]}], "]"}]}], "=", 
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "m", "+", 
       RowBox[{"m", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{"1", "-", "n", "+", 
       RowBox[{"n", " ", 
        RowBox[{"Sin", "[", "z", "]"}]}]}]]}]]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, {3.497921629815009*^9, 3.497921629815009*^9}, {
   3.49792329284033*^9, 3.4979232943847327`*^9}, {3.500665574114345*^9, 
   3.500665579084352*^9}, {3.5037057947638154`*^9, 3.5037058112138386`*^9}, {
   3.5037060418141613`*^9, 3.5037060779242115`*^9}, {3.508360748681432*^9, 
   3.5083607522614365`*^9}, {3.5083609757217493`*^9, 
   3.5083609804417562`*^9}, {3.5084356400459027`*^9, 3.5084356664759398`*^9}}],

Cell[TextData[{
 "Rule h1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"e", "+", "f"}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.503706588564927*^9, 
   3.503706589604928*^9}, {3.5043957204754677`*^9, 3.504395728475479*^9}, 
   3.5044139444019175`*^9, 3.5077486654848785`*^9, {3.508361020591812*^9, 
   3.5083610391318383`*^9}, 3.5083620191532106`*^9, {3.5084341819038615`*^9, 
   3.508434182773863*^9}, {3.513377341102652*^9, 3.5133773414326525`*^9}, {
   3.514598474437108*^9, 3.5145984747071085`*^9}, {3.514752528141506*^9, 
   3.514752528141506*^9}, {3.5151813933720922`*^9, 3.5151813937776933`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"2", " "}], 
      RowBox[{"d", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], 
       SqrtBox[
        RowBox[{"e", "+", "f", " "}]]}]]}]}], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "b"}], 
      RowBox[{"a", "+", "b"}]], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "2"], "-", 
      FractionBox["\[Pi]", "4"]}], ",", 
     FractionBox[
      RowBox[{"2", " ", "f"}], 
      RowBox[{"e", "+", "f"}]]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, {3.5006637227717533`*^9, 
   3.5006637494417906`*^9}, {3.500663932532047*^9, 3.5006639393020563`*^9}, {
   3.5006643002125616`*^9, 3.5006643280526004`*^9}, 3.503706090074229*^9, {
   3.503706145154306*^9, 3.5037061511543145`*^9}, {3.508360396560939*^9, 
   3.5083603992109423`*^9}, {3.5083604395509987`*^9, 3.508360442121002*^9}, {
   3.5083605712611833`*^9, 3.508360573781187*^9}, {3.5083606084712353`*^9, 
   3.508360644581286*^9}, {3.5083612020120664`*^9, 3.508361205492071*^9}, {
   3.5083617973929*^9, 3.5083617994829025`*^9}, {3.5084354794256783`*^9, 
   3.5084354798956785`*^9}, 3.5084357037059917`*^9, {3.5098472289585686`*^9, 
   3.5098472293685694`*^9}, 3.5098978090521507`*^9, 3.515126519323988*^9, {
   3.515167850503997*^9, 3.515167851933999*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"Pi", "/", "2"}], "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e_.", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"Pi", "/", "2"}], "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"e", "+", "f"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"f", "/", 
         RowBox[{"(", 
          RowBox[{"e", "+", "f"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"e", "+", "f"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, 
   3.5006637724018226`*^9, 3.500663837491914*^9, {3.5006639475420675`*^9, 
   3.5006639508120728`*^9}, {3.500664419972729*^9, 3.5006644393127565`*^9}, {
   3.5035339753347754`*^9, 3.5035339845647883`*^9}, {3.5037062012943845`*^9, 
   3.503706235094432*^9}, 3.503706302204526*^9, {3.503706415274684*^9, 
   3.503706444224725*^9}, {3.5037065927949324`*^9, 3.503706593814934*^9}, {
   3.505408949613805*^9, 3.505408954173811*^9}, {3.508361062741871*^9, 
   3.508361078831894*^9}, {3.5083611092119365`*^9, 3.5083611620720105`*^9}, {
   3.508361235982114*^9, 3.5083612851021824`*^9}, {3.508361844782966*^9, 
   3.5083618491829724`*^9}, 3.508362042403243*^9, {3.50843548083568*^9, 
   3.508435481545681*^9}, {3.5084357668260803`*^9, 3.508435768476083*^9}, {
   3.5098472304585705`*^9, 3.5098472311385717`*^9}, 3.5098978853830843`*^9, 
   3.5147525102414813`*^9, {3.5151267616860137`*^9, 3.515126779516845*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e_.", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"(", 
        RowBox[{"a", "+", "b"}], ")"}], "*", 
       RowBox[{"Rt", "[", 
        RowBox[{
         RowBox[{"e", "+", "f"}], ",", "2"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"b", "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}]}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "-", 
       RowBox[{"Pi", "/", "4"}]}], ",", 
      RowBox[{"Sim", "[", 
       RowBox[{"2", "*", 
        RowBox[{"f", "/", 
         RowBox[{"(", 
          RowBox[{"e", "+", "f"}], ")"}]}]}], "]"}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{"e", "+", "f"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, 
   3.5006637724018226`*^9, 3.500663837491914*^9, {3.5006639475420675`*^9, 
   3.5006639508120728`*^9}, {3.500664419972729*^9, 3.5006644393127565`*^9}, {
   3.5035339753347754`*^9, 3.5035339845647883`*^9}, {3.5037062012943845`*^9, 
   3.503706235094432*^9}, 3.503706302204526*^9, {3.503706415274684*^9, 
   3.503706444224725*^9}, {3.5037065927949324`*^9, 3.503706593814934*^9}, {
   3.505408949613805*^9, 3.505408954173811*^9}, {3.508361062741871*^9, 
   3.508361078831894*^9}, {3.5083611092119365`*^9, 3.5083611620720105`*^9}, {
   3.508361235982114*^9, 3.5083612851021824`*^9}, {3.508361844782966*^9, 
   3.5083618491829724`*^9}, 3.508362042403243*^9, {3.50843548083568*^9, 
   3.508435481545681*^9}, {3.5084357668260803`*^9, 3.508435768476083*^9}, {
   3.5098472304585705`*^9, 3.5098472311385717`*^9}, 3.5098978853830843`*^9, 
   3.5147525102414813`*^9, 3.5151267529499984`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      FractionBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"g", "[", "z", "]"}]}]}], 
       RowBox[{"e", "+", "f"}]]], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"g", "[", "z", "]"}]}]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}}],

Cell[TextData[{
 "Note: Since ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["e", 
     RowBox[{"e", "+", "f"}]], "+", 
    FractionBox["f", 
     RowBox[{"e", "+", "f"}]]}], "=", 
   RowBox[{"1", ">", "0"}]}]]],
 ", rule h1 applies to the resulting integrand."
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.497582428440592*^9, 
   3.4975824695406494`*^9}, 3.4975829172612762`*^9, 3.497921629815009*^9, {
   3.4991291005894375`*^9, 3.4991291026694403`*^9}, {3.506795928551496*^9, 
   3.50679593466028*^9}, {3.508361611202639*^9, 3.5083616248626585`*^9}, {
   3.5151814103605223`*^9, 3.515181418550537*^9}}],

Cell[TextData[{
 "Rule h2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"\[Not]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"e", "+", "f"}], ">", "0"}], ")"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4976405001418433`*^9, 3.497640503464649*^9}, {3.4982409098137293`*^9, 
   3.4982409098137293`*^9}, {3.5048085379984636`*^9, 3.504808538938465*^9}, {
   3.508089230767253*^9, 3.5080892310272536`*^9}, {3.5083548759647913`*^9, 
   3.508354876324792*^9}, {3.508361467982439*^9, 3.5083614706124425`*^9}, {
   3.5083620300732255`*^9, 3.508362030923227*^9}, {3.508434186573868*^9, 
   3.508434187373869*^9}, {3.5133773446126566`*^9, 3.5133773448626575`*^9}, {
   3.514598478757114*^9, 3.514598478997114*^9}, {3.514752515641489*^9, 
   3.514752519351494*^9}, {3.5151814143385296`*^9, 3.51518141465053*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SqrtBox[
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      SqrtBox[
       FractionBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
        RowBox[{"e", "+", "f"}]]], 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SqrtBox[
        RowBox[{
         FractionBox["e", 
          RowBox[{"e", "+", "f"}]], "+", 
         RowBox[{
          FractionBox["f", 
           RowBox[{"e", "+", "f"}]], 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.4976403449059706`*^9, {3.4976403873536453`*^9, 3.4976403923456535`*^9}, {
   3.497921629815009*^9, 3.4979216298306093`*^9}, {3.5006641158123035`*^9, 
   3.5006641274723196`*^9}, {3.508358394388136*^9, 3.508358411038159*^9}, 
   3.508361500402484*^9, {3.5083615333425303`*^9, 3.508361542652543*^9}, {
   3.5083615795225945`*^9, 3.5083615871326056`*^9}, {3.508361670232722*^9, 
   3.508361677232732*^9}, {3.508361820762933*^9, 3.5083618313229475`*^9}, {
   3.5084354901456933`*^9, 3.5084354932356977`*^9}, {3.5098472348585773`*^9, 
   3.5098472380485816`*^9}, {3.5151678664840193`*^9, 3.515167872074027*^9}, 
   3.5159777715378747`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.508361922653075*^9, 3.508361926853081*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"e_.", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e", "+", 
         RowBox[{"f", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"e", "+", "f"}], ")"}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"e", "+", 
       RowBox[{"f", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], "*", "\n", "    ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"e", "/", 
            RowBox[{"(", 
             RowBox[{"e", "+", "f"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"f", "/", 
             RowBox[{"(", 
              RowBox[{"e", "+", "f"}], ")"}]}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"Not", "[", 
     RowBox[{"PositiveQ", "[", 
      RowBox[{"e", "+", "f"}], "]"}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.4976403184795237`*^9, {3.4979216298306093`*^9, 3.4979216298306093`*^9}, 
   3.4979234149105444`*^9, {3.5006642208124504`*^9, 3.500664251262493*^9}, {
   3.501042441201578*^9, 3.5010424423236423`*^9}, 3.50835876856866*^9, {
   3.5083588359887543`*^9, 3.5083588493687725`*^9}, {3.508361474002447*^9, 
   3.508361475222449*^9}, 3.508361508152495*^9, 3.508361863982993*^9, {
   3.5083619341530914`*^9, 3.508361969583141*^9}, 3.508362668234119*^9, {
   3.508435494305699*^9, 3.5084354965157022`*^9}, {3.5098472409785852`*^9, 
   3.5098472447485905`*^9}, {3.5147524449513903`*^9, 3.514752450151397*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["i",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044137265016127`*^9, {3.5044699931889086`*^9, 3.504469997888915*^9}, {
   3.5053446878938494`*^9, 3.505344687903849*^9}, {3.5083493106070004`*^9, 
   3.5083493115170016`*^9}, {3.5083506878589287`*^9, 
   3.5083506908389325`*^9}, {3.508437063687896*^9, 3.5084370839079247`*^9}, {
   3.508437247918154*^9, 3.508437250318157*^9}, 3.5084508603601675`*^9, {
   3.508653883439679*^9, 3.508653901999705*^9}, {3.509847385418788*^9, 
   3.5098473858687887`*^9}, {3.5130942278661222`*^9, 3.513094228068923*^9}, 
   3.5130955674886713`*^9, 3.513095963239226*^9, 3.5131000415949354`*^9, 
   3.514598926557741*^9, 3.5148617994458704`*^9, {3.515180999842201*^9, 
   3.515181000934203*^9}, 3.515181432949362*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", "z"}]}]], 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["b", 
     RowBox[{"f", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"a", " ", "f"}], "-", 
      RowBox[{"b", " ", "e"}]}], 
     RowBox[{"f", 
      RowBox[{"(", 
       RowBox[{"e", "+", 
        RowBox[{"f", " ", "z"}]}], ")"}], 
      SqrtBox[
       RowBox[{"a", " ", "+", 
        RowBox[{"b", " ", "z"}]}]]}]]}]}]]]
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.500666948156269*^9, 3.5006669508262725`*^9}, {
   3.5006760576590223`*^9, 3.5006760794090524`*^9}, {3.500676130389124*^9, 
   3.500676132759127*^9}, 3.500676240689278*^9, 3.5006764023895044`*^9, {
   3.5006764330595474`*^9, 3.500676467739596*^9}, {3.500677045830405*^9, 
   3.5006770482704086`*^9}, {3.5083585925884132`*^9, 
   3.5083585969384193`*^9}, {3.5083783058576407`*^9, 3.508378358077714*^9}}],

Cell[TextData[{
 "Rule i: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "f"}], "-", 
     RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.5084342812040005`*^9, 
   3.513377426312771*^9, 3.514598964197794*^9, 3.514861832535917*^9, 
   3.5151814359289675`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["b", "f"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "f"}], "-", 
     RowBox[{"b", " ", "e"}]}], "f"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497639950506078*^9, 3.4976399764957237`*^9}, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.497923207991781*^9, {
   3.4991292213496065`*^9, 3.499129226379614*^9}, 3.5006646650530725`*^9, {
   3.5006652709839206`*^9, 3.500665282473937*^9}, 3.5006668515961337`*^9, {
   3.5006668992662*^9, 3.5006669216762314`*^9}, {3.5006756467284465`*^9, 
   3.500675652058454*^9}, {3.500676422829533*^9, 3.500676426179538*^9}, {
   3.5006769280202403`*^9, 3.5006769719603024`*^9}, {3.5006770647304316`*^9, 
   3.500677084220459*^9}, {3.50835843329819*^9, 3.508358456938223*^9}, {
   3.5083782298375344`*^9, 3.508378245757557*^9}, {3.5084371648280373`*^9, 
   3.50843716654804*^9}, {3.5098473871687903`*^9, 3.5098473892987933`*^9}, {
   3.5151678758440323`*^9, 3.51516788151404*^9}, 3.5159777898055067`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "/", "f"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ",", "x"}], 
      "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", "f"}], "-", 
        RowBox[{"b", "*", "e"}]}], ")"}], "/", "f"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"e", "+", 
            RowBox[{"f", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "f"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.497639879666353*^9, {
   3.497921614589382*^9, 3.497921644806636*^9}, 3.4979231493512783`*^9, {
   3.499129496489992*^9, 3.49912950910001*^9}, {3.5006670128563595`*^9, 
   3.500667030256384*^9}, {3.5006756721584826`*^9, 3.5006757072485313`*^9}, 
   3.5006761770891895`*^9, {3.500676504879648*^9, 3.500676511719658*^9}, {
   3.500676615389803*^9, 3.50067662058981*^9}, {3.50067712041051*^9, 
   3.500677157770562*^9}, 3.500684516250436*^9, {3.508358781038677*^9, 
   3.508358787338686*^9}, {3.5083588719288044`*^9, 3.508358881988818*^9}, {
   3.508378414067792*^9, 3.5083784269778104`*^9}, {3.508378464587863*^9, 
   3.508378467637867*^9}, {3.5083785093179255`*^9, 3.50837851959794*^9}, {
   3.5083787060882015`*^9, 3.5083787263182297`*^9}, 3.508380619208137*^9, {
   3.5084371686080427`*^9, 3.508437170918046*^9}, {3.5098473915587964`*^9, 
   3.5098473943488007`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["j",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]], 
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044137265016127`*^9, {3.5044699931889086`*^9, 3.504469997888915*^9}, {
   3.5053446878938494`*^9, 3.505344687903849*^9}, {3.5083493106070004`*^9, 
   3.5083493115170016`*^9}, {3.5083506878589287`*^9, 
   3.5083506908389325`*^9}, {3.508437063687896*^9, 3.5084370839079247`*^9}, {
   3.508437247918154*^9, 3.508437250318157*^9}, 3.5084508603601675`*^9, {
   3.5086538863696833`*^9, 3.5086539045097084`*^9}, {3.5098474030388126`*^9, 
   3.5098474033588133`*^9}, {3.513094229114125*^9, 3.5130942293325253`*^9}, 
   3.5130955695386744`*^9, 3.513095966959231*^9, 3.513100043324938*^9, 
   3.514598928177743*^9, 3.514861801845874*^9, {3.5151810021510053`*^9, 
   3.5151810032898073`*^9}, 3.5151814448053827`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, {3.5017331736456656`*^9, 3.501733192084898*^9}, {
   3.5037071786357527`*^9, 3.5037071821457577`*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"e", "+", 
     RowBox[{"f", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox[
     RowBox[{"b", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}], "f"], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "f"}], "-", 
        RowBox[{"b", " ", "e"}]}], ")"}], 
      SqrtBox[
       RowBox[{"a", " ", "+", 
        RowBox[{"b", " ", "z"}]}]]}], 
     RowBox[{"f", 
      RowBox[{"(", 
       RowBox[{"e", "+", 
        RowBox[{"f", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, {3.497921629815009*^9, 3.497921629815009*^9}, {
   3.49792329284033*^9, 3.4979232943847327`*^9}, {3.500665574114345*^9, 
   3.500665579084352*^9}, {3.5037057947638154`*^9, 3.5037058112138386`*^9}, {
   3.5037060418141613`*^9, 3.5037060779242115`*^9}, 3.5037071432757034`*^9, {
   3.5037093357487726`*^9, 3.5037093589888053`*^9}, 3.508379494439305*^9, {
   3.508379545189376*^9, 3.508379579079423*^9}}],

Cell[TextData[{
 "Rule j: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", "f"}], "-", 
     RowBox[{"b", " ", "e"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083775601165967`*^9, {
   3.5083787694382896`*^9, 3.5083787807083054`*^9}, 3.508379709069605*^9, 
   3.508434285164006*^9, 3.513377438952789*^9, 3.5145989720378046`*^9, 
   3.514861840885928*^9, 3.51518144892379*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], 
     RowBox[{"e", "+", 
      RowBox[{"f", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["b", "f"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"a", " ", "f"}], "-", 
     RowBox[{"b", " ", "e"}]}], "f"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{"e", "+", 
       RowBox[{"f", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, {3.5006637227717533`*^9, 
   3.5006637494417906`*^9}, {3.500663932532047*^9, 3.5006639393020563`*^9}, {
   3.5006643002125616`*^9, 3.5006643280526004`*^9}, 3.503706090074229*^9, {
   3.503706145154306*^9, 3.5037061511543145`*^9}, {3.503706990075489*^9, 
   3.5037070229855347`*^9}, 3.5037075942263346`*^9, 3.503707785076602*^9, {
   3.503709231438627*^9, 3.503709234438631*^9}, {3.5037092810886965`*^9, 
   3.5037092905987096`*^9}, {3.508379103238757*^9, 3.508379107788763*^9}, {
   3.508379329799074*^9, 3.508379374709137*^9}, {3.508379409729186*^9, 
   3.5083794292692137`*^9}, {3.50843717329805*^9, 3.5084371742480507`*^9}, {
   3.5098474046188145`*^9, 3.5098474057688165`*^9}, {3.5151678854140453`*^9, 
   3.5151678906040525`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"e_.", "+", 
       RowBox[{"f_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "/", "f"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], ",", "x"}], "]"}]}], 
    " ", "+", " ", "\[IndentingNewLine]", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "*", "f"}], "-", 
         RowBox[{"b", "*", "e"}]}], ")"}], "/", "f"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"e", "+", 
           RowBox[{"f", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], 
       "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"e", "^", "2"}], "-", 
      RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "*", "f"}], "-", 
      RowBox[{"b", "*", "e"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, 
   3.5006637724018226`*^9, 3.500663837491914*^9, {3.5006639475420675`*^9, 
   3.5006639508120728`*^9}, {3.500664419972729*^9, 3.5006644393127565`*^9}, {
   3.5035339753347754`*^9, 3.5035339845647883`*^9}, {3.5037062012943845`*^9, 
   3.503706235094432*^9}, 3.503706302204526*^9, {3.503706415274684*^9, 
   3.503706444224725*^9}, {3.5037065927949324`*^9, 3.503706593814934*^9}, {
   3.5037071976757793`*^9, 3.503707206025791*^9}, 3.5037072620958695`*^9, {
   3.503709379408834*^9, 3.5037094036788683`*^9}, {3.504996643812068*^9, 
   3.504996647622073*^9}, {3.504997186592828*^9, 3.504997190122833*^9}, {
   3.5083796089694653`*^9, 3.5083796272194905`*^9}, {3.5083796889695773`*^9, 
   3.5083797178396177`*^9}, {3.508437175078052*^9, 3.508437175928053*^9}, {
   3.509847406278817*^9, 3.509847407538819*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["k",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, {
   3.5044701489091268`*^9, 3.50447015113913*^9}, 3.5077488141850867`*^9, {
   3.5083894050351534`*^9, 3.5083894083735595`*^9}, 3.508434192933877*^9, {
   3.508436200046687*^9, 3.5084362006466875`*^9}, {3.5098472501585984`*^9, 
   3.509847250518599*^9}, {3.513094224044116*^9, 3.513094224278116*^9}, 
   3.5130955554086547`*^9, 3.513100038594931*^9, 3.514598494267136*^9, {
   3.514598615167305*^9, 3.514598620757313*^9}, 3.5148618038658767`*^9, {
   3.515181005505011*^9, 3.515181006706213*^9}, 3.515181457207405*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"b", "-", "a"}], ">", "0"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "z"}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], 
      RowBox[{"1", "+", "z"}]]]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.503683954247945*^9, 3.5036839576799507`*^9}, {
   3.503684195673969*^9, 3.503684222053615*^9}, {3.5037654709570775`*^9, 
   3.5037654754070835`*^9}}],

Cell[TextData[{
 "Rule k1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["a", "2"]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.503605565226612*^9, 
   3.503605598986659*^9}, 3.5036070990887594`*^9, {3.5036095247521553`*^9, 
   3.50360952795216*^9}, {3.5043956403553553`*^9, 3.504395669285396*^9}, {
   3.50441396742195*^9, 3.50441398186197*^9}, {3.508349669007502*^9, 
   3.508349669867503*^9}, {3.508436407966978*^9, 3.5084364084969788`*^9}, {
   3.5133773557026725`*^9, 3.513377356212673*^9}, {3.514598496737139*^9, 
   3.51459849758714*^9}, {3.5148618502159414`*^9, 3.514861850735942*^9}, {
   3.515181460639411*^9, 3.5151814614974127`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["2", 
      RowBox[{"d", " ", 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]}]]}]}], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, {3.5037774212685356`*^9, 3.503777436010562*^9}, {
   3.5037823964368377`*^9, 3.5037823991968412`*^9}, 3.505344639733782*^9, {
   3.50534468850385*^9, 3.505344713383885*^9}, {3.505350995614727*^9, 
   3.505350998531932*^9}, {3.5053510613688426`*^9, 3.5053510679832544`*^9}, {
   3.509847251998601*^9, 3.509847252648602*^9}, 3.509899124269702*^9, 
   3.5151265464680357`*^9, {3.5151678947740583`*^9, 3.5151678961840606`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "b", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.503777634718511*^9, 
   3.505344639743782*^9, {3.50534468852385*^9, 3.5053447133938847`*^9}, {
   3.505351124392953*^9, 3.505351125781356*^9}, {3.5053512048422947`*^9, 
   3.505351206059097*^9}, {3.5054094144644556`*^9, 3.5054094199744635`*^9}, 
   3.5054106502561855`*^9, {3.509847255348606*^9, 3.5098472567486076`*^9}, 
   3.5098992293798494`*^9, 3.511718679451358*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis:  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"f", "[", "z", "]"}]}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"f", "[", "z", "]"}]}], ")"}]}]]]}], ")"}]}], "=", "0"}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, 3.5036876317117357`*^9, {3.503777261976656*^9, 
   3.503777261976656*^9}, {3.50377732690397*^9, 3.503777330211176*^9}, {
   3.5083546327544513`*^9, 3.5083546327544513`*^9}}],

Cell[TextData[{
 "Rule k2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.503687809691985*^9, 
   3.5036878202819996`*^9}, {3.5036910540785284`*^9, 3.503691064608543*^9}, {
   3.5036914578790936`*^9, 3.5036914589290953`*^9}, {3.50377059129212*^9, 
   3.50377059129212*^9}, {3.5037747966780715`*^9, 3.5037747966780715`*^9}, {
   3.503777187954526*^9, 3.503777187954526*^9}, {3.5043956882954226`*^9, 
   3.5043956903754253`*^9}, {3.504413989671981*^9, 3.5044139906119823`*^9}, {
   3.508349676627513*^9, 3.5083496789575157`*^9}, {3.5083498289477262`*^9, 
   3.508349830097728*^9}, {3.5084364111669827`*^9, 3.5084364120169835`*^9}, {
   3.513377358912677*^9, 3.513377359882678*^9}, {3.514598503227148*^9, 
   3.514598503727149*^9}, {3.5148618531959457`*^9, 3.514861854145947*^9}, {
   3.515181466848222*^9, 3.515181467129022*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], "  ", 
    "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
    FractionBox[
     RowBox[{"2", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]}], 
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]]], 
   RowBox[{"EllipticF", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, {3.502074068873864*^9, 3.502074103287524*^9}, {
   3.502074222097333*^9, 3.502074222580934*^9}, {3.502074331141525*^9, 
   3.5020743532623634`*^9}, {3.5036875972516875`*^9, 
   3.5036876078817024`*^9}, {3.503776844254722*^9, 3.5037768678107634`*^9}, 
   3.5037769050792294`*^9, 3.5037769395396895`*^9, {3.503776970271744*^9, 
   3.5037770037806025`*^9}, {3.503777077709132*^9, 3.5037771161787996`*^9}, {
   3.5037824089768553`*^9, 3.5037824099068565`*^9}, 3.505344639763782*^9, {
   3.50534468858385*^9, 3.505344713403885*^9}, 3.505351198773884*^9, {
   3.5098472609886136`*^9, 3.509847272168629*^9}, 3.509899127729707*^9, 
   3.51512655454885*^9, {3.5151679002740664`*^9, 3.5151679016540685`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"2", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], "]"}], "*", 
    "\n", "  ", 
    RowBox[{"EllipticF", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, {
   3.5020741121795397`*^9, 3.5020741279043674`*^9}, {3.502074235014156*^9, 
   3.5020742444521723`*^9}, {3.5020743100034876`*^9, 3.502074313622694*^9}, {
   3.502074430045698*^9, 3.5020744584377484`*^9}, 3.5020748031939535`*^9, {
   3.5036876601817756`*^9, 3.503687665111782*^9}, {3.5036877336618786`*^9, 
   3.5036877357018814`*^9}, {3.503687824822006*^9, 3.5036878312620153`*^9}, {
   3.5036915244191866`*^9, 3.5036915313691964`*^9}, {3.503768459687133*^9, 
   3.5037684669371433`*^9}, 3.503770433351899*^9, {3.503772360984661*^9, 
   3.5037723695846734`*^9}, 3.5037749445282784`*^9, 3.503777192634534*^9, {
   3.5037775786832128`*^9, 3.5037775818344183`*^9}, 3.5037776183228827`*^9, 
   3.505344639773782*^9, {3.5053446886038504`*^9, 3.505344713413885*^9}, 
   3.505351244903165*^9, 3.505409429404476*^9, 3.5054106512461867`*^9, {
   3.5098472876286507`*^9, 3.509847288228652*^9}, 3.5098992372498603`*^9, 
   3.51171868840137*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["l",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.5037922680230246`*^9, 3.503792271043029*^9}, 3.5038535371697226`*^9, 
   3.503869777164266*^9, {3.5044701417191167`*^9, 3.504470143429119*^9}, {
   3.50534468835385*^9, 3.50534468835385*^9}, 3.5083493712770853`*^9, {
   3.5084382377095394`*^9, 3.508438239529542*^9}, 3.5086546508307533`*^9, {
   3.509847460628893*^9, 3.5098474609688935`*^9}, {3.5130942413601465`*^9, 
   3.5130942415785465`*^9}, 3.513095583588694*^9, 3.513095980059249*^9, 
   3.5131000601549616`*^9, 3.514598942847764*^9, 3.5148618059058795`*^9, {
   3.515181008328616*^9, 3.515181009576618*^9}, 3.515181477768241*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell[TextData[{
 "Rule l: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.504395467815114*^9, 3.504395468855116*^9}, 3.5044134935312862`*^9, 
   3.5077509925081367`*^9, 3.5077529278888516`*^9, 3.5083632227748957`*^9, 
   3.508380395140566*^9, 3.5086310963405914`*^9, 3.513377608083026*^9, 
   3.5145992494881935`*^9, 3.514861882255986*^9, 3.5151814805918455`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", "a"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, 3.5038696365424623`*^9, {3.503869666572504*^9, 
   3.5038696695325084`*^9}, 3.5083527415018034`*^9, {3.5086323118371267`*^9, 
   3.5086323389967747`*^9}, {3.508654663630771*^9, 3.5086546674007764`*^9}, {
   3.5098474619088945`*^9, 3.5098474646688986`*^9}, {3.5151679137940855`*^9, 
   3.515167924934101*^9}, 3.515977822753965*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"a", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, 3.503851442368843*^9, 3.503869917614463*^9, {
   3.5038699479017515`*^9, 3.503869961781771*^9}, {3.508352748471813*^9, 
   3.5083527515018177`*^9}, 3.5086323848920555`*^9, {3.508654667990777*^9, 
   3.5086546708507814`*^9}, {3.5098474657189007`*^9, 3.5098474686489043`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["m",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.504470000568919*^9, 3.5044700107489333`*^9}, {3.507749986536728*^9, 
   3.5077499874367294`*^9}, 3.508377230596135*^9, {3.5083775108565273`*^9, 
   3.508377511076528*^9}, {3.508390625361698*^9, 3.508390640150524*^9}, {
   3.508434289394012*^9, 3.5084342914040146`*^9}, {3.5084372799981985`*^9, 
   3.508437280298199*^9}, {3.5086540196298695`*^9, 3.50865403407989*^9}, {
   3.509847412078825*^9, 3.509847412328826*^9}, {3.5130942323745303`*^9, 
   3.513094232546131*^9}, 3.5130955716286774`*^9, 3.5130959688892336`*^9, 
   3.5131000456949415`*^9, 3.5145989306677465`*^9, 3.5148618085558834`*^9, {
   3.5151810114486217`*^9, 3.515181012462623*^9}, 3.5151814919174657`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Rule m1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, 3.511723015157428*^9, 3.5117235997982464`*^9, {
   3.5117236451883097`*^9, 3.5117236579783278`*^9}, {3.5133774467128*^9, 
   3.513377447592801*^9}, {3.5145989852778234`*^9, 3.514598985587824*^9}, {
   3.5148619054060187`*^9, 3.514861905696019*^9}, {3.515181495021871*^9, 
   3.515181495505472*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{" ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       RowBox[{"\[Integral]", 
        RowBox[{
         FractionBox["1", 
          RowBox[{
           SqrtBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]], 
           SqrtBox[
            RowBox[{"a", "+", 
             RowBox[{"b", " ", 
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
         RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, 
   3.503766096195198*^9, {3.5037661877253265`*^9, 3.5037662215753736`*^9}, {
   3.5037934245846434`*^9, 3.50379345749469*^9}, {3.5037935423448086`*^9, 
   3.503793545024812*^9}, 3.5037936152649107`*^9, {3.50379430075587*^9, 
   3.503794334785918*^9}, 3.50379511440884*^9, {3.5077498602365513`*^9, 
   3.50774986646656*^9}, {3.5083772829662085`*^9, 3.5083772943262243`*^9}, {
   3.5083773590963154`*^9, 3.508377372616334*^9}, {3.508388786478467*^9, 
   3.5083887924376774`*^9}, {3.5084372823782024`*^9, 3.508437284128205*^9}, {
   3.5098474132988267`*^9, 3.5098474148488293`*^9}, {3.51172374536845*^9, 
   3.5117237851985064`*^9}, {3.5151679385641203`*^9, 3.515167941314124*^9}, 
   3.515977840085595*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.503793631084933*^9, 3.503793632574935*^9}, {
   3.5037944216260395`*^9, 3.5037944225760407`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, {3.503766302475487*^9, 3.50376632618552*^9}, {
   3.503766402395627*^9, 3.503766407875635*^9}, {3.503770024751327*^9, 
   3.50377002685133*^9}, {3.503794417466034*^9, 3.503794451276081*^9}, 
   3.503795118059246*^9, {3.50835146720002*^9, 3.5083514771000333`*^9}, {
   3.508351568700162*^9, 3.5083515849901843`*^9}, {3.5083773160962553`*^9, 
   3.508377338276286*^9}, {3.508377434756421*^9, 3.5083774377764254`*^9}, {
   3.508377494506505*^9, 3.5083774993365116`*^9}, {3.508388797211286*^9, 
   3.508388807647704*^9}, {3.5083889395927362`*^9, 3.508388945255546*^9}, {
   3.508437284598205*^9, 3.5084372861482077`*^9}, {3.50984741543883*^9, 
   3.509847417008832*^9}, 3.5117167391086416`*^9, {3.511719388862351*^9, 
   3.511719391572355*^9}, {3.511719766062879*^9, 3.5117197816929007`*^9}, {
   3.5117198420629854`*^9, 3.511719872013027*^9}, 3.511723615988269*^9, {
   3.5117238714786267`*^9, 3.5117238892586517`*^9}, {3.5117239642487564`*^9, 
   3.511723997078802*^9}, {3.5117240334888535`*^9, 3.511724037738859*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Rule m2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, 3.511723015157428*^9, 3.5117235997982464`*^9, {
   3.5117236451883097`*^9, 3.5117236476883135`*^9}, {3.5133774503128047`*^9, 
   3.513377451182806*^9}, {3.514598989547829*^9, 3.5145989900378304`*^9}, {
   3.514861911086027*^9, 3.514861912006028*^9}, {3.5151814989842777`*^9, 
   3.515181499561479*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{" ", 
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, 
   3.503766096195198*^9, {3.5037661877253265`*^9, 3.5037662215753736`*^9}, {
   3.5037934245846434`*^9, 3.50379345749469*^9}, {3.5037935423448086`*^9, 
   3.503793545024812*^9}, 3.5037936152649107`*^9, {3.50379430075587*^9, 
   3.503794334785918*^9}, 3.50379511440884*^9, {3.5077498602365513`*^9, 
   3.50774986646656*^9}, {3.5083772829662085`*^9, 3.5083772943262243`*^9}, {
   3.5083773590963154`*^9, 3.508377372616334*^9}, {3.508388786478467*^9, 
   3.5083887924376774`*^9}, {3.5084372823782024`*^9, 3.508437284128205*^9}, {
   3.5098474132988267`*^9, 3.5098474148488293`*^9}, {3.511723750078457*^9, 
   3.5117237507984576`*^9}, {3.5117238134785457`*^9, 
   3.5117238319685717`*^9}, {3.5151679489341345`*^9, 3.5151679561841445`*^9}, 
   3.515977843876402*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.503793631084933*^9, 3.503793632574935*^9}, {
   3.5037944216260395`*^9, 3.5037944225760407`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b"}], ")"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"b", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, {3.503766302475487*^9, 3.50376632618552*^9}, {
   3.503766402395627*^9, 3.503766407875635*^9}, {3.503770024751327*^9, 
   3.50377002685133*^9}, {3.503794417466034*^9, 3.503794451276081*^9}, 
   3.503795118059246*^9, {3.50835146720002*^9, 3.5083514771000333`*^9}, {
   3.508351568700162*^9, 3.5083515849901843`*^9}, {3.5083773160962553`*^9, 
   3.508377338276286*^9}, {3.508377434756421*^9, 3.5083774377764254`*^9}, {
   3.508377494506505*^9, 3.5083774993365116`*^9}, {3.508388797211286*^9, 
   3.508388807647704*^9}, {3.5083889395927362`*^9, 3.508388945255546*^9}, {
   3.508437284598205*^9, 3.5084372861482077`*^9}, {3.50984741543883*^9, 
   3.509847417008832*^9}, 3.5117167391086416`*^9, {3.511719388862351*^9, 
   3.511719391572355*^9}, {3.511719766062879*^9, 3.5117197816929007`*^9}, {
   3.5117198420629854`*^9, 3.511719872013027*^9}, 3.511723615988269*^9, {
   3.5117238934486575`*^9, 3.511723958258748*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell["\<\
Note: This rule unifies rules m1 and m2, but requires messy application \
conditions.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.511722659036929*^9, 3.511722738757041*^9}, {3.5151815153643064`*^9, 
   3.51518152839033*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, 3.511723015157428*^9, 3.5117235997982464`*^9, {
   3.5133774729628363`*^9, 3.5133774737628374`*^9}, 3.5145989988778424`*^9, 
   3.5148619251160464`*^9, 3.5151815044754877`*^9, {3.515194572664507*^9, 
   3.515194572874507*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{" ", 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
        SqrtBox[
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"b", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       SqrtBox[
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, 
   3.503766096195198*^9, {3.5037661877253265`*^9, 3.5037662215753736`*^9}, {
   3.5037934245846434`*^9, 3.50379345749469*^9}, {3.5037935423448086`*^9, 
   3.503793545024812*^9}, 3.5037936152649107`*^9, {3.50379430075587*^9, 
   3.503794334785918*^9}, 3.50379511440884*^9, {3.5077498602365513`*^9, 
   3.50774986646656*^9}, {3.5083772829662085`*^9, 3.5083772943262243`*^9}, {
   3.5083773590963154`*^9, 3.508377372616334*^9}, {3.508388786478467*^9, 
   3.5083887924376774`*^9}, {3.5084372823782024`*^9, 3.508437284128205*^9}, {
   3.5098474132988267`*^9, 3.5098474148488293`*^9}, {3.515167961534152*^9, 
   3.5151679641441555`*^9}, 3.515977847854409*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.503793631084933*^9, 3.503793632574935*^9}, {
   3.5037944216260395`*^9, 3.5037944225760407`*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"e_.", "+", 
        RowBox[{"f_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", 
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], "*", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"e", "+", 
             RowBox[{"f", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], " ", "+", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{"b", ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"e", "+", 
              RowBox[{"f", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
         "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"e", "^", "2"}], "-", 
       RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "e"}], "-", 
       RowBox[{"a", "*", "f"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, {3.503766302475487*^9, 3.50376632618552*^9}, {
   3.503766402395627*^9, 3.503766407875635*^9}, {3.503770024751327*^9, 
   3.50377002685133*^9}, {3.503794417466034*^9, 3.503794451276081*^9}, 
   3.503795118059246*^9, {3.50835146720002*^9, 3.5083514771000333`*^9}, {
   3.508351568700162*^9, 3.5083515849901843`*^9}, {3.5083773160962553`*^9, 
   3.508377338276286*^9}, {3.508377434756421*^9, 3.5083774377764254`*^9}, {
   3.508377494506505*^9, 3.5083774993365116`*^9}, {3.508388797211286*^9, 
   3.508388807647704*^9}, {3.5083889395927362`*^9, 3.508388945255546*^9}, {
   3.508437284598205*^9, 3.5084372861482077`*^9}, {3.50984741543883*^9, 
   3.509847417008832*^9}, 3.5117167391086416`*^9, {3.511719388862351*^9, 
   3.511719391572355*^9}, {3.511719766062879*^9, 3.5117197816929007`*^9}, {
   3.5117198420629854`*^9, 3.511719872013027*^9}, 3.511723615988269*^9, {
   3.5133774880128574`*^9, 3.5133774924928637`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["n",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{" ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.504470000568919*^9, 3.5044700107489333`*^9}, {3.507749986536728*^9, 
   3.5077499874367294`*^9}, 3.508377230596135*^9, {3.5083775108565273`*^9, 
   3.508377511076528*^9}, {3.508390625361698*^9, 3.508390640150524*^9}, {
   3.508434289394012*^9, 3.5084342914040146`*^9}, {3.5084372799981985`*^9, 
   3.508437280298199*^9}, {3.5086540281098814`*^9, 3.5086540365098934`*^9}, {
   3.509847417668833*^9, 3.5098474179188337`*^9}, {3.5130942342621336`*^9, 
   3.513094234480534*^9}, 3.5130955745186815`*^9, 3.513095971029237*^9, 
   3.513100049214946*^9, 3.5145989327077494`*^9, 3.514861810755886*^9, {
   3.515181013585825*^9, 3.5151810147246275`*^9}, 3.515181541977954*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Rule n1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, {3.5117231920676756`*^9, 3.5117231922376757`*^9}, {
   3.511723722388418*^9, 3.511723723148419*^9}, {3.513377536972926*^9, 
   3.5133775371929264`*^9}, {3.5145991702680826`*^9, 
   3.5145991714380836`*^9}, {3.5148619351460605`*^9, 
   3.5148619354160604`*^9}, {3.515181543959157*^9, 3.5151815447547584`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"a", "-", "b"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["a", 
    RowBox[{"a", "-", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.5076127763984814`*^9, 
   3.5076128071242385`*^9}, 3.5076130465769343`*^9, {3.5083732519879675`*^9, 
   3.5083732907384357`*^9}, 3.5083733452137313`*^9, {3.5083886663894563`*^9, 
   3.508388682363884*^9}, {3.5084632355077705`*^9, 3.508463294569474*^9}, {
   3.5084635215498724`*^9, 3.508463523468676*^9}, {3.5086085358778715`*^9, 
   3.5086085375002747`*^9}, {3.5098474230588408`*^9, 3.509847425398844*^9}, {
   3.511723058667489*^9, 3.511723126617584*^9}, {3.511723260207771*^9, 
   3.511723261707773*^9}, {3.515167970184164*^9, 3.515167971994167*^9}, 
   3.5159778716412506`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", " ", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, 
   3.5076128775622673`*^9, {3.507612916492494*^9, 3.507612944323086*^9}, {
   3.5076130584166117`*^9, 3.5076130663340645`*^9}, {3.5083733592381554`*^9, 
   3.5083733848066006`*^9}, {3.5083734610595345`*^9, 3.5083734653963423`*^9}, 
   3.5083735959685717`*^9, {3.508388698572313*^9, 3.5083887255447598`*^9}, {
   3.5084633423367577`*^9, 3.5084633483427687`*^9}, 3.5084634258281045`*^9, {
   3.508463468104179*^9, 3.5084634690089808`*^9}, {3.5086085393254776`*^9, 
   3.508608541119481*^9}, {3.5098474265088453`*^9, 3.509847428458848*^9}, 
   3.511723209137699*^9, {3.51172333837788*^9, 3.511723372407928*^9}, 
   3.5117234414880247`*^9, {3.511723476558074*^9, 3.511723487248089*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Rule n2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, {
   3.508466829578085*^9, 3.508466836114496*^9}, 3.5084671368362246`*^9, {
   3.5117237254084225`*^9, 3.511723726168423*^9}, {3.5133775399629307`*^9, 
   3.513377540682931*^9}, {3.51459917589809*^9, 3.5145991784580936`*^9}, {
   3.5148619392560663`*^9, 3.5148619394860663`*^9}, {3.515181548202365*^9, 
   3.515181548561165*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"a", 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"3", "/", "2"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.5076127763984814`*^9, 
   3.5076128071242385`*^9}, 3.5076130465769343`*^9, {3.5083732519879675`*^9, 
   3.5083732907384357`*^9}, 3.5083733452137313`*^9, {3.5083886663894563`*^9, 
   3.508388682363884*^9}, {3.5084632355077705`*^9, 3.508463294569474*^9}, {
   3.5084635215498724`*^9, 3.508463523468676*^9}, {3.50846671873989*^9, 
   3.508466774010787*^9}, {3.5084668971106033`*^9, 3.5084669030698137`*^9}, {
   3.508608530371062*^9, 3.508608532211865*^9}, {3.5098474186688347`*^9, 
   3.509847419928836*^9}, {3.515167975914172*^9, 3.5151679775641747`*^9}, 
   3.5159778756036577`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", " ", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, 
   3.5076128775622673`*^9, {3.507612916492494*^9, 3.507612944323086*^9}, {
   3.5076130584166117`*^9, 3.5076130663340645`*^9}, {3.5083733592381554`*^9, 
   3.5083733848066006`*^9}, {3.5083734610595345`*^9, 3.5083734653963423`*^9}, 
   3.5083735959685717`*^9, {3.508388698572313*^9, 3.5083887255447598`*^9}, {
   3.5084633423367577`*^9, 3.5084633483427687`*^9}, 3.5084634258281045`*^9, {
   3.508463468104179*^9, 3.5084634690089808`*^9}, {3.508467014079609*^9, 
   3.508467066776501*^9}, {3.5086085329450665`*^9, 3.508608534676669*^9}, {
   3.509847420368837*^9, 3.509847421918839*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell["\<\
Note: This rule unifies rules n1 and n2, but requires messy application \
conditions.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.511722659036929*^9, 3.511722738757041*^9}, {3.515181554707576*^9, 
   3.5151815635215917`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, 3.511723015157428*^9, 3.5133775447929373`*^9, 
   3.5145991856781034`*^9, {3.514861943996073*^9, 3.514861944296073*^9}, {
   3.515194584204523*^9, 3.515194584404523*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"e", "-", "f"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
        SqrtBox[
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], 
    RowBox[{"e", "-", "f"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.5076127763984814`*^9, 
   3.5076128071242385`*^9}, 3.5076130465769343`*^9, {3.5083732519879675`*^9, 
   3.5083732907384357`*^9}, 3.5083733452137313`*^9, {3.5083886663894563`*^9, 
   3.508388682363884*^9}, {3.5084632355077705`*^9, 3.508463294569474*^9}, {
   3.5084635215498724`*^9, 3.508463523468676*^9}, {3.5086085358778715`*^9, 
   3.5086085375002747`*^9}, {3.5098474230588408`*^9, 3.509847425398844*^9}, {
   3.515167982024181*^9, 3.5151679838641834`*^9}, 3.5159778804240665`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e_.", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"e", "-", "f"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"e", "+", 
              RowBox[{"f", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
         "x"}], "]"}]}], "]"}], " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", "*", "e"}], "-", 
          RowBox[{"a", "*", "f"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"e", "-", "f"}], ")"}]}], ",", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"e", "+", 
               RowBox[{"f", "*", 
                RowBox[{"sin", "[", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", " ", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"e", "^", "2"}], "-", 
       RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "e"}], "-", 
       RowBox[{"a", "*", "f"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, 
   3.5076128775622673`*^9, {3.507612916492494*^9, 3.507612944323086*^9}, {
   3.5076130584166117`*^9, 3.5076130663340645`*^9}, {3.5083733592381554`*^9, 
   3.5083733848066006`*^9}, {3.5083734610595345`*^9, 3.5083734653963423`*^9}, 
   3.5083735959685717`*^9, {3.508388698572313*^9, 3.5083887255447598`*^9}, {
   3.5084633423367577`*^9, 3.5084633483427687`*^9}, 3.5084634258281045`*^9, {
   3.508463468104179*^9, 3.5084634690089808`*^9}, {3.5086085393254776`*^9, 
   3.508608541119481*^9}, {3.5098474265088453`*^9, 3.509847428458848*^9}, {
   3.511723019507434*^9, 3.5117230233974395`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["o",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]], 
      SqrtBox[
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507750706437736*^9, 3.507750711687743*^9}, {
   3.5084343005740275`*^9, 3.5084343027140307`*^9}, {3.50843500229501*^9, 
   3.5084350081450186`*^9}, {3.508437560318591*^9, 3.508437560648592*^9}, {
   3.508654302270265*^9, 3.5086543024602656`*^9}, {3.509847429198849*^9, 
   3.5098474294688497`*^9}, {3.513094235478936*^9, 3.513094235681736*^9}, 
   3.5130955766186843`*^9, 3.5130959728992395`*^9, 3.5131000511549487`*^9, 
   3.514598934537752*^9, 3.5148618130758896`*^9, {3.5151810172050314`*^9, 
   3.5151810183126335`*^9}, 3.5151815735992093`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule o1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507750716857751*^9, 3.508434306474036*^9, 3.5086309198262815`*^9, {
   3.513377563172963*^9, 3.513377563402963*^9}, {3.5145991950481167`*^9, 
   3.5145991953281174`*^9}, {3.5148619568960905`*^9, 3.514861957126091*^9}, {
   3.515181575736413*^9, 3.5151815768128147`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"3", "/", "2"}]], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox["a", 
        RowBox[{"2", " ", "b"}]]}]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"a", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", "b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, {
   3.5086254907707424`*^9, 3.508625514779185*^9}, {3.5086256627298446`*^9, 
   3.508625667441053*^9}, {3.50865434123032*^9, 3.508654344540324*^9}, {
   3.5098474300388503`*^9, 3.5098474318688526`*^9}, {3.515167990014192*^9, 
   3.5151679926041956`*^9}, 3.515978008725091*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ",", "x_Symbol"}],
    "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "a"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "b"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "b"}], ")"}]}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"2", "*", "b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, {
   3.5083518540405607`*^9, 3.5083518707005844`*^9}, {3.5086256354609966`*^9, 
   3.5086256788134727`*^9}, {3.5086543454803257`*^9, 3.508654347910329*^9}, {
   3.5098474323688536`*^9, 3.5098474343888564`*^9}, {3.5159780444023533`*^9, 
   3.5159780454475555`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule o2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, 3.5076127417565*^9, 
   3.507750824167901*^9, 3.508375367273527*^9, 3.5084343099640408`*^9, {
   3.5086309231802874`*^9, 3.508630923819888*^9}, {3.513377566082967*^9, 
   3.513377566802968*^9}, {3.5145991981281214`*^9, 3.5145991983781214`*^9}, {
   3.5148619604260955`*^9, 3.514861960756096*^9}, {3.515181579324419*^9, 
   3.51518157982362*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], 
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"3", "a", " ", "b"}], "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a"}], "-", 
          RowBox[{"3", " ", "b"}]}], ")"}]}], "+", 
       RowBox[{"a", " ", "b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["b", "2"], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, 3.507752208297844*^9, {
   3.507752635308442*^9, 3.5077526707584915`*^9}, {3.5086277563635235`*^9, 
   3.5086278002464*^9}, 3.5086278352060614`*^9, {3.50865434859033*^9, 
   3.508654351190334*^9}, {3.5098474358488584`*^9, 3.509847437898861*^9}, {
   3.515167997344202*^9, 3.5151679997742057`*^9}, 3.5159780039826827`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "*", "a", "*", 
     RowBox[{"b", "/", "2"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", "*", "a"}], "-", 
              RowBox[{"3", "*", "b"}]}], ")"}]}], "+", 
           RowBox[{"a", "*", "b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}], "+", 
           RowBox[{"2", "*", 
            RowBox[{"b", "^", "2"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "2"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, {3.507752818138698*^9, 
   3.5077528465987377`*^9}, 3.508627943751052*^9, {3.5086543517303343`*^9, 
   3.5086543537903376`*^9}, {3.5098474385988626`*^9, 3.509847440528865*^9}, {
   3.515978038895544*^9, 3.515978040049946*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["p",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"e", "+", 
         RowBox[{"f", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.50760587859968*^9, {3.507750812687885*^9, 3.5077508149578876`*^9}, {
   3.5077528823187876`*^9, 3.5077528843487906`*^9}, {3.5083803549005094`*^9, 
   3.5083803584105144`*^9}, {3.508434313094045*^9, 3.508434314394047*^9}, {
   3.508435032365052*^9, 3.508435038735061*^9}, {3.5084379627691545`*^9, 
   3.5084379630291553`*^9}, {3.5086544557504797`*^9, 3.508654457190482*^9}, {
   3.509847441278866*^9, 3.509847441538866*^9}, {3.513094236711338*^9, 
   3.513094236929738*^9}, 3.5130955779086866`*^9, 3.5130959751992426`*^9, 
   3.5131000539749527`*^9, 3.5145989374977565`*^9, 3.514861814895892*^9, {
   3.5151810193734355`*^9, 3.515181020449837*^9}, 3.5151815883100348`*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule p1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, 3.5076127417565*^9, 
   3.507750824167901*^9, 3.5077528900087986`*^9, 3.50838036953053*^9, 
   3.508434321304057*^9, 3.5086305544892397`*^9, 3.508630953600341*^9, 
   3.5117219857559867`*^9, {3.5133775774429827`*^9, 3.5133775777729836`*^9}, {
   3.5145992062681327`*^9, 3.5145992113181396`*^9}, {3.5148619701761093`*^9, 
   3.51486197051611*^9}, {3.51518159124284*^9, 3.5151815914924407`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox["1", "b"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]], " "}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.508629985389839*^9, 
   3.508630038523533*^9}, {3.5086302175650473`*^9, 3.508630272523944*^9}, {
   3.5086303373732576`*^9, 3.5086303857489424`*^9}, {3.5086544815205164`*^9, 
   3.5086544839805193`*^9}, {3.5098474421388674`*^9, 
   3.5098474438788695`*^9}, {3.5117218573958073`*^9, 3.5117219059258747`*^9}, 
   3.511721969165963*^9, {3.5117220230860386`*^9, 3.5117220366960583`*^9}, {
   3.5151680053542137`*^9, 3.5151680075942163`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "b"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", "b"}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, 3.508630104043648*^9, {
   3.508630460519874*^9, 3.508630490908727*^9}, {3.5086544845305204`*^9, 
   3.5086544866805234`*^9}, {3.509847444628871*^9, 3.509847447028874*^9}, 
   3.511719105891955*^9, {3.511720046553272*^9, 3.511720055293284*^9}, {
   3.5117204168737903`*^9, 3.511720418213792*^9}, 3.5117220489860754`*^9, {
   3.511722175866253*^9, 3.5117222217363167`*^9}, {3.51172245952665*^9, 
   3.5117224600266504`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell[TextData[{
 "Rule p2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, 3.5076127417565*^9, 
   3.507750824167901*^9, 3.5077528900087986`*^9, 3.50838036953053*^9, 
   3.508434321304057*^9, 3.5086305544892397`*^9, 3.508630953600341*^9, 
   3.51172198842599*^9, {3.5133775804029865`*^9, 3.5133775811229877`*^9}, {
   3.5145992142681437`*^9, 3.5145992145981445`*^9}, {3.514861974126115*^9, 
   3.514861974426115*^9}, {3.5151815937388444`*^9, 3.515181593972845*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      SuperscriptBox["b", "2"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      RowBox[{"b", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "a"}], "-", "b"}], ")"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], ")"}], 
       RowBox[{"3", "/", "2"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.508629985389839*^9, 
   3.508630038523533*^9}, {3.5086302175650473`*^9, 3.508630272523944*^9}, {
   3.5086303373732576`*^9, 3.5086303857489424`*^9}, {3.5086544815205164`*^9, 
   3.5086544839805193`*^9}, {3.5098474421388674`*^9, 
   3.5098474438788695`*^9}, {3.5117222656363783`*^9, 
   3.5117223500564966`*^9}, {3.5151680121142225`*^9, 3.5151680139842253`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
   "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"b", "^", "2"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "+", 
         RowBox[{"b", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "*", "a"}], "-", "b"}], ")"}], "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, 3.508630104043648*^9, {
   3.508630460519874*^9, 3.508630490908727*^9}, {3.5086544845305204`*^9, 
   3.5086544866805234`*^9}, {3.509847444628871*^9, 3.509847447028874*^9}, 
   3.511719105891955*^9, {3.511720046553272*^9, 3.511720055293284*^9}, {
   3.5117204168737903`*^9, 3.511720418213792*^9}, {3.511722415106588*^9, 
   3.5117224284766064`*^9}, {3.5117224905666933`*^9, 3.511722494646699*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}}],

Cell["\<\
Note: This rule unifies rules p1 and p2, but requires messy application \
conditions.\
\>", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.503710341632182*^9, 3.503710345182187*^9}, {
   3.511722659036929*^9, 3.511722738757041*^9}, {3.5151816004312563`*^9, 
   3.5151816078412695`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["e", "2"], "-", 
     SuperscriptBox["f", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"b", " ", "e"}], "-", 
     RowBox[{"a", " ", "f"}]}], "\[NotEqual]", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, {3.508373429422679*^9, 
   3.5083734393442965`*^9}, 3.508375375313538*^9, 3.5083798476097994`*^9, 
   3.508434297064023*^9, {3.508463496340228*^9, 3.5084635020810385`*^9}, 
   3.5084671393946285`*^9, 3.511723015157428*^9, 3.5117235634781957`*^9, 
   3.513377584272992*^9, 3.5145992174181485`*^9, 3.5148619781761208`*^9, 
   3.515181597529651*^9, {3.5151946024345484`*^9, 3.515194602644549*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"e", "+", 
        RowBox[{"f", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       SuperscriptBox["b", "2"], "f"]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
        SqrtBox[
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " "}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "f"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "f"}], "-", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", "e"}], "+", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "a", " ", "f"}], "-", 
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{"e", "+", "f"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]], " "}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, {3.508629985389839*^9, 
   3.508630038523533*^9}, {3.5086302175650473`*^9, 3.508630272523944*^9}, {
   3.5086303373732576`*^9, 3.5086303857489424`*^9}, {3.5086544815205164`*^9, 
   3.5086544839805193`*^9}, {3.5098474421388674`*^9, 
   3.5098474438788695`*^9}, {3.5151680180442314`*^9, 3.5151680200042343`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"e_.", "+", 
         RowBox[{"f_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}]}], ",", "x_Symbol"}], "]"}], " ", ":=",
    "\n", "  ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"b", "^", "2"}], "/", "f"}], "*", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"e", "+", 
             RowBox[{"f", "*", 
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
        "x"}], "]"}]}], " ", "+", " ", "\n", "  ", 
     RowBox[{"Dist", "[", 
      RowBox[{
       RowBox[{"1", "/", "f"}], ",", "\n", "    ", 
       RowBox[{"Int", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"a", "^", "2"}], "*", "f"}], "-", 
            RowBox[{
             RowBox[{"b", "^", "2"}], "*", "e"}], "+", 
            RowBox[{"b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "a", "*", "f"}], "-", 
               RowBox[{"b", "*", 
                RowBox[{"(", 
                 RowBox[{"e", "+", "f"}], ")"}]}]}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"e", "+", 
               RowBox[{"f", "*", 
                RowBox[{"sin", "[", 
                 RowBox[{"c", "+", 
                  RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], 
        "]"}]}], "]"}]}], " ", "/;", "\n", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
        "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"a", "^", "2"}], "-", 
       RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"e", "^", "2"}], "-", 
       RowBox[{"f", "^", "2"}]}], "]"}], " ", "&&", " ", 
     RowBox[{"NonzeroQ", "[", 
      RowBox[{
       RowBox[{"b", "*", "e"}], "-", 
       RowBox[{"a", "*", "f"}]}], "]"}]}]}]}], " ", "*)"}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, 3.508630104043648*^9, {
   3.508630460519874*^9, 3.508630490908727*^9}, {3.5086544845305204`*^9, 
   3.5086544866805234`*^9}, {3.509847444628871*^9, 3.509847447028874*^9}, 
   3.511719105891955*^9, {3.511720046553272*^9, 3.511720055293284*^9}, {
   3.5117204168737903`*^9, 3.511720418213792*^9}, {3.511721918135892*^9, 
   3.511721949055935*^9}, {3.5117224479466333`*^9, 3.5117224485866346`*^9}, 
   3.511722882497242*^9, {3.515978079984816*^9, 3.5159780815136185`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["q",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox["1", 
      RowBox[{
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"e", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, 3.5036872067511406`*^9, {3.5037059534940376`*^9, 
   3.5037059655740547`*^9}, {3.5037075665562963`*^9, 
   3.5037075740363064`*^9}, {3.5037689892578745`*^9, 3.5037689894778748`*^9}, 
   3.5044136451914988`*^9, 3.50441429638241*^9, {3.5044703271693764`*^9, 
   3.504470336329389*^9}, {3.507605026068486*^9, 3.507605039298505*^9}, 
   3.5076058897996955`*^9, 3.507612730976883*^9, {3.5076833980984545`*^9, 
   3.5076834144316835`*^9}, {3.5076841143581123`*^9, 3.507684129458939*^9}, 
   3.5077429780811357`*^9, {3.5077509482580748`*^9, 3.507750951268079*^9}, {
   3.507752914548833*^9, 3.5077529156288347`*^9}, {3.5083803730605345`*^9, 
   3.5083803752405376`*^9}, {3.5084343251540623`*^9, 3.508434327354065*^9}, {
   3.5084350718951073`*^9, 3.508435076975115*^9}, {3.5084381218093777`*^9, 
   3.5084381221693783`*^9}, {3.508654552330615*^9, 3.508654553710617*^9}, {
   3.509847448048876*^9, 3.509847448288876*^9}, {3.5130942388017416`*^9, 
   3.513094239051342*^9}, 3.5130955814086914`*^9, 3.5130959774092455`*^9, 
   3.5131000569849567`*^9, 3.5145989407877607`*^9, 3.514861817065895*^9, {
   3.515181023694643*^9, 3.5151810252390456`*^9}, 3.515181619166889*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell[TextData[{
 "Rule q1: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, 3.5076127417565*^9, 
   3.5076841182425194`*^9, 3.507742980218339*^9, 3.507750956038086*^9, 
   3.507752918178838*^9, 3.5083803785805426`*^9, {3.5084343299240685`*^9, 
   3.5084343323140717`*^9}, {3.508631062706932*^9, 3.508631063018933*^9}, {
   3.5133775950030074`*^9, 3.513377595303008*^9}, {3.51459922592816*^9, 
   3.5145992262081604`*^9}, {3.514861987696134*^9, 3.514861988516135*^9}, {
   3.5151816220372944`*^9, 3.5151816227236958`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
       RowBox[{"3", "/", "2"}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["1", 
       RowBox[{"a", "-", "b"}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["b", 
    RowBox[{"a", "-", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
        RowBox[{"3", "/", "2"}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, 3.507683421904096*^9, {
   3.507683488251013*^9, 3.507683515909861*^9}, {3.5076841310033417`*^9, 
   3.507684165526202*^9}, {3.508631372398676*^9, 3.5086314214919624`*^9}, {
   3.508654584850661*^9, 3.5086545867206635`*^9}, {3.509847449598878*^9, 
   3.5098474513488803`*^9}, {3.5151680286942463`*^9, 3.5151680313342495`*^9}, 
   3.5159779325369577`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a_", "+", 
          RowBox[{"b_.", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c_.", "+", 
             RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"b", "/", 
       RowBox[{"(", 
        RowBox[{"a", "-", "b"}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sqrt", "[", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"b", "*", 
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
            RowBox[{"(", 
             RowBox[{"3", "/", "2"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}]}],
      "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, {3.507683544816712*^9, 
   3.507683560120339*^9}, 3.5076836324732656`*^9, {3.5076842021394663`*^9, 
   3.5076842197206974`*^9}, 3.50768428949962*^9, 3.5086315030957055`*^9, {
   3.5086545871506643`*^9, 3.508654588390666*^9}, {3.5098474519288807`*^9, 
   3.5098474536288834`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017234466769753`*^9, {3.503797992634972*^9, 3.5037979962649775`*^9}}],

Cell[TextData[{
 "Rule q2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.5038123846231127`*^9, {
   3.5043909587088013`*^9, 3.5043909839988365`*^9}, 3.504414321782446*^9, 
   3.507605300798871*^9, 3.5076058995497093`*^9, 3.5076127417565*^9, 
   3.507684122532527*^9, 3.507742990280357*^9, 3.5077509590780897`*^9, 
   3.5077529201288404`*^9, 3.5083803820005474`*^9, 3.508434335004076*^9, {
   3.5086310673401403`*^9, 3.5086310675897408`*^9}, {3.5133775979830112`*^9, 
   3.5133775990030127`*^9}, {3.514599228538164*^9, 3.514599228828164*^9}, {
   3.5148619906661377`*^9, 3.5148619915461392`*^9}, {3.5151816255629005`*^9, 
   3.5151816262805014`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"\[Integral]", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          SqrtBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
          SqrtBox[
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
        RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}], "+", 
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"3", "/", "2"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038115594908633`*^9, 3.5038115707384834`*^9}, {3.5038116014081373`*^9, 
   3.503811604247342*^9}, 3.5038121379710793`*^9, {3.5038121707311373`*^9, 
   3.5038121732583413`*^9}, {3.503813250383834*^9, 3.503813250586634*^9}, {
   3.503813292113907*^9, 3.5038132968875155`*^9}, {3.503817651090766*^9, 
   3.503817701478854*^9}, 3.503817967662122*^9, 3.50381819992533*^9, 
   3.507605041808508*^9, {3.507605080328562*^9, 3.5076050911785774`*^9}, {
   3.5076051336786366`*^9, 3.5076051419486485`*^9}, 3.507683421904096*^9, {
   3.507683488251013*^9, 3.507683515909861*^9}, {3.5086316371779413`*^9, 
   3.5086316614047837`*^9}, {3.508654589030667*^9, 3.508654590610669*^9}, {
   3.5098474548888855`*^9, 3.5098474565488873`*^9}, {3.5151680363542566`*^9, 
   3.515168039414261*^9}, 3.5159779362653637`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"3", "/", "2"}], ")"}]}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}], " ", "+", " ", "\n", "  ", 
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"3", "/", "2"}], ")"}]}], "*", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
      "x"}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812278246526*^9, 3.5038124044099483`*^9, {3.5038125162465444`*^9, 
   3.5038125297093678`*^9}, {3.5038132541122403`*^9, 3.503813257700247*^9}, {
   3.5038133059823313`*^9, 3.5038133098043385`*^9}, {3.5038177237400937`*^9, 
   3.503817787216605*^9}, 3.5038182520918217`*^9, {3.5049966551220837`*^9, 
   3.5049966590920897`*^9}, {3.504997194212839*^9, 3.504997199462846*^9}, 
   3.507605211588746*^9, {3.507605269748827*^9, 3.507605288128853*^9}, {
   3.507612961088045*^9, 3.5076129665543575`*^9}, {3.507683544816712*^9, 
   3.507683560120339*^9}, 3.5076836324732656`*^9, 3.5086317192700863`*^9, {
   3.5086545910806694`*^9, 3.508654592710672*^9}, {3.509847457078888*^9, 
   3.509847459198891*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.5037922680230246`*^9, 3.503792271043029*^9}, {3.5044702486492662`*^9, 
   3.50447025124927*^9}, {3.507745351240239*^9, 3.5077453594002504`*^9}, 
   3.507748834685116*^9, {3.5083499432878857`*^9, 3.5083499439378867`*^9}, {
   3.5084365503371773`*^9, 3.5084365557371845`*^9}, {3.509847311918685*^9, 
   3.509847312928686*^9}, {3.5130942254949183`*^9, 3.5130942256977186`*^9}, 
   3.5130955621186643`*^9, {3.5130959403491936`*^9, 3.5130959449192*^9}, 
   3.5145987848375425`*^9, {3.515181027079849*^9, 3.515181029841054*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"b", "-", "a"}], ">", "0"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "z"}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], 
      RowBox[{"1", "+", "z"}]]]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.503683954247945*^9, 3.5036839576799507`*^9}, {
   3.503684195673969*^9, 3.503684222053615*^9}, {3.5037654523770514`*^9, 
   3.503765456977058*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["a", "2"]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.503605565226612*^9, 
   3.503605598986659*^9}, 3.5036070990887594`*^9, {3.5036095247521553`*^9, 
   3.50360952795216*^9}, {3.5083501743782096`*^9, 3.5083501768682127`*^9}, {
   3.508436560857192*^9, 3.508436561227193*^9}, {3.5133773788327045`*^9, 
   3.5133773793327055`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", "b"}]], 
      RowBox[{"d", " ", "A"}]]}]}], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, {
   3.5037665202274017`*^9, 3.5037665301178193`*^9}, {3.503784584829901*^9, 
   3.5037845937599134`*^9}, 3.503792874433873*^9, 3.503792912183926*^9, {
   3.5037929644139996`*^9, 3.5037929747840137`*^9}, {3.5037931121242065`*^9, 
   3.503793113894209*^9}, 3.505344639843782*^9, {3.5053446888238506`*^9, 
   3.5053447134838853`*^9}, {3.505351453072264*^9, 3.5053514567722692`*^9}, {
   3.509847314028688*^9, 3.50984731544869*^9}, 3.5098991508997393`*^9, 
   3.5151265707572784`*^9, {3.51516804585427*^9, 3.515168046474271*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"A_", "+", 
         RowBox[{"B_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", "b"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "A"}], ")"}]}], "*", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "b", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, 3.503770483271969*^9, {3.5037705316120367`*^9, 
   3.503770532712038*^9}, {3.5037848128502207`*^9, 3.5037848148402233`*^9}, 
   3.5037933043644753`*^9, 3.5037933665145626`*^9, 3.5053446398537817`*^9, {
   3.5053446888438506`*^9, 3.505344713493885*^9}, {3.5053514864823112`*^9, 
   3.505351504832337*^9}, {3.5054094575245156`*^9, 3.505409461574521*^9}, 
   3.505410653966191*^9, {3.5098473170486917`*^9, 3.509847317798693*^9}, 
   3.509899257909889*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis:  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"f", "[", "z", "]"}]}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"f", "[", "z", "]"}]}], ")"}]}]]]}], ")"}]}], "=", "0"}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, 3.5036876317117357`*^9, {3.503777261976656*^9, 
   3.503777261976656*^9}, {3.50377732690397*^9, 3.503777330211176*^9}, {
   3.503792782953745*^9, 3.503792795793763*^9}, {3.5083502558283234`*^9, 
   3.5083502558283234`*^9}, {3.5083546402244616`*^9, 3.5083546402244616`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.503687809691985*^9, 
   3.5036878202819996`*^9}, {3.5036910540785284`*^9, 3.503691064608543*^9}, {
   3.5036914578790936`*^9, 3.5036914589290953`*^9}, {3.50377059129212*^9, 
   3.50377059129212*^9}, {3.5037747966780715`*^9, 3.5037747966780715`*^9}, {
   3.503777187954526*^9, 3.503777187954526*^9}, {3.5083501813682194`*^9, 
   3.5083501822082205`*^9}, {3.5084365649371977`*^9, 
   3.5084365658171988`*^9}, {3.5133773824727097`*^9, 3.5133773828927107`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"A", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], "  ", 
    "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], 
      SqrtBox[
       RowBox[{"1", "+", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]}], 
     RowBox[{"d", " ", "A", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]]], 
   RowBox[{"EllipticE", "[", 
    RowBox[{
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, {3.502074068873864*^9, 3.502074103287524*^9}, {
   3.502074222097333*^9, 3.502074222580934*^9}, {3.502074331141525*^9, 
   3.5020743532623634`*^9}, {3.5036875972516875`*^9, 
   3.5036876078817024`*^9}, {3.503776844254722*^9, 3.5037768678107634`*^9}, 
   3.5037769050792294`*^9, 3.5037769395396895`*^9, {3.503776970271744*^9, 
   3.5037770037806025`*^9}, {3.503777077709132*^9, 3.5037771161787996`*^9}, {
   3.5037824089768553`*^9, 3.5037824099068565`*^9}, 3.5037848962003374`*^9, {
   3.503784947540409*^9, 3.5037849592604256`*^9}, 3.5037923702931676`*^9, 
   3.5037924225732408`*^9, 3.5037924557532873`*^9, {3.5037925660534415`*^9, 
   3.503792570063447*^9}, 3.503792641943548*^9, 3.505344639863782*^9, {
   3.5053446889038506`*^9, 3.5053447135038853`*^9}, 3.505351487942313*^9, 
   3.505351535302379*^9, 3.5073154238413706`*^9, {3.509847319688696*^9, 
   3.509847320578697*^9}, 3.509899163049756*^9, 3.5151265815368977`*^9, {
   3.5151680532742805`*^9, 3.5151680538742814`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}, {
   3.503792702043632*^9, 3.5037927065536385`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"A_", "+", 
         RowBox[{"B_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", "A", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], "]"}], "*", 
    "\n", "  ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, {
   3.5020741121795397`*^9, 3.5020741279043674`*^9}, {3.502074235014156*^9, 
   3.5020742444521723`*^9}, {3.5020743100034876`*^9, 3.502074313622694*^9}, {
   3.502074430045698*^9, 3.5020744584377484`*^9}, 3.5020748031939535`*^9, {
   3.5036876601817756`*^9, 3.503687665111782*^9}, {3.5036877336618786`*^9, 
   3.5036877357018814`*^9}, {3.503687824822006*^9, 3.5036878312620153`*^9}, {
   3.5036915244191866`*^9, 3.5036915313691964`*^9}, {3.503768459687133*^9, 
   3.5037684669371433`*^9}, 3.503770433351899*^9, {3.503772360984661*^9, 
   3.5037723695846734`*^9}, 3.5037749445282784`*^9, 3.503777192634534*^9, {
   3.5037775786832128`*^9, 3.5037775818344183`*^9}, 3.5037776183228827`*^9, {
   3.503785053580558*^9, 3.503785058650565*^9}, {3.503785253870838*^9, 
   3.5037852560208406`*^9}, {3.5037853122209196`*^9, 
   3.5037853278509417`*^9}, {3.503792717213653*^9, 3.5037927205436583`*^9}, {
   3.503793268374425*^9, 3.5037932795244403`*^9}, 3.505344639883782*^9, {
   3.505344688933851*^9, 3.5053447135238853`*^9}, 3.5053514898423157`*^9, 
   3.5053515501024*^9, {3.5054094680045304`*^9, 3.5054094791945457`*^9}, 
   3.5054106550561924`*^9, 3.5073154725914383`*^9, {3.5098473243087025`*^9, 
   3.509847325408704*^9}, 3.5098992664899015`*^9, {3.5151680541542816`*^9, 
   3.5151680603742905`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}]], 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
     RowBox[{"(", 
      RowBox[{"A", "+", 
       RowBox[{"A", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.5037922680230246`*^9, 3.503792271043029*^9}, {3.5044702486492662`*^9, 
   3.50447025124927*^9}, {3.507745351240239*^9, 3.5077453594002504`*^9}, 
   3.507748834685116*^9, {3.5083499432878857`*^9, 3.5083499439378867`*^9}, {
   3.5084365503371773`*^9, 3.5084365557371845`*^9}, {3.509847311918685*^9, 
   3.509847312928686*^9}, {3.5130942254949183`*^9, 3.5130942256977186`*^9}, 
   3.5130955621186643`*^9, {3.5130959403491936`*^9, 3.5130959449192*^9}, 
   3.5145988255675993`*^9, {3.5151810314946566`*^9, 3.515181034567862*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Basis:  ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    SqrtBox["z"], 
    RowBox[{
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]], 
     RowBox[{"(", 
      RowBox[{"1", "+", "z"}], ")"}]}]], "=", 
   RowBox[{
    FractionBox["a", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      SqrtBox["z"], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}]]}]], "-", 
    FractionBox[
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}]], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      SqrtBox["z"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "z"}], ")"}]}]]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, 3.5036876317117357`*^9, {3.503777261976656*^9, 
   3.503777261976656*^9}, {3.50377732690397*^9, 3.503777330211176*^9}, {
   3.503792782953745*^9, 3.503792795793763*^9}, {3.5073147305104*^9, 
   3.507314753590432*^9}, {3.508354097003701*^9, 3.508354097003701*^9}, 
   3.5083882743859673`*^9}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.503687809691985*^9, 
   3.5036878202819996`*^9}, {3.5036910540785284`*^9, 3.503691064608543*^9}, {
   3.5036914578790936`*^9, 3.5036914589290953`*^9}, {3.50377059129212*^9, 
   3.50377059129212*^9}, {3.5037747966780715`*^9, 3.5037747966780715`*^9}, {
   3.503777187954526*^9, 3.503777187954526*^9}, {3.5077488424351263`*^9, 
   3.5077488432051277`*^9}, {3.508371510420107*^9, 3.508371511387309*^9}, {
   3.508372634392482*^9, 3.508372665810937*^9}, 3.508387767004675*^9, {
   3.5084342353439364`*^9, 3.508434235593937*^9}, {3.513377386932716*^9, 
   3.5133773873427167`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"A", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox["a", 
       RowBox[{"A", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}]]}]}], 
    RowBox[{"\[Integral]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        SqrtBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
        SqrtBox[
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", "-", "b"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"A", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, {
   3.5037665202274017`*^9, 3.5037665301178193`*^9}, {3.503784584829901*^9, 
   3.5037845937599134`*^9}, 3.503792874433873*^9, 3.503792912183926*^9, {
   3.5037929644139996`*^9, 3.5037929747840137`*^9}, {3.5037931121242065`*^9, 
   3.503793113894209*^9}, {3.508371532525346*^9, 3.508371535395751*^9}, 
   3.5083724352425323`*^9, {3.508387207384492*^9, 3.5083872419697523`*^9}, {
   3.508387273341408*^9, 3.508387297958251*^9}, {3.5083883746317434`*^9, 
   3.5083883839449596`*^9}, {3.5084366732473497`*^9, 3.508436675117352*^9}, {
   3.5098473308987117`*^9, 3.5098473379687214`*^9}, {3.515168072474307*^9, 
   3.5151680753643117`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_.", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{"A_", "+", 
         RowBox[{"B_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "/", 
      RowBox[{"(", 
       RowBox[{"A", "*", 
        RowBox[{"(", 
         RowBox[{"a", "-", "b"}], ")"}]}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
       "x"}], "]"}]}], " ", "-", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}]}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Sqrt", "[", 
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
          RowBox[{"(", 
           RowBox[{"A", "+", 
            RowBox[{"B", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ")"}]}], ",", 
       "x"}], "]"}]}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, 3.503770483271969*^9, {3.5037705316120367`*^9, 
   3.503770532712038*^9}, {3.5037848128502207`*^9, 3.5037848148402233`*^9}, 
   3.5037933043644753`*^9, 3.5037933665145626`*^9, {3.505409020953904*^9, 
   3.505409026163912*^9}, 3.5054105939761066`*^9, 3.508372762624707*^9, 
   3.5083845812933245`*^9, 3.5083874261128764`*^9, {3.5083875565291057`*^9, 
   3.5083875612559137`*^9}, {3.5083877888603134`*^9, 3.5083877965043273`*^9}, 
   3.5083879224433484`*^9, {3.508387967324627*^9, 3.5083879846094575`*^9}, 
   3.5083883263808584`*^9, {3.508388399654187*^9, 3.5083884327574453`*^9}, {
   3.5084366760673532`*^9, 3.5084366786773567`*^9}, {3.509847339118723*^9, 
   3.5098473444287305`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"A", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, 3.502073707619229*^9, 
   3.5020844551736393`*^9, {3.502127401535058*^9, 3.5021274043650618`*^9}, 
   3.5036868598806553`*^9, {3.5037059751240683`*^9, 3.5037059767540703`*^9}, 
   3.503764986446399*^9, {3.50376587582489*^9, 3.5037658846549025`*^9}, 
   3.503766010755079*^9, {3.503766073635167*^9, 3.503766076345171*^9}, {
   3.504470000568919*^9, 3.5044700107489333`*^9}, {3.5077454775204153`*^9, 
   3.5077454853504267`*^9}, 3.507748248364295*^9, 3.5077488845651855`*^9, {
   3.5083499579479065`*^9, 3.508349958477907*^9}, {3.5084368535076017`*^9, 
   3.508436861497613*^9}, 3.508437023107839*^9, {3.509847353328743*^9, 
   3.5098473543587446`*^9}, {3.5130942266025205`*^9, 3.513094226820921*^9}, 
   3.5130955644486675`*^9, {3.513095949209206*^9, 3.5130959515792093`*^9}, 
   3.514598878187673*^9, {3.5151810370014668`*^9, 3.5151810399654713`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.5036082854604206`*^9, 3.5036082854604206`*^9}, {
   3.503608421530611*^9, 3.503608430050623*^9}, {3.503608576660828*^9, 
   3.5036085908308477`*^9}, {3.503684296481346*^9, 3.503684306324963*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"b", "-", "a"}], ">", "0"}]}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "+", "z"}]], " ", 
    SqrtBox[
     FractionBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", "z"}]}], 
      RowBox[{"1", "+", "z"}]]]}]}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, {3.503683954247945*^9, 3.5036839576799507`*^9}, {
   3.503684195673969*^9, 3.503684222053615*^9}, {3.5037654523770514`*^9, 
   3.503765456977058*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"b", ">", "0"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     SuperscriptBox["a", "2"]}], ">", "0"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, 
   3.4976397903561964`*^9, {3.4976402447225943`*^9, 3.497640274612247*^9}, {
   3.4982408987437143`*^9, 3.4982408987437143`*^9}, {3.503605565226612*^9, 
   3.503605598986659*^9}, 3.5036070990887594`*^9, {3.5036095247521553`*^9, 
   3.50360952795216*^9}, {3.508350497038661*^9, 3.5083504986486635`*^9}, {
   3.5084370261378436`*^9, 3.508437026377844*^9}, {3.5133774050927415`*^9, 
   3.5133774055227423`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"A", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
    RowBox[{
     SqrtBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{"4", "A"}], 
      RowBox[{"d", 
       SqrtBox[
        RowBox[{"a", "+", "b"}]]}]]}]}], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.497640159702445*^9, 3.4976401723852673`*^9}, 
   3.497921629815009*^9, 3.4979233569096427`*^9, 3.500664339792617*^9, 
   3.500665314513982*^9, {3.5036053897063665`*^9, 3.5036054156964025`*^9}, {
   3.503606914958502*^9, 3.503606928418521*^9}, {3.503609780242513*^9, 
   3.5036097974425373`*^9}, {3.503610197873098*^9, 3.5036102097631145`*^9}, {
   3.5036839785995874`*^9, 3.5036840357268877`*^9}, {3.5036842638460884`*^9, 
   3.5036842678708954`*^9}, 3.5037651801466703`*^9, 3.503765279376809*^9, 
   3.503765316726862*^9, {3.5037658800248957`*^9, 3.503765895744918*^9}, {
   3.5037665202274017`*^9, 3.5037665301178193`*^9}, {3.503784584829901*^9, 
   3.5037845937599134`*^9}, 3.5053446396337814`*^9, {3.5053446880138493`*^9, 
   3.505344713273885*^9}, {3.5053470180971117`*^9, 3.5053470425771456`*^9}, {
   3.5098473556587462`*^9, 3.509847356428747*^9}, 3.5098991773297763`*^9, 
   3.5151265935333185`*^9, {3.5151680803043184`*^9, 3.515168081044319*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"4", "*", 
    RowBox[{"A", "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", "b"}], "]"}]}], ")"}]}], "*", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", "b", "]"}], " ", "&&", " ", 
    RowBox[{"PositiveQ", "[", 
     RowBox[{
      RowBox[{"b", "^", "2"}], "-", 
      RowBox[{"a", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.49764012271478*^9, 
   3.497921629815009*^9, 3.497923316770772*^9, {3.498846097266164*^9, 
   3.498846101431371*^9}, {3.4988483998038116`*^9, 3.498848403345018*^9}, {
   3.503114462071471*^9, 3.5031144646298757`*^9}, {3.503605637856714*^9, 
   3.5036056404067173`*^9}, {3.5036056742667646`*^9, 
   3.5036056882767844`*^9}, {3.503607614209481*^9, 3.503607619389488*^9}, 
   3.5036094305720234`*^9, {3.5036094863621016`*^9, 3.503609489492106*^9}, {
   3.503609866712634*^9, 3.503609867382635*^9}, {3.5036102208231297`*^9, 
   3.5036102468531666`*^9}, 3.5036191376208076`*^9, 3.5037657307246866`*^9, {
   3.5037657942347755`*^9, 3.503765842284843*^9}, {3.503765900684925*^9, 
   3.5037659012749257`*^9}, 3.503770483271969*^9, {3.5037705316120367`*^9, 
   3.503770532712038*^9}, {3.5037848128502207`*^9, 3.5037848148402233`*^9}, 
   3.5053446396437817`*^9, {3.5053446880338497`*^9, 3.5053447132938848`*^9}, 
   3.5053471493472953`*^9, {3.505409348284363*^9, 3.5054093536143703`*^9}, 
   3.5054106461661797`*^9, {3.5098473581987495`*^9, 3.509847358878751*^9}, 
   3.509899281359922*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}}],

Cell[TextData[{
 "Basis:  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SqrtBox[
        RowBox[{"1", "+", 
         RowBox[{"f", "[", "z", "]"}]}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}]]], 
      SqrtBox[
       FractionBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"f", "[", "z", "]"}]}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"f", "[", "z", "]"}]}], ")"}]}]]]}], ")"}]}], "=", "0"}]],
  CellChangeTimes->{{3.5020746334656553`*^9, 3.502074677364133*^9}}]
}], "Subsubsection",
 CellChangeTimes->{
  3.4953915070313115`*^9, 3.495733269136196*^9, 3.4958180204322743`*^9, 
   3.4958182231325583`*^9, {3.4986075703883314`*^9, 3.4986075816671515`*^9}, {
   3.5020746243708396`*^9, 3.502074625260041*^9}, {3.5020746842281446`*^9, 
   3.5020747057249823`*^9}, 3.5036876317117357`*^9, {3.503777261976656*^9, 
   3.503777261976656*^9}, {3.50377732690397*^9, 3.503777330211176*^9}, {
   3.5083546472744713`*^9, 3.5083546472744713`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.498773043878818*^9, 3.4987730460988207`*^9}, {
   3.4988813641905975`*^9, 3.4988813641905975`*^9}, {3.499181685919475*^9, 
   3.499181686418676*^9}, {3.4991988186404686`*^9, 3.49919881954527*^9}, {
   3.501179210841673*^9, 3.501179210841673*^9}, {3.501267255160894*^9, 
   3.5012672581208982`*^9}, {3.50180714999329*^9, 3.501807152785694*^9}, {
   3.5018072136414013`*^9, 3.5018072171202073`*^9}, {3.5018143356243105`*^9, 
   3.501814336544712*^9}, {3.501821741404519*^9, 3.501821741404519*^9}, {
   3.501904374065234*^9, 3.5019043749232354`*^9}, {3.5020738106262097`*^9, 
   3.502073826787838*^9}, {3.502074080168284*^9, 3.502074080636285*^9}, {
   3.5020742717990203`*^9, 3.502074305073879*^9}, {3.503687809691985*^9, 
   3.5036878202819996`*^9}, {3.5036910540785284`*^9, 3.503691064608543*^9}, {
   3.5036914578790936`*^9, 3.5036914589290953`*^9}, {3.50377059129212*^9, 
   3.50377059129212*^9}, {3.5037747966780715`*^9, 3.5037747966780715`*^9}, {
   3.503777187954526*^9, 3.503777187954526*^9}, {3.508350535028714*^9, 
   3.508350536198716*^9}, {3.5084370301678495`*^9, 3.5084370304378495`*^9}, {
   3.5133774086027465`*^9, 3.5133774089927473`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"A", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]], " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], "  ", 
    "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
    FractionBox[
     RowBox[{"4", "A", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]]}], 
     RowBox[{"d", " ", 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}], 
   SqrtBox[
    FractionBox[
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], ")"}]}]]], 
   RowBox[{"EllipticPi", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"ArcSin", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "2"], "-", 
        FractionBox["\[Pi]", "4"]}], "]"}], "]"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"a", "-", "b"}], 
       RowBox[{"a", "+", "b"}]]}]}], "]"}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.4976649758582273`*^9, 3.4976649836738405`*^9}, {3.4987611710421963`*^9, 
   3.498761171052196*^9}, {3.498763360125261*^9, 3.498763442975377*^9}, {
   3.4987641282763357`*^9, 3.4987641478963633`*^9}, {3.49876418102641*^9, 
   3.4987641855164165`*^9}, {3.4987643207166057`*^9, 
   3.4987643238566103`*^9}, {3.4987646394170513`*^9, 
   3.4987646400870523`*^9}, {3.4988373438843184`*^9, 
   3.4988373855519915`*^9}, {3.498837880904462*^9, 3.4988379063637066`*^9}, {
   3.4988381899950047`*^9, 3.498838209276639*^9}, 3.498875524395535*^9, {
   3.499181573474478*^9, 3.4991815792464876`*^9}, 3.499195925538187*^9, {
   3.4991960148327436`*^9, 3.499196047374401*^9}, {3.499196488738776*^9, 
   3.4991965109376154`*^9}, {3.4991970152869015`*^9, 
   3.4991970433669505`*^9}, {3.4991975590298567`*^9, 3.4991975836467*^9}, {
   3.4991979074480686`*^9, 3.499197932158512*^9}, {3.499742519883661*^9, 
   3.4997425472617087`*^9}, {3.5011181143357334`*^9, 3.5011181273149557`*^9}, 
   3.501179197021654*^9, {3.5011792510017295`*^9, 3.501179254971735*^9}, {
   3.5011792888417826`*^9, 3.501179298811796*^9}, {3.501179998042775*^9, 
   3.501180045592842*^9}, 3.501265975269102*^9, {3.501266032579182*^9, 
   3.5012660696292343`*^9}, {3.501807279395517*^9, 3.5018073209227896`*^9}, {
   3.501814357417549*^9, 3.5018144174776545`*^9}, {3.501821754446142*^9, 
   3.5018217794997864`*^9}, {3.501821876204356*^9, 3.501821879620762*^9}, {
   3.501821941724471*^9, 3.5018219589781017`*^9}, {3.5020737562757144`*^9, 
   3.5020738155090184`*^9}, {3.502074068873864*^9, 3.502074103287524*^9}, {
   3.502074222097333*^9, 3.502074222580934*^9}, {3.502074331141525*^9, 
   3.5020743532623634`*^9}, {3.5036875972516875`*^9, 
   3.5036876078817024`*^9}, {3.503776844254722*^9, 3.5037768678107634`*^9}, 
   3.5037769050792294`*^9, 3.5037769395396895`*^9, {3.503776970271744*^9, 
   3.5037770037806025`*^9}, {3.503777077709132*^9, 3.5037771161787996`*^9}, {
   3.5037824089768553`*^9, 3.5037824099068565`*^9}, 3.5037848962003374`*^9, {
   3.503784947540409*^9, 3.5037849592604256`*^9}, 3.505344639653782*^9, {
   3.5053446881038494`*^9, 3.5053447133038845`*^9}, 3.5053473157875285`*^9, {
   3.5098473612387543`*^9, 3.5098473621187553`*^9}, 3.5098991829897842`*^9, 
   3.5151266022225337`*^9, {3.5151680861843266`*^9, 3.515168086644327*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5012670809206495`*^9, 3.5012670907806635`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "]"}], "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a_", "+", 
         RowBox[{"b_.", "*", 
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"4", "*", "A", "*", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"d", "*", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], "*", 
    "\[IndentingNewLine]", "  ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}], ")"}]}], ")"}]}], "]"}], "*", 
    "\n", "  ", 
    RowBox[{"EllipticPi", "[", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"ArcSin", "[", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"c", "-", 
           RowBox[{"Pi", "/", "2"}], "+", 
           RowBox[{"d", "*", "x"}]}], ")"}], "/", "2"}], "]"}], "]"}], ",", 
      RowBox[{"-", 
       RowBox[{"Sim", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "b"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"a", "+", "b"}], ")"}]}], "]"}]}]}], "]"}]}], " ", "/;", 
   "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{"A", "-", "B"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, 3.4976649514441843`*^9, {
   3.498677409837909*^9, 3.498677420717924*^9}, {3.498761171062196*^9, 
   3.498761171072196*^9}, 3.4987644028767204`*^9, {3.4987662955293703`*^9, 
   3.498766296719372*^9}, {3.4987730095187697`*^9, 3.4987730279187956`*^9}, 
   3.4988018969020424`*^9, {3.4988383907497573`*^9, 3.4988383926841607`*^9}, 
   3.4988781416461363`*^9, {3.499181675186656*^9, 3.499181679773064*^9}, 
   3.4991823918679156`*^9, {3.4991882276873684`*^9, 3.499188229356571*^9}, {
   3.49919728726818*^9, 3.4991972888593826`*^9}, {3.4997425667461433`*^9, 
   3.4997425851853757`*^9}, 3.500320390145653*^9, 3.5003482038628163`*^9, {
   3.5011793846419163`*^9, 3.501179392151927*^9}, 3.5011795929422083`*^9, 
   3.5011797763524647`*^9, {3.5011800601028624`*^9, 3.5011800638228674`*^9}, 
   3.5012661176193013`*^9, 3.5012669663704896`*^9, {3.5012671075006866`*^9, 
   3.501267115460698*^9}, 3.501278519870695*^9, {3.5018074432426043`*^9, 
   3.5018074743646593`*^9}, {3.5018143414119205`*^9, 3.501814351099538*^9}, {
   3.501814518472232*^9, 3.501814522715439*^9}, {3.5018220094909906`*^9, 
   3.5018220205046096`*^9}, 3.501822074792705*^9, {3.5018781794437113`*^9, 
   3.501878180493713*^9}, 3.5019102651535845`*^9, 3.5019701782616205`*^9, 
   3.501970419331958*^9, {3.5020738720435176`*^9, 3.502073942243641*^9}, {
   3.5020741121795397`*^9, 3.5020741279043674`*^9}, {3.502074235014156*^9, 
   3.5020742444521723`*^9}, {3.5020743100034876`*^9, 3.502074313622694*^9}, {
   3.502074430045698*^9, 3.5020744584377484`*^9}, 3.5020748031939535`*^9, {
   3.5036876601817756`*^9, 3.503687665111782*^9}, {3.5036877336618786`*^9, 
   3.5036877357018814`*^9}, {3.503687824822006*^9, 3.5036878312620153`*^9}, {
   3.5036915244191866`*^9, 3.5036915313691964`*^9}, {3.503768459687133*^9, 
   3.5037684669371433`*^9}, 3.503770433351899*^9, {3.503772360984661*^9, 
   3.5037723695846734`*^9}, 3.5037749445282784`*^9, 3.503777192634534*^9, {
   3.5037775786832128`*^9, 3.5037775818344183`*^9}, 3.5037776183228827`*^9, {
   3.503785053580558*^9, 3.503785058650565*^9}, {3.503785253870838*^9, 
   3.5037852560208406`*^9}, {3.5037853122209196`*^9, 3.5037853278509417`*^9}, 
   3.5053446396737814`*^9, {3.50534468812385*^9, 3.5053447133138847`*^9}, 
   3.5053473261175427`*^9, 3.505409363654384*^9, 3.5054106474661818`*^9, {
   3.509847364768759*^9, 3.50984736549876*^9}, 3.5098992877899313`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["r",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.5144732893239093`*^9, 
   3.5144732896047096`*^9}, 3.5144733582916307`*^9, 3.5144734005053043`*^9, 
   3.5145693199423046`*^9, {3.514855706677551*^9, 3.5148557128083615`*^9}, {
   3.5151810459138823`*^9, 3.5151810475050855`*^9}, 3.515181652535348*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}, {3.5144736871714077`*^9, 3.5144736908686147`*^9}}],

Cell[TextData[{
 "Rule r1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144735590171833`*^9, 3.514473561965588*^9}, {
   3.5144737101346483`*^9, 3.514473715157857*^9}, {3.514473763190342*^9, 
   3.514473764578744*^9}, {3.514496474085927*^9, 3.514496484855942*^9}, {
   3.5148560276013145`*^9, 3.514856028942917*^9}, {3.515181654360551*^9, 
   3.5151816552341523`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox["1", 
      SuperscriptBox["b", 
       RowBox[{"k", " ", "m"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], 
      RowBox[{
       RowBox[{"k", " ", "m"}], "+", "n"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.5144732957199206`*^9, 
   3.514473295938321*^9}, {3.5144733271383758`*^9, 3.514473389632086*^9}, {
   3.5144734208321404`*^9, 3.514473425184548*^9}, {3.514473474153034*^9, 
   3.514473504229887*^9}, {3.5151680954543395`*^9, 3.5151680980343432`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"k", "*", "m"}], ")"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"k", "*", "m"}], "+", "n"}], ")"}]}], ",", "x"}], "]"}]}], 
    "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d", ",", "n"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.5144735757092123`*^9, 3.5144736765009894`*^9}, {
   3.514473929112233*^9, 3.5144739317798376`*^9}, {3.514474664049924*^9, 
   3.5144746883547664`*^9}, {3.514474786463339*^9, 3.514474821750601*^9}, {
   3.514480701215327*^9, 3.514480722275364*^9}, {3.5144826692469826`*^9, 
   3.5144826753933935`*^9}, {3.514482761427544*^9, 3.514482763127947*^9}, {
   3.5144839879328985`*^9, 3.514484001598522*^9}, {3.5144840432037954`*^9, 
   3.514484047774604*^9}, {3.514484851062791*^9, 3.5144848577428007`*^9}, {
   3.514493953352398*^9, 3.5144939967024584`*^9}, {3.514494454233099*^9, 
   3.5144944881731462`*^9}, 3.5144963454557467`*^9, {3.5145667215746603`*^9, 
   3.5145667230846624`*^9}, {3.5145668019447727`*^9, 
   3.5145668201047983`*^9}, {3.514566854734847*^9, 3.5145668560148487`*^9}, 
   3.516821193357214*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]], 
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, 
   3.5145721515462685`*^9}],

Cell[TextData[{
 "Rule r2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", ">", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.5117295035766306`*^9, 3.511729505106633*^9}, {
   3.511750898236919*^9, 3.5117508991769204`*^9}, {3.5117555222533927`*^9, 
   3.5117555300634036`*^9}, {3.5118334045968*^9, 3.511833408403207*^9}, 
   3.5145720728661585`*^9, {3.514856031797722*^9, 3.5148560328117237`*^9}, {
   3.5151816617393637`*^9, 3.515181662316565*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "-", 
         FractionBox["1", "2"]}]], 
       SqrtBox[
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
       RowBox[{"j", " ", "k"}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.5118158169600077`*^9, 
   3.511815862160071*^9}, 3.511815909280137*^9, {3.5118176520325766`*^9, 
   3.5118176689026003`*^9}, 3.5118179461929884`*^9, {3.511819812927603*^9, 
   3.5118198181376104`*^9}, {3.5118198622576723`*^9, 3.511819864577675*^9}, {
   3.5145719907960434`*^9, 3.51457201659608*^9}, {3.514572326606514*^9, 
   3.514572331676521*^9}, {3.51516810299435*^9, 3.515168104974353*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}], "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "m"}], "+", 
          RowBox[{"k", "*", "n"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", ">", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.5117293456064095`*^9, 3.5117294275865245`*^9}, {3.5117296689768624`*^9, 
   3.5117296728068676`*^9}, {3.5117302889377303`*^9, 3.5117303011477475`*^9}, 
   3.5117466386965055`*^9, {3.511750894036913*^9, 3.511750894676914*^9}, {
   3.5117511267572393`*^9, 3.5117511307372446`*^9}, {3.5117512119573584`*^9, 
   3.511751214027361*^9}, {3.511751883348298*^9, 3.5117518878683043`*^9}, {
   3.5117519413583794`*^9, 3.511751948148389*^9}, {3.5117521986187396`*^9, 
   3.511752203998747*^9}, {3.511755503353366*^9, 3.5117555064233704`*^9}, {
   3.5118335100217853`*^9, 3.5118335340614276`*^9}, 3.5145720383461103`*^9, {
   3.5145721800463085`*^9, 3.5145722335263834`*^9}, {3.5145723389965315`*^9, 
   3.5145723423365355`*^9}, {3.5145724500966864`*^9, 3.514572450266687*^9}, 
   3.516820646406448*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.497575979956957*^9, 3.4980702864359283`*^9, 
   3.4983206021865325`*^9, {3.498326040356801*^9, 3.498326049592017*^9}, {
   3.4983263025932617`*^9, 3.498326308365272*^9}, {3.510260940930415*^9, 
   3.51026094460042*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       SqrtBox[
        SuperscriptBox[
         RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], 
      RowBox[{"j", " ", "k"}]], 
     SqrtBox[
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"f", "[", "z", "]"}], "k"]}]]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, {3.497575979956957*^9, 3.4975760172870092`*^9}, {
   3.4980703053275614`*^9, 3.4980703053275614`*^9}, 3.4980704431694036`*^9, {
   3.498320837060545*^9, 3.4983208718174057`*^9}, 3.4983264799655733`*^9, {
   3.4983265293864603`*^9, 3.4983265518504996`*^9}, {3.510260868510313*^9, 
   3.510260895210351*^9}, {3.5102609859104776`*^9, 3.5102609865504785`*^9}, {
   3.511714714700369*^9, 3.5117147350740047`*^9}, {3.5117152169432507`*^9, 
   3.5117152315916767`*^9}, {3.5117561659742937`*^9, 
   3.5117561659742937`*^9}, {3.5118185923538933`*^9, 
   3.5118186314339476`*^9}, {3.511818664503994*^9, 3.5118186916940317`*^9}, {
   3.5118187344240923`*^9, 3.5118187409841013`*^9}, {3.514569048341924*^9, 
   3.5145690628419447`*^9}, {3.514572319246504*^9, 3.514572319846504*^9}}],

Cell[TextData[{
 "Rule r3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"m", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{
      RowBox[{"n", "-", 
       FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], 
     " ", "\[And]", " ", 
     RowBox[{"n", "<", "0"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511715292228983*^9, 3.511715334692258*^9}, {3.5117155048269134`*^9, 
   3.511715508166918*^9}, {3.511729526906664*^9, 3.5117295274366646`*^9}, {
   3.511748932814161*^9, 3.511748933464162*^9}, {3.5117557724437428`*^9, 
   3.5117557724437428`*^9}, {3.511832614206211*^9, 3.511832614206211*^9}, {
   3.511832746213642*^9, 3.511832746213642*^9}, {3.5144963686357794`*^9, 
   3.514496369905781*^9}, {3.5144964549259*^9, 3.5144964623659105`*^9}, {
   3.514496962866611*^9, 3.5144969631666117`*^9}, {3.5144973205371118`*^9, 
   3.514497323707116*^9}, {3.5144981061082115`*^9, 3.514498107108213*^9}, {
   3.51456888104169*^9, 3.51456888104169*^9}, {3.514572358146558*^9, 
   3.5145723624865637`*^9}, {3.514856035354528*^9, 3.51485603646213*^9}, {
   3.5151816723941827`*^9, 3.515181672752983*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     FractionBox[
      RowBox[{
       SuperscriptBox["b", 
        RowBox[{"n", "+", 
         FractionBox["1", "2"]}]], 
       SuperscriptBox[
        RowBox[{"(", 
         SqrtBox[
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"]], ")"}], 
        RowBox[{"j", " ", "k"}]]}], 
      SqrtBox[
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "+", 
       RowBox[{"k", " ", "n"}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.511714482540761*^9, 3.5117145274688396`*^9}, {
   3.5117145862341433`*^9, 3.5117146153281946`*^9}, {3.5117147853060927`*^9, 
   3.511714803090124*^9}, {3.5117151505963345`*^9, 3.5117151632479568`*^9}, {
   3.511715744517249*^9, 3.511715747287253*^9}, {3.51174841818344*^9, 
   3.511748420833444*^9}, {3.511748497963552*^9, 3.5117484984135523`*^9}, {
   3.511818294033475*^9, 3.5118183236735168`*^9}, {3.5144968024863863`*^9, 
   3.5144968510064545`*^9}, {3.5144968866465044`*^9, 3.514496913836542*^9}, {
   3.514568305910885*^9, 3.5145683164908996`*^9}, {3.5145683572009563`*^9, 
   3.5145683609609623`*^9}, 3.514568478731127*^9, 3.514568528181196*^9, {
   3.5145685692312536`*^9, 3.5145686286113367`*^9}, {3.5145686608513813`*^9, 
   3.5145686672213907`*^9}, {3.5151681094443593`*^9, 3.5151681104843607`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b_", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], ")"}], "^", 
      "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"b", "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}]}], "*", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^", 
        RowBox[{"(", 
         RowBox[{"j", "*", "k"}], ")"}]}], "/", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"b", "*", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}], "]"}]}]}], ",", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "m"}], "+", 
          RowBox[{"k", "*", "n"}]}], ")"}]}], ",", "x"}], "]"}]}], "]"}], " ",
    "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], " ", "&&",
     " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", "0"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.511715355721095*^9, 
   3.5117153607131033`*^9}, {3.511715428066806*^9, 3.5117154599968505`*^9}, {
   3.511715511146922*^9, 3.5117155141269264`*^9}, {3.511715565286998*^9, 
   3.5117155864270277`*^9}, {3.511715750947258*^9, 3.5117157539772625`*^9}, {
   3.511747293362056*^9, 3.5117472971996627`*^9}, {3.5117477460436506`*^9, 
   3.5117477523148623`*^9}, {3.5117479077127256`*^9, 3.511747926872752*^9}, {
   3.5117482704932337`*^9, 3.511748288643259*^9}, {3.511748542813615*^9, 
   3.511748551293627*^9}, {3.511750065125746*^9, 3.5117500670757484`*^9}, {
   3.5117558949839144`*^9, 3.511755900293922*^9}, 3.51183280157814*^9, {
   3.511832873725067*^9, 3.5118328862830887`*^9}, {3.5118329289491634`*^9, 
   3.5118329301035657`*^9}, {3.514496374415787*^9, 3.514496375635789*^9}, {
   3.514496438775877*^9, 3.514496443085883*^9}, {3.514496942236582*^9, 
   3.514496946806588*^9}, {3.514497149116872*^9, 3.5144971791969137`*^9}, 
   3.5144972624770308`*^9, {3.5144973102370973`*^9, 3.5144973301571255`*^9}, {
   3.514497805537791*^9, 3.5144978555678606`*^9}, 3.5144981017882056`*^9, {
   3.5145668229448023`*^9, 3.5145668520048428`*^9}, {3.5145683337309237`*^9, 
   3.514568353430951*^9}, 3.5145688737116795`*^9, {3.514568913051735*^9, 
   3.5145689928618464`*^9}, {3.5145723491465454`*^9, 3.514572351626549*^9}, 
   3.516820655546461*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["s",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.510791314473015*^9, 
   3.5107913192430215`*^9}, {3.510791362583082*^9, 3.510791387393117*^9}, {
   3.510791824065729*^9, 3.5107918281657352`*^9}, 3.5107929120112553`*^9, {
   3.510864363862485*^9, 3.5108643733624983`*^9}, {3.514855708502754*^9, 
   3.5148557151795654`*^9}, {3.515181049205488*^9, 3.5151810610147095`*^9}, 
   3.515181690318614*^9},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992213471847477`*^9, 3.499221352834756*^9}, {
   3.507168628069942*^9, 3.5071686300799446`*^9}}],

Cell[TextData[{
 "Rule s1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "\[LessEqual]", 
     RowBox[{"m", "+", "j"}], "\[LessEqual]", 
     FractionBox["3", "2"]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, {
   3.5107929131512566`*^9, 3.5107929131512566`*^9}, {3.5135750753817444`*^9, 
   3.5135750753817444`*^9}, {3.5136064719623013`*^9, 
   3.5136064719623013`*^9}, {3.5142254245270514`*^9, 
   3.5142254245270514`*^9}, {3.5142607860883093`*^9, 
   3.5142607860883093`*^9}, {3.514856046726948*^9, 3.5148560485209513`*^9}, {
   3.51518169375062*^9, 3.515181693969021*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     RowBox[{"\[Integral]", 
      RowBox[{
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", "j"}]], 
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.510792914041258*^9, 
   3.5107929153912597`*^9}, {3.5151681163243685`*^9, 3.515168117724371*^9}, {
   3.515181105786788*^9, 3.515181109530794*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", "j"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}]}], ",", "x"}], "]"}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], "\[LessEqual]", 
     RowBox[{"m", "+", "j"}], "\[LessEqual]", 
     RowBox[{"3", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.510792916381261*^9, 
   3.5107929192812653`*^9}, {3.5107989134944706`*^9, 
   3.5107989488945203`*^9}, {3.5107990003145924`*^9, 3.510799003754597*^9}, 
   3.5107991079947433`*^9, {3.5107993333670607`*^9, 3.5107993423770733`*^9}, 
   3.5107997531676483`*^9, {3.5108036254530697`*^9, 3.5108036808831472`*^9}, {
   3.5108037152731953`*^9, 3.5108037341632223`*^9}, 3.5118378461156254`*^9, {
   3.5135750652261267`*^9, 3.5135750667549295`*^9}, {3.513606458437078*^9, 
   3.5136064609330826`*^9}, 3.514225464338321*^9, {3.51426080059833*^9, 
   3.5142608103683434`*^9}, 3.516821030626986*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.514253208507701*^9, 3.5142532278877277`*^9}}],

Cell[TextData[{
 "Rule s2: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", "\[And]", " ", 
   RowBox[{
    RowBox[{"n", "-", 
     FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ", 
   "\[And]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{"1", " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"-", "1"}], "<", "n", "<", "2"}]}]}], ")"}], " ", "\[Or]", 
     " ", 
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"-", "1"}], " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "<", "n", "<", "1"}]}]}], ")"}], " ", "\[Or]", 
     " ", 
     RowBox[{"(", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[And]", " ", 
        RowBox[{
         RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}], ")"}]}], ")"}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.505936081778288*^9, 
   3.5059360824123244`*^9}, 3.50596679279029*^9, 3.506195715879625*^9, {
   3.5072434262848907`*^9, 3.507243426534491*^9}, {3.5073303681657257`*^9, 
   3.507330407975782*^9}, {3.5075715513171773`*^9, 3.5075715650271964`*^9}, {
   3.5075716142272654`*^9, 3.507571619647273*^9}, {3.507580938536789*^9, 
   3.50758093920679*^9}, {3.5075833309018*^9, 3.507583346985429*^9}, {
   3.5075993071840444`*^9, 3.507599307904045*^9}, {3.5136238475607247`*^9, 
   3.5136238475607247`*^9}, {3.5142259248823304`*^9, 
   3.5142259248823304`*^9}, {3.5142522403563457`*^9, 3.514252266126382*^9}, {
   3.514252365746521*^9, 3.51425237200653*^9}, 3.5142526257268853`*^9, {
   3.5142568032727337`*^9, 3.514256809002742*^9}, {3.5142573723035307`*^9, 
   3.514257375463535*^9}, {3.5142581660746417`*^9, 3.514258294514821*^9}, {
   3.5148560515473566`*^9, 3.514856052966959*^9}, {3.5151816979002275`*^9, 
   3.5151816988362293`*^9}, {3.5168244207801695`*^9, 3.5168244207801695`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SqrtBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "-", "n"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5142247663462954`*^9, 
   3.5142248021639585`*^9}, 3.514253025067444*^9, {3.5142530595274925`*^9, 
   3.5142531105975637`*^9}, {3.514253635268298*^9, 3.5142536532983236`*^9}, {
   3.5142565959724436`*^9, 3.514256636902501*^9}, {3.5142567220826197`*^9, 
   3.514256727692628*^9}, {3.5142572075632997`*^9, 3.5142572098733025`*^9}, {
   3.514257270673388*^9, 3.514257278013398*^9}, 3.51425872209542*^9, {
   3.5151681230243783`*^9, 3.5151681247643805`*^9}, {3.515181113103201*^9, 
   3.5151811164416065`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"m", "-", "n"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "\[Equal]", "1"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "<", "n", "<", "2"}]}], " ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", 
        RowBox[{"-", "1"}]}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "2"}], "<", "n", "<", "1"}]}], "  ", "||", " ", 
      RowBox[{
       RowBox[{"m", "\[Equal]", 
        RowBox[{"-", "2"}]}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "2"}], "<", "n", "<", "0"}]}]}], ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, {3.51425341509799*^9, 3.51425343628802*^9}, {
   3.5142534667580624`*^9, 3.5142535593981924`*^9}, {3.514253687058371*^9, 
   3.514253702868393*^9}, {3.514256859702813*^9, 3.5142568658528214`*^9}, {
   3.514257895414263*^9, 3.5142579118342857`*^9}, {3.51425795053434*^9, 
   3.514257992824399*^9}, {3.5142580367644606`*^9, 3.5142581340045967`*^9}, {
   3.514259119945977*^9, 3.514259161136035*^9}, 3.5145895813328094`*^9, {
   3.516824431651791*^9, 3.516824446455638*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", "1"}]]],
 ", then  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    FractionBox[
     SqrtBox[
      RowBox[{"b", "+", 
       RowBox[{"a", " ", 
        RowBox[{"f", "[", "z", "]"}]}]}]], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SqrtBox[
         SuperscriptBox[
          RowBox[{"f", "[", "z", "]"}], "j"]], ")"}], "j"], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", "/", 
         RowBox[{"f", "[", "z", "]"}]}]}]]}]]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.508354923854859*^9, 
   3.508354923854859*^9}, {3.508361590872611*^9, 3.5083615983626213`*^9}, {
   3.508361640892681*^9, 3.508361643482684*^9}, 3.5108633469910617`*^9, {
   3.5108842882102137`*^9, 3.510884343449911*^9}, {3.5108843749619665`*^9, 
   3.510884406786022*^9}, {3.5148563582542953`*^9, 3.5148563625755033`*^9}}],

Cell[TextData[{
 "Rule s3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"n", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"j", " ", "m"}], "-", "n"}], "\[LessEqual]", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4975780482324586`*^9, 
   3.4975780519624643`*^9}, {3.4975830331314387`*^9, 3.4975830513314643`*^9}, 
   3.4975830851915116`*^9, {3.4982393791815863`*^9, 3.498239383051592*^9}, {
   3.498240152312669*^9, 3.4982401612626815`*^9}, 3.4987612880523596`*^9, {
   3.498761948883285*^9, 3.498761976013323*^9}, {3.5059675026278906`*^9, 
   3.50596750349494*^9}, 3.5060116665952845`*^9, 3.506016542053919*^9, 
   3.506017498790203*^9, 3.506197187541685*^9, {3.5107904345917826`*^9, 
   3.510790434771783*^9}, {3.51079227461636*^9, 3.51079227461636*^9}, 
   3.510792933471285*^9, {3.5108662797751675`*^9, 3.5108662797751675`*^9}, {
   3.5108678950974293`*^9, 3.5108678976974325`*^9}, {3.510867944407498*^9, 
   3.5108679451674995`*^9}, {3.510868054967653*^9, 3.5108680555976534`*^9}, {
   3.5108681105177307`*^9, 3.5108681231277485`*^9}, 3.5108828042789707`*^9, {
   3.5136220690172005`*^9, 3.5136220690172005`*^9}, {3.514225012031127*^9, 
   3.514225013247929*^9}, {3.5142251131193047`*^9, 3.514225145832562*^9}, {
   3.514253810168543*^9, 3.514253840658586*^9}, {3.514395770421965*^9, 
   3.51439577397197*^9}, {3.5143967942433987`*^9, 3.514396846703472*^9}, {
   3.514396893313537*^9, 3.514396975353652*^9}, {3.514398018354274*^9, 
   3.514398031170007*^9}, {3.5148560565081654`*^9, 3.5148560579589677`*^9}, {
   3.515181703282237*^9, 3.515181704171438*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
     FractionBox[
      RowBox[{" ", 
       SqrtBox[
        RowBox[{"b", "+", 
         RowBox[{"a", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}], 
      RowBox[{
       SuperscriptBox[
        SqrtBox[
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"]], "j"], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{
       RowBox[{"j", " ", "m"}], "-", "n"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"a", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, 3.5108624550198126`*^9, 3.5108626131100345`*^9, {
   3.510862732070201*^9, 3.5108627625502434`*^9}, {3.510862855050373*^9, 
   3.510862862860384*^9}, {3.510863006510585*^9, 3.5108630253906116`*^9}, {
   3.5108654917540646`*^9, 3.510865494574068*^9}, {3.510865542214135*^9, 
   3.510865562964164*^9}, {3.510866059424859*^9, 3.5108660839748936`*^9}, {
   3.5108672905565825`*^9, 3.510867342806656*^9}, {3.510867537366928*^9, 
   3.51086753861693*^9}, {3.5108677323472013`*^9, 3.5108678210373254`*^9}, 
   3.5108827919789534`*^9, {3.5108834101002717`*^9, 3.5108834689123745`*^9}, {
   3.510883571264155*^9, 3.5108835715449553`*^9}, {3.5108836880459595`*^9, 
   3.510883710182399*^9}, {3.510883778604119*^9, 3.5108838678674755`*^9}, {
   3.5108845596722918`*^9, 3.510884601277564*^9}, {3.5142247663462954`*^9, 
   3.5142248021639585`*^9}, {3.514253761668475*^9, 3.514253785538509*^9}, {
   3.514253853498604*^9, 3.514253870598628*^9}, {3.5142539471187353`*^9, 
   3.5142540442288713`*^9}, {3.514256942172928*^9, 3.5142569660829616`*^9}, {
   3.5143958129420247`*^9, 3.514395822802038*^9}, {3.5143963480027733`*^9, 
   3.514396363392795*^9}, 3.514396471892947*^9, {3.5143965757730923`*^9, 
   3.5143965997731256`*^9}, {3.5143966406231833`*^9, 3.514396655623204*^9}, 
   3.5144003680906715`*^9, {3.515168129674388*^9, 3.5151681310343895`*^9}, {
   3.515181125380422*^9, 3.5151811284848275`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"b", "+", 
        RowBox[{"a", "*", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], "]"}], ")"}], "^",
          "j"}], "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "m"}], "-", "n"}], ")"}]}], "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"a", "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}]}], ",", 
       "x"}], "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"n", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "n", "<", "2"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", 
     RowBox[{
      RowBox[{"j", "*", "m"}], "-", "n"}], "\[LessEqual]", 
     "1"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510799189346859*^9, 3.5107992041968803`*^9}, {3.510799776677682*^9, 
   3.510799780597687*^9}, 3.510863075290681*^9, {3.5108631067007256`*^9, 
   3.510863112650734*^9}, 3.5108634203511643`*^9, {3.510863486311257*^9, 
   3.510863486521257*^9}, {3.510865446524001*^9, 3.5108654554340134`*^9}, 
   3.5108661348649645`*^9, {3.5108661791050267`*^9, 3.5108661865550375`*^9}, {
   3.510866302065199*^9, 3.5108663079952073`*^9}, {3.510867921877466*^9, 
   3.510867937547488*^9}, {3.510867973887539*^9, 3.510868046637641*^9}, 
   3.5108680905877028`*^9, {3.510868148657784*^9, 3.510868177777825*^9}, {
   3.510882816248987*^9, 3.510882824228998*^9}, {3.5108840906514673`*^9, 
   3.5108841599155884`*^9}, {3.5108845736187162`*^9, 
   3.5108846146467876`*^9}, {3.510888427388686*^9, 3.5108884743291683`*^9}, {
   3.5108886381918564`*^9, 3.5108886485658746`*^9}, {3.510888678720728*^9, 
   3.5108886796255293`*^9}, {3.510888720684801*^9, 3.5108887275800133`*^9}, {
   3.5108888796802807`*^9, 3.510888881021883*^9}, {3.5120885974018*^9, 
   3.5120886011318054`*^9}, {3.5120894445570097`*^9, 3.512089448317015*^9}, {
   3.513109116247131*^9, 3.513109181236845*^9}, {3.5131109783852024`*^9, 
   3.5131109820668087`*^9}, {3.513111738496537*^9, 3.5131117413357425`*^9}, 
   3.513112310803943*^9, 3.513116549990039*^9, 3.513116631840153*^9, {
   3.513116674560213*^9, 3.5131166806702213`*^9}, {3.513116760960334*^9, 
   3.5131167691403456`*^9}, 3.513122838946004*^9, {3.5131355540184326`*^9, 
   3.513135558760841*^9}, {3.5131356301777663`*^9, 3.513135650832203*^9}, 
   3.5131372241913633`*^9, {3.513139910664424*^9, 3.513139925016449*^9}, {
   3.5131399628933153`*^9, 3.5131399657793207`*^9}, {3.513622089406437*^9, 
   3.5136221199356904`*^9}, 3.5142223995725384`*^9, {3.5142249275881786`*^9, 
   3.5142249458246107`*^9}, 3.514225230603111*^9, {3.5142290392362003`*^9, 
   3.5142290573946323`*^9}, 3.5142538004285297`*^9, {3.5142542521991625`*^9, 
   3.5142542532391634`*^9}, {3.514254291249217*^9, 3.5142544290794096`*^9}, {
   3.5142583832749453`*^9, 3.5142584292150097`*^9}, {3.5143958450020695`*^9, 
   3.5143958674421005`*^9}, {3.5143960423023453`*^9, 3.514396074522391*^9}, {
   3.514396122022457*^9, 3.5143961313624706`*^9}, {3.5143961632325153`*^9, 
   3.5143961760225325`*^9}, {3.5143967449833293`*^9, 3.514396779623378*^9}, {
   3.514396986183667*^9, 3.5143970626537743`*^9}, {3.5143979759968514`*^9, 
   3.5143979981801205`*^9}, 3.5143987761166153`*^9, {3.5143990236597743`*^9, 
   3.514399032938305*^9}, 3.5143990733486166`*^9, 3.51440091844615*^9, 
   3.5144013824526896`*^9, {3.51458952436273*^9, 3.5145895478527627`*^9}, {
   3.5159781843141985`*^9, 3.5159781857806015`*^9}, 3.516821030696986*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["t",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"m", "/", "2"}]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.50267144218347*^9, 
   3.502671444033472*^9}, {3.5044668554645157`*^9, 3.504466864174528*^9}, {
   3.5053446928838563`*^9, 3.5053446928838563`*^9}, 3.509475497876134*^9, 
   3.510166782291628*^9, 3.510523778505186*^9, {3.510523957585437*^9, 
   3.5105239613954425`*^9}, {3.5105240766056037`*^9, 3.510524076785604*^9}, 
   3.5105251963671713`*^9, {3.5107875049756804`*^9, 3.510787506515682*^9}, {
   3.510789330398236*^9, 3.5107893325682387`*^9}, {3.514855709953556*^9, 
   3.5148557180343704`*^9}, {3.515181069922325*^9, 3.515181076505536*^9}, 
   3.5151817165734606`*^9, {3.5151886574942026`*^9, 3.515188664074212*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Piecewise constant extraction", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, {3.4976627907155895`*^9, 
   3.497662798718403*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SubscriptBox["\[PartialD]", "z"], 
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"f", "[", "z", "]"}]], 
      SqrtBox[
       RowBox[{"1", "/", 
        RowBox[{"f", "[", "z", "]"}]}]]}], ")"}]}], "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, {3.497640194989707*^9, 
   3.4976402054105253`*^9}, 3.497640444886546*^9, {3.50474982887571*^9, 
   3.504749836455721*^9}, {3.5047498695657673`*^9, 3.5047498727757716`*^9}, {
   3.5072605288062344`*^9, 3.5072605314582396`*^9}, {3.5075717121274023`*^9, 
   3.507571727117423*^9}, {3.50758176808795*^9, 3.5075817732679577`*^9}, {
   3.507583363755458*^9, 3.5075833689814672`*^9}, {3.510507619932962*^9, 
   3.51050763590739*^9}, {3.5106050833413134`*^9, 3.510605087834121*^9}, 
   3.51060524079239*^9, {3.5148562497457047`*^9, 3.5148562594021215`*^9}}],

Cell[TextData[{
 "Rule t: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{
     RowBox[{"m", "-", 
      FractionBox["1", "2"]}], "\[Element]", "\[DoubleStruckCapitalZ]"}], " ",
     "\[And]", " ", 
    RowBox[{
     RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.5004320083900976`*^9, 
   3.5004320093321514`*^9}, {3.5013559257793446`*^9, 
   3.5013559257793446`*^9}, {3.5013564069000177`*^9, 3.501356418530034*^9}, {
   3.5026761650200815`*^9, 3.5026762017401333`*^9}, {3.5026762588802133`*^9, 
   3.5026762588802133`*^9}, {3.5026784726933126`*^9, 
   3.5026784726933126`*^9}, {3.5027658552205725`*^9, 
   3.5027658552205725`*^9}, {3.5027672224669743`*^9, 
   3.5027672224669743`*^9}, {3.5037105948225365`*^9, 3.503710605582552*^9}, {
   3.5037107610527697`*^9, 3.5037107610527697`*^9}, 3.503812941222491*^9, {
   3.5040286741277885`*^9, 3.50402867512619*^9}, 3.504031838526546*^9, 
   3.504311148611575*^9, {3.504764105847949*^9, 3.5047641154079623`*^9}, {
   3.5047641477280073`*^9, 3.504764147948008*^9}, 3.505005742172364*^9, {
   3.5080368114491596`*^9, 3.5080368579840417`*^9}, 3.5080374691155157`*^9, {
   3.5105233710346155`*^9, 3.510523371184616*^9}, {3.5105252878872995`*^9, 
   3.510525294107308*^9}, {3.51052584282408*^9, 3.51052584282408*^9}, {
   3.510788027396412*^9, 3.510788030076415*^9}, {3.5107882657767453`*^9, 
   3.5107883208568225`*^9}, {3.510789664430705*^9, 3.5107896743807187`*^9}, 
   3.510790463911824*^9, {3.510790613852034*^9, 3.5107906179920397`*^9}, {
   3.510813336637003*^9, 3.510813336637003*^9}, {3.5108459293657985`*^9, 
   3.5108459592866507`*^9}, {3.5139582932649612`*^9, 
   3.5139582932649612`*^9}, {3.5144737224586697`*^9, 
   3.5144737231762714`*^9}, {3.514856076991001*^9, 3.514856078005003*^9}, 
   3.5151817190538645`*^9}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}], "m"], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
     SqrtBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}]]}]}], 
   SqrtBox[
    RowBox[{"Sin", "[", 
     RowBox[{"c", "+", 
      RowBox[{"d", " ", "x"}]}], "]"}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "m"]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.503710177051952*^9, 
   3.503710199091983*^9}, {3.503710750612755*^9, 3.5037107533527584`*^9}, {
   3.5038127194681015`*^9, 3.503812750902157*^9}, {3.503812801680246*^9, 
   3.503812802335447*^9}, {3.5047496671454835`*^9, 3.504749688715514*^9}, {
   3.504749718855556*^9, 3.50474975738561*^9}, {3.5047638556975985`*^9, 
   3.504763901217663*^9}, {3.508036862352049*^9, 3.5080368741144695`*^9}, {
   3.5080369099321327`*^9, 3.5080369437529917`*^9}, {3.5080372899175997`*^9, 
   3.5080373156732454`*^9}, {3.5105229603279085`*^9, 3.510522986598355*^9}, {
   3.51052302367962*^9, 3.5105231196509886`*^9}, {3.510523163455866*^9, 
   3.5105231707566786`*^9}, {3.510524911966773*^9, 3.510524925296792*^9}, {
   3.510525184087154*^9, 3.510525188787161*^9}, {3.510787470405632*^9, 
   3.5107874992156725`*^9}, {3.510788066946467*^9, 3.5107880746864777`*^9}, {
   3.510788210246668*^9, 3.510788212636671*^9}, {3.510788384636912*^9, 
   3.5107883946369257`*^9}, {3.5107885351071224`*^9, 
   3.5107885379071264`*^9}, {3.5107893359082437`*^9, 3.5107893412382507`*^9}, 
   3.5107893780883026`*^9, 3.510845655897318*^9, {3.5151681385243998`*^9, 
   3.515168153484421*^9}, {3.5151886982342596`*^9, 3.515188700664263*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ")"}], "^", "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Dist", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}], "*", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", "*", "x"}]}], "]"}], "]"}]}], ",", 
     "\[IndentingNewLine]", "    ", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
         "n"}], "/", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "m"}]}], ",", "x"}], 
      "]"}]}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"k", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"IntegerQ", "[", 
     RowBox[{"m", "-", 
      RowBox[{"1", "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"k", "===", "1"}], " ", "||", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "<", "m", "<", "1"}], " ", "&&", " ", 
       RowBox[{
        RowBox[{"-", "1"}], "\[LessEqual]", "n", "<", "1"}]}]}], 
     ")"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5037104243322983`*^9, {3.5037104552623415`*^9, 
   3.503710552022477*^9}, {3.503710643442605*^9, 3.5037106540026197`*^9}, {
   3.50371079008281*^9, 3.503710799252823*^9}, 3.503711336573575*^9, 
   3.503812879274782*^9, 3.503812944763697*^9, {3.5047499105558243`*^9, 
   3.5047499251058445`*^9}, 3.504749962655897*^9, 3.50475000012595*^9, {
   3.5047639369577127`*^9, 3.5047639996578007`*^9}, {3.508012492437707*^9, 
   3.5080125039037275`*^9}, {3.50803744317267*^9, 3.5080375004559703`*^9}, {
   3.5080380525409403`*^9, 3.508038060340954*^9}, {3.510523241955203*^9, 
   3.5105233462245812`*^9}, {3.5105249344968047`*^9, 
   3.5105249997668962`*^9}, {3.510525218367202*^9, 3.510525225307212*^9}, 
   3.5105258453340836`*^9, 3.5105261705445385`*^9, 3.5105287370781317`*^9, {
   3.510787941316291*^9, 3.5107879840363507`*^9}, {3.510788306106802*^9, 
   3.5107883445268555`*^9}, {3.510788495777067*^9, 3.510788532967119*^9}, {
   3.5107885649971647`*^9, 3.5107885715471735`*^9}, {3.5107893516982656`*^9, 
   3.510789366068286*^9}, {3.5107896328306603`*^9, 3.5107896399606705`*^9}, {
   3.5107898766310015`*^9, 3.510789877641003*^9}, {3.5107904722018356`*^9, 
   3.5107904864718556`*^9}, {3.5107906016920166`*^9, 3.5107906035620193`*^9}, 
   3.5108133336573973`*^9, {3.510813433138772*^9, 3.5108134492536*^9}, {
   3.5108135037444963`*^9, 3.510813509516506*^9}, {3.510813560575396*^9, 
   3.5108135638826017`*^9}, {3.5108452158985453`*^9, 
   3.5108453343027534`*^9}, {3.5108456732445483`*^9, 
   3.5108456896245775`*^9}, {3.510845924108589*^9, 3.510845925356591*^9}, 
   3.5139582753849363`*^9, {3.515978214781052*^9, 3.515978215405053*^9}, 
   3.516821193557214*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "11"}], "-", "12"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5029872669066153`*^9, 
   3.5029872688410187`*^9}, 3.50447039389947*^9, {3.504832475130316*^9, 
   3.5048324800403223`*^9}, {3.504839667912388*^9, 3.50483966942239*^9}, {
   3.5053446893538513`*^9, 3.5053446893638515`*^9}, {3.509847525518984*^9, 
   3.509847525868984*^9}, 3.510182658202551*^9, 3.5102519372561398`*^9, {
   3.513094242920149*^9, 3.513094243122949*^9}, {3.5151810815911455`*^9, 
   3.5151810829639473`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 4a with ",
 Cell[BoxData[
  RowBox[{"n", "=", "2"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.504923521959998*^9, 3.504923555010044*^9}, 3.504923770360346*^9, {
   3.5051582547497196`*^9, 3.5051582724797444`*^9}, 3.505345087504409*^9, 
   3.512064373762556*^9, {3.5141422156002674`*^9, 3.514142233760293*^9}}],

Cell[TextData[{
 "Rule 11: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", 
     " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[LessEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.500410576940289*^9, 3.5004105779663477`*^9}, {
   3.5004106327664824`*^9, 3.500410643898119*^9}, {3.500429569940626*^9, 
   3.500429571675726*^9}, {3.502204840167862*^9, 3.502204842617066*^9}, 
   3.5023038294281306`*^9, {3.504362658868907*^9, 3.504362660078909*^9}, {
   3.50436465472136*^9, 3.5043646556213617`*^9}, {3.504839359121956*^9, 
   3.5048393791619835`*^9}, {3.504839672312394*^9, 3.5048396733523955`*^9}, 
   3.5098341584452877`*^9, {3.5101828092264166`*^9, 3.5101828193196344`*^9}, {
   3.511720157673427*^9, 3.5117201786434565`*^9}, {3.514744003801747*^9, 
   3.5147440340117893`*^9}, {3.5147478169478626`*^9, 
   3.5147478169478626`*^9}, {3.514750371932459*^9, 3.5147503725724597`*^9}, {
   3.516667478009576*^9, 3.5166674796787786`*^9}, {3.516817799992463*^9, 
   3.516817803002467*^9}, {3.5168465845798664`*^9, 3.516846584748876*^9}, {
   3.5168467054147778`*^9, 3.5168467143122864`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{
        SuperscriptBox["a", "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "1"}], "2"]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
      RowBox[{"m", "+", 
       RowBox[{"j", " ", "k"}]}]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             SuperscriptBox["b", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"j", " ", "k", " ", "m"}], "+", 
             FractionBox[
              RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5098341849653344`*^9, 3.509834296848731*^9}, {3.5098343294527884`*^9, 
   3.509834364194049*^9}, 3.5098346591437674`*^9, {3.5098347856443896`*^9, 
   3.5098347898251967`*^9}, {3.5098348311028695`*^9, 
   3.5098349107098093`*^9}, {3.5098349437662673`*^9, 3.509834983374737*^9}, 
   3.5098350560552645`*^9, {3.5098351175973725`*^9, 3.509835139499811*^9}, 
   3.5098475309589915`*^9, {3.510182683146995*^9, 3.5101826880610037`*^9}, {
   3.5101828251228447`*^9, 3.5101828513152905`*^9}, {3.510182945071455*^9, 
   3.5101829454458556`*^9}, {3.5147476258631268`*^9, 3.514747668217201*^9}, {
   3.515168162984434*^9, 3.515168166514439*^9}, {3.5168172892217484`*^9, 
   3.516817329061804*^9}, {3.5168173611018486`*^9, 3.5168174045619097`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a", "^", "2"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2", "*", "a", "*", "b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "^", "2"}], "+", 
                  RowBox[{"b", "^", "2"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], "\[NotEqual]", "0"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, 3.4993574899767523`*^9, {3.4993576909831047`*^9, 
   3.4993577157403483`*^9}, 3.4993578086385117`*^9, {3.4993579390391407`*^9, 
   3.4993579651067867`*^9}, {3.4993580774113836`*^9, 3.4993580785501857`*^9}, 
   3.499358991716386*^9, {3.4993590256364326`*^9, 3.499359034196445*^9}, 
   3.499359158156618*^9, {3.499359230066719*^9, 3.4993592406667337`*^9}, {
   3.499363855658249*^9, 3.499363864218261*^9}, {3.4993753165091624`*^9, 
   3.499375327739178*^9}, {3.500317979448513*^9, 3.500317979729314*^9}, {
   3.500318356413175*^9, 3.5003183706092*^9}, {3.500319044263768*^9, 
   3.5003190515337787`*^9}, {3.500321448217134*^9, 3.5003214542871428`*^9}, {
   3.500432003250804*^9, 3.5004320043278656`*^9}, {3.5010431659740324`*^9, 
   3.5010431675511227`*^9}, {3.5013560814295626`*^9, 
   3.5013561004895887`*^9}, {3.50135618678971*^9, 3.5013562181997538`*^9}, {
   3.5013562556298065`*^9, 3.5013562631598167`*^9}, {3.5013563481499357`*^9, 
   3.501356350129938*^9}, {3.5013563916299963`*^9, 3.501356393369999*^9}, 
   3.501356538350202*^9, {3.5013565824102635`*^9, 3.5013565889502726`*^9}, 
   3.502675840959628*^9, {3.5026759066297197`*^9, 3.502675919529738*^9}, {
   3.5026760125798683`*^9, 3.5026760334598975`*^9}, {3.5026762053901386`*^9, 
   3.5026762059201393`*^9}, {3.5026762389901853`*^9, 3.5026762460801954`*^9}, 
   3.5027656584730268`*^9, 3.5027671152479863`*^9, {3.5030718189880323`*^9, 
   3.5030718291780467`*^9}, 3.5038761961479836`*^9, {3.504156546965613*^9, 
   3.504156548322815*^9}, {3.5042968954456654`*^9, 3.5042969168056955`*^9}, {
   3.5051010426366124`*^9, 3.505101050326623*^9}, 3.5053446414337845`*^9, {
   3.5053446931938567`*^9, 3.505344715043887*^9}, 3.50535355708521*^9, {
   3.509473076633647*^9, 3.509473117827003*^9}, 3.509473221522934*^9, {
   3.5094732830534534`*^9, 3.509473292318983*^9}, {3.5094751195374947`*^9, 
   3.5094751247597933`*^9}, 3.5098352718192434`*^9, {3.509835307137706*^9, 
   3.5098353487273784`*^9}, {3.509847535218998*^9, 3.5098475613690343`*^9}, {
   3.5101827112582445`*^9, 3.510182715657452*^9}, {3.510182781661168*^9, 
   3.5101827868091774`*^9}, {3.5101830769696865`*^9, 3.510183111738948*^9}, {
   3.5101832687064238`*^9, 3.5101832709372272`*^9}, {3.5141423751504908`*^9, 
   3.5141423757704916`*^9}, {3.5147439123716187`*^9, 3.514743933871649*^9}, 
   3.5147446642726717`*^9, {3.514747728448907*^9, 3.5147478089606485`*^9}, {
   3.5147490781026425`*^9, 3.514749100622674*^9}, {3.5147503434924192`*^9, 
   3.51475034434242*^9}, {3.5147503886824827`*^9, 3.514750391992487*^9}, {
   3.5148450753940706`*^9, 3.5148450784048758`*^9}, 3.5148464258932433`*^9, {
   3.515978258507929*^9, 3.5159782601459317`*^9}, {3.516667408215053*^9, 
   3.5166674330346966`*^9}, 3.516817705502331*^9, {3.516817855572541*^9, 
   3.516817866932557*^9}, {3.5168430219180937`*^9, 3.5168430349398384`*^9}, {
   3.5168430993135204`*^9, 3.5168431185036182`*^9}, {3.516843294539687*^9, 
   3.516843311431653*^9}, {3.5168435329023204`*^9, 3.516843534695423*^9}, {
   3.516846645594356*^9, 3.5168466906729345`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 3a with ",
 Cell[BoxData[
  RowBox[{"n", "=", "2"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722470936061*^9, 3.501722471263662*^9}, {3.501722511371332*^9, 
   3.501722513914137*^9}, {3.5017225883886676`*^9, 3.501722594472678*^9}, {
   3.501722636046751*^9, 3.501722636405552*^9}, {3.501722673970418*^9, 
   3.5017227105524817`*^9}, {3.503880515951973*^9, 3.5038805176835756`*^9}, {
   3.5038805488524303`*^9, 3.5038805721276717`*^9}, {3.503881323994993*^9, 
   3.5038813546802473`*^9}, {3.5049162938617954`*^9, 
   3.5049163006634073`*^9}, {3.5049224814485416`*^9, 
   3.5049225441586294`*^9}, {3.504922716808871*^9, 3.5049227329788933`*^9}, {
   3.504923521959998*^9, 3.504923555010044*^9}, 3.504923770360346*^9, 
   3.5051582547497196`*^9, 3.505345123234459*^9, 3.512064363572542*^9, {
   3.5141417607096305`*^9, 3.514141791039673*^9}}],

Cell[TextData[{
 "Rule 12: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", 
     " ", 
     RowBox[{
      RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
      RowBox[{"-", "1"}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993592718267775`*^9, 
   3.4993592794067883`*^9}, {3.499363873578274*^9, 3.4993638796182823`*^9}, {
   3.50031965968463*^9, 3.5003196639146357`*^9}, {3.500345120088499*^9, 
   3.500345127428509*^9}, {3.5004296044446*^9, 3.5004296054856596`*^9}, {
   3.500564276738323*^9, 3.500564276738323*^9}, {3.500564478977479*^9, 
   3.500564478977479*^9}, {3.5012690944074793`*^9, 3.501269096907482*^9}, {
   3.502989419757598*^9, 3.5029894266684093`*^9}, {3.504382491914279*^9, 
   3.5043824931842804`*^9}, 3.5044145181527205`*^9, 3.5044145651527863`*^9, {
   3.5048326294605317`*^9, 3.5048326318105345`*^9}, {3.504832848270838*^9, 
   3.504832848820839*^9}, {3.5048395473922195`*^9, 3.504839551752225*^9}, {
   3.5048396769524*^9, 3.504839677692402*^9}, {3.508452034081811*^9, 
   3.508452034081811*^9}, 3.5098354484687543`*^9, 3.509911360347663*^9, {
   3.5101827988991985`*^9, 3.5101828019568033`*^9}, {3.5101832031707087`*^9, 
   3.5101832041847105`*^9}, {3.5117201893934717`*^9, 
   3.5117201893934717`*^9}, {3.513095241718216*^9, 3.513095242088216*^9}, 
   3.514142335340435*^9, {3.5141424490905943`*^9, 3.51414246048061*^9}, {
   3.514743996101736*^9, 3.5147439975317383`*^9}, {3.5147440486318097`*^9, 
   3.514744051131813*^9}, {3.5147478342170925`*^9, 3.5147478342170925`*^9}, {
   3.514750376522465*^9, 3.5147503771424665`*^9}, {3.514846444067275*^9, 
   3.514846444067275*^9}, {3.516667472845967*^9, 3.516667473703968*^9}, {
   3.51684679198973*^9, 3.516846798265088*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "2"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"j", " ", "k", " ", "m"}], "+", 
     FractionBox[
      RowBox[{"k", "+", "3"}], "2"]}]], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
       RowBox[{"2", " ", "a", " ", "b", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "3"}], "2"]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, {3.501043182982005*^9, 3.501043190019408*^9}, {
   3.502999922267273*^9, 3.5029999245372763`*^9}, 3.505344641393784*^9, {
   3.5053446930938563`*^9, 3.505344715003887*^9}, 3.5053535501052*^9, 
   3.5094714967392817`*^9, {3.5094716071916*^9, 3.509471662428759*^9}, {
   3.509471696610714*^9, 3.5094717281785192`*^9}, {3.509471786124834*^9, 
   3.509471792090175*^9}, {3.509471873836851*^9, 3.509471876436*^9}, {
   3.5098355380753117`*^9, 3.509835661752329*^9}, {3.509835695323588*^9, 
   3.509835698927194*^9}, {3.50983577051572*^9, 3.5098358512614617`*^9}, {
   3.5101827368266892`*^9, 3.510182745344304*^9}, {3.5101829999523516`*^9, 
   3.510183019686386*^9}, {3.5141418979198227`*^9, 3.5141419241998596`*^9}, {
   3.5147435787611513`*^9, 3.5147435797411532`*^9}, {3.5147476814772243`*^9, 
   3.514747716062485*^9}, {3.5151681708944454`*^9, 3.5151681725644474`*^9}, {
   3.5168440232983694`*^9, 3.51684405670028*^9}, {3.5168440956495075`*^9, 
   3.5168441158936653`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}, {
   3.5147491445027356`*^9, 3.514749148342741*^9}, {3.5147494086131053`*^9, 
   3.5147494108531084`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "2"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"b", "^", "2"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"j", "*", "k", "*", "m"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\n", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "^", "2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "^", "2"}], "+", 
               RowBox[{"b", "^", "2"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"2", "*", "a", "*", "b", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "\[NotEqual]", "0"}], 
    " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500432015647513*^9, 
   3.5004320167615767`*^9}, {3.501043209599528*^9, 3.5010432350499835`*^9}, 
   3.5026771020013933`*^9, {3.502677180841504*^9, 3.5026772181615562`*^9}, {
   3.502677352241744*^9, 3.5026773539717464`*^9}, 3.5027670707255077`*^9, {
   3.503071968728242*^9, 3.503071977848255*^9}, 3.5038761956487827`*^9, {
   3.5040290099495783`*^9, 3.504029011478381*^9}, {3.5041565286043806`*^9, 
   3.504156530008383*^9}, {3.5042865784817295`*^9, 3.5042866008017607`*^9}, {
   3.5042870585024014`*^9, 3.5042870681924148`*^9}, {3.504287484912998*^9, 
   3.504287490763006*^9}, {3.5042940452901697`*^9, 3.5042940507501793`*^9}, 
   3.5042956788330393`*^9, {3.504296854565608*^9, 3.5042968614056177`*^9}, {
   3.505100941436471*^9, 3.505100953336488*^9}, {3.505101028776593*^9, 
   3.5051010300865946`*^9}, 3.505344641403784*^9, {3.5053446931238565`*^9, 
   3.5053447150138874`*^9}, 3.5053535519652023`*^9, 3.509472213767294*^9, 
   3.509472341770615*^9, {3.5094725099262333`*^9, 3.5094725194427776`*^9}, 
   3.50947329995942*^9, {3.5094751389386044`*^9, 3.5094751435978703`*^9}, {
   3.5098354697627916`*^9, 3.5098355203848805`*^9}, 3.5098359872937007`*^9, {
   3.5098960849679213`*^9, 3.5098960888835287`*^9}, {3.510182753081918*^9, 
   3.510182757356325*^9}, {3.510182792409587*^9, 3.51018279393839*^9}, {
   3.5101831393977966`*^9, 3.510183166900645*^9}, 3.5101832074919157`*^9, {
   3.511230925630887*^9, 3.511231030416271*^9}, {3.511231196884164*^9, 
   3.51123121187579*^9}, {3.51137244511103*^9, 3.5113724654451933`*^9}, {
   3.5141421386201596`*^9, 3.5141421590801883`*^9}, {3.51414236028047*^9, 
   3.5141423608904705`*^9}, {3.5141424184805517`*^9, 
   3.5141424322505703`*^9}, {3.5141460785056753`*^9, 
   3.5141460939756975`*^9}, {3.5147439520716743`*^9, 3.514743957471682*^9}, {
   3.5147439903217278`*^9, 3.51474399196173*^9}, {3.514747841127905*^9, 
   3.5147478750579643`*^9}, {3.5147491159326954`*^9, 3.514749138692727*^9}, {
   3.5147494142431135`*^9, 3.514749424923128*^9}, {3.5147503475624247`*^9, 
   3.5147503486024265`*^9}, {3.5147503951024914`*^9, 3.514750400342499*^9}, {
   3.514750467732593*^9, 3.514750472272599*^9}, {3.514845069856061*^9, 
   3.5148450718840647`*^9}, {3.514846430214451*^9, 3.514846438903666*^9}, {
   3.5159782709847507`*^9, 3.5159782725447536`*^9}, {3.516667438541507*^9, 
   3.5166674656699543`*^9}, 3.516820655696461*^9, {3.5168437743921328`*^9, 
   3.5168437759472218`*^9}, {3.5168442302392054`*^9, 3.516844262995079*^9}, {
   3.5168467726686244`*^9, 3.5168467756947975`*^9}, {3.516846975037199*^9, 
   3.5168469753042145`*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "9"}], "-", "10"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661951449715*^9, 3.497661953243718*^9}, 3.4979216298462095`*^9, {
   3.504470970480277*^9, 3.504470974790283*^9}, {3.504988512420684*^9, 
   3.5049885147006874`*^9}, 3.505344689173851*^9, 3.509847506058957*^9, 
   3.5100197256274047`*^9, 3.5105084716008577`*^9, {3.5120540754101243`*^9, 
   3.512054075710125*^9}, {3.5130944045676327`*^9, 3.513094442101299*^9}, {
   3.5130950994180164`*^9, 3.5130951030580215`*^9}, 3.5141478502481556`*^9, 
   3.5151809681117454`*^9, {3.5165577648714886`*^9, 3.5165577665094914`*^9}, 
   3.5165590889674115`*^9, {3.5165908173996325`*^9, 3.5165908203896365`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Reference: G&R 2.552.3", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976406080004325`*^9, 
   3.4976407686675158`*^9, {3.4976412761676073`*^9, 3.497641276370407*^9}, {
   3.4976413811245914`*^9, 3.4976414279246736`*^9}, 3.4976415918497615`*^9, 
   3.4976416712695007`*^9, 3.497641808362542*^9, 3.49764211453668*^9, {
   3.497924167175066*^9, 3.4979241674870663`*^9}, {3.5053542426761694`*^9, 
   3.50535424295617*^9}}],

Cell[TextData[{
 "Derivation: Rule 1c with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, 3.5053451232244587`*^9, 
   3.5120643314424973`*^9, {3.5141470715870657`*^9, 3.5141471052171125`*^9}, {
   3.51655758332517*^9, 3.516557597209194*^9}}],

Cell[TextData[{
 "Rule 9: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, 
   3.4976407280762444`*^9, {3.497641501151202*^9, 3.4976415155344276`*^9}, {
   3.497641730440405*^9, 3.4976417406740227`*^9}, {3.497641822620967*^9, 
   3.4976418815034714`*^9}, {3.498241427414454*^9, 3.498241427414454*^9}, {
   3.504395896295714*^9, 3.50439590067572*^9}, 3.5044706093797717`*^9, 
   3.5044710537703934`*^9, {3.5044821550764217`*^9, 3.504482155386422*^9}, {
   3.504988576070773*^9, 3.5049885764507737`*^9}, {3.506213896034247*^9, 
   3.5062138967830486`*^9}, {3.5062141332678576`*^9, 
   3.5062141507378817`*^9}, {3.5105084879028864`*^9, 3.510508488090087*^9}, {
   3.5130944226480646`*^9, 3.5130944467345066`*^9}, 3.51309510891803*^9, 
   3.514147239737301*^9, {3.514487372506321*^9, 3.5144873727363214`*^9}, {
   3.5165576820821433`*^9, 3.5165576820821433`*^9}, {3.5165582083062663`*^9, 
   3.5165582086338673`*^9}, 3.5165908254196434`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "+", "1"}]]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "-", 
       RowBox[{"b", " ", 
        RowBox[{"(", 
         RowBox[{"n", "+", "2"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.509829149023255*^9, 3.5098292074833364`*^9}, {
   3.510174642911626*^9, 3.51017464554803*^9}, {3.5101749019344807`*^9, 
   3.5101749115128975`*^9}, {3.5151682059644947`*^9, 
   3.5151682096244993`*^9}, {3.5165572858550477`*^9, 
   3.5165572982414694`*^9}, {3.5165573471007557`*^9, 3.51655734967476*^9}, {
   3.5165574453897276`*^9, 3.5165574940930133`*^9}, {3.516557561453932*^9, 
   3.5165575717343493`*^9}, {3.516557624244042*^9, 3.5165576267244463`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, 3.5145876116205716`*^9, 3.516558062505211*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"sin", "[", 
       RowBox[{"c_.", "+", 
        RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "b"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"n", "+", "1"}], ")"}]}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", "^", "2"}], "-", 
          RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}]}], " ", "+", " ", "\n", 
    "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}]}], ")"}]}], ")"}]}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "-", 
           RowBox[{"b", "*", 
            RowBox[{"(", 
             RowBox[{"n", "+", "2"}], ")"}], "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "x"}], "]"}], 
    " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976406000756187`*^9, 
   3.4976407755003276`*^9, {3.497641256215172*^9, 3.4976412598187785`*^9}, 
   3.4976414964243937`*^9, 3.4976416664178925`*^9, 3.497641799704527*^9, {
   3.497641972467231*^9, 3.497641974682435*^9}, 3.497642107953469*^9, {
   3.4976421580451565`*^9, 3.49764215997956*^9}, {3.4979216146361823`*^9, 
   3.4979216448378353`*^9}, 3.4979241751310797`*^9, {3.4979242573432245`*^9, 
   3.497924266984041*^9}, {3.498241439764471*^9, 3.4982414602545*^9}, {
   3.5031146206925497`*^9, 3.503114629912166*^9}, {3.5031577379184756`*^9, 
   3.5031577418808823`*^9}, {3.503158883390085*^9, 3.503158888428894*^9}, 
   3.5053446400137825`*^9, {3.5053446892738514`*^9, 3.505344713643885*^9}, 
   3.505345556345065*^9, 3.508439139200802*^9, {3.5098475120089655`*^9, 
   3.5098475136889677`*^9}, 3.5114592311065884`*^9, 3.5118056919098177`*^9, 
   3.5141779771176*^9, 3.5145876116205716`*^9, {3.516557907221739*^9, 
   3.5165579990566998`*^9}, 3.516558061366409*^9, {3.5165581695401983`*^9, 
   3.516558171100201*^9}},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell["Reference: G&R 2.552.3 inverted", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975780869725127`*^9, 3.4975780962225256`*^9}, 3.497583103771538*^9, 
   3.49758316261162*^9, 3.4975833001918125`*^9, 3.4979236752126017`*^9, {
   3.4981984369814916`*^9, 3.4981984396334963`*^9}, {3.498241110914011*^9, 
   3.498241114334016*^9}, {3.5053542774362183`*^9, 3.505354277856219*^9}}],

Cell[TextData[{
 "Derivation: Rule 3b with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox[
    RowBox[{"k", "-", "1"}], "2"]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.501722402935542*^9, 3.5017224033411427`*^9}, 3.5017229817901583`*^9, 
   3.5017231707844906`*^9, 3.5017234546797895`*^9, {3.5017235643791823`*^9, 
   3.501723566750386*^9}, {3.5017250640438175`*^9, 3.5017250769294395`*^9}, {
   3.501725550171871*^9, 3.501725550671072*^9}, {3.5017278201126595`*^9, 
   3.501727826898671*^9}, {3.5017278619207325`*^9, 3.5017279153196263`*^9}, {
   3.501727996595769*^9, 3.50172799715737*^9}, {3.501728047857459*^9, 
   3.501728055751073*^9}, {3.5017281686076717`*^9, 3.501728169060073*^9}, {
   3.5017287195538397`*^9, 3.50172872538825*^9}, {3.50172921540071*^9, 
   3.5017292168983135`*^9}, {3.501729246943966*^9, 3.5017292537299776`*^9}, {
   3.5017295437928877`*^9, 3.5017295745093417`*^9}, {3.5017296960647554`*^9, 
   3.501729696314356*^9}, {3.5017298761514716`*^9, 3.5017298771342735`*^9}, {
   3.501729942248788*^9, 3.501729967068431*^9}, {3.5017301202763004`*^9, 
   3.501730120603901*^9}, {3.501730162162374*^9, 3.5017301694943867`*^9}, {
   3.501730682335688*^9, 3.501730694191709*^9}, {3.501730983011017*^9, 
   3.501731011652667*^9}, {3.5017312520178895`*^9, 3.501731277820335*^9}, {
   3.5017313805309153`*^9, 3.5017313819349174`*^9}, {3.501732216760784*^9, 
   3.5017322266044016`*^9}, {3.501732477218842*^9, 3.501732508434497*^9}, {
   3.501732542832557*^9, 3.501732562925392*^9}, {3.5017328634443207`*^9, 
   3.5017328811347513`*^9}, 3.5053451232244587`*^9, {3.5102632131400013`*^9, 
   3.5102632375300355`*^9}, {3.5104225256204214`*^9, 3.5104225256204214`*^9}, 
   3.5120643626225405`*^9, {3.5141467446466084`*^9, 3.514146749056614*^9}, {
   3.514146800286686*^9, 3.514146806916695*^9}, {3.5141469844369435`*^9, 
   3.5141469907669525`*^9}, {3.516558258593955*^9, 3.5165582611367593`*^9}}],

Cell[TextData[{
 "Rule 10: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["k", "2"], "=", 
   RowBox[{"1", " ", "\[And]", " ", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}], " ", "\[And]", " ", 
    RowBox[{"n", ">", "1"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.497665001317472*^9, 3.4976650255131145`*^9}, {3.4986778951385884`*^9, 
   3.4986779035186005`*^9}, {3.4986779431286554`*^9, 
   3.4986779431286554`*^9}, {3.504364584041261*^9, 3.504364585481263*^9}, {
   3.5043646357213335`*^9, 3.5043646359213343`*^9}, {3.5043679570379877`*^9, 
   3.504367958197989*^9}, 3.5049832861833677`*^9, 3.5049833569634666`*^9, {
   3.5051849569721966`*^9, 3.5051849812355843`*^9}, {3.5102679880166864`*^9, 
   3.5102679904066896`*^9}, {3.5102687753677883`*^9, 3.510268782577799*^9}, {
   3.5102868863104877`*^9, 3.5102868869032884`*^9}, {3.5102869285553617`*^9, 
   3.5102869294913635`*^9}, {3.510508500086508*^9, 3.5105085005233088`*^9}, {
   3.5141472920273743`*^9, 3.5141472938373766`*^9}, {3.514147377677494*^9, 
   3.5141473784874954`*^9}, {3.5141527536711903`*^9, 
   3.5141527536711903`*^9}, {3.5144867262354164`*^9, 
   3.5144867264954166`*^9}, {3.514645411720581*^9, 3.5146454121573815`*^9}, {
   3.5146523075870323`*^9, 3.5146523079170327`*^9}, 3.516558268562372*^9, {
   3.5165588925538673`*^9, 3.5165588928346677`*^9}, {3.516590828319648*^9, 
   3.5165908294796495`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Sin", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     FractionBox[
      RowBox[{"k", "-", "1"}], "2"]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"b", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], 
          FractionBox[
           RowBox[{"k", "-", "1"}], "2"]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
          RowBox[{"n", "-", "1"}]]}], 
        RowBox[{"d", " ", "n"}]]}]}]}]}]}], "+", "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", "n"], " ", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], ")"}], 
      FractionBox[
       RowBox[{"k", "-", "1"}], "2"]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], " ", "n"}], "+", 
       RowBox[{
        SuperscriptBox["b", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}]}], "+", 
       RowBox[{"a", " ", "b", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "-", "1"}], ")"}], 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "-", "2"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.4992